/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DiskInfoTest {
    private static final String GENERATED_ID = "42";
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final DiskInfo.CreationStatus CREATION_STATUS = DiskInfo.CreationStatus.READY;
    private static final String DESCRIPTION = "description";
    private static final Long SIZE_GB = 500L;
    private static final DiskTypeId TYPE = DiskTypeId.of((String)"project", (String)"zone", (String)"disk");
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final List<InstanceId> ATTACHED_INSTANCES = ImmutableList.of((Object)InstanceId.of((String)"project", (String)"zone", (String)"instance1"), (Object)InstanceId.of((String)"project", (String)"zone", (String)"instance2"));
    private static final SnapshotId SNAPSHOT = SnapshotId.of((String)"project", (String)"snapshot");
    private static final ImageId IMAGE = ImageId.of((String)"project", (String)"image");
    private static final String SNAPSHOT_ID = "snapshotId";
    private static final String IMAGE_ID = "snapshotId";
    private static final Long LAST_ATTACH_TIMESTAMP = 1453293600000L;
    private static final Long LAST_DETACH_TIMESTAMP = 1453293660000L;
    private static final StandardDiskConfiguration DISK_CONFIGURATION = ((StandardDiskConfiguration.Builder)StandardDiskConfiguration.builder().sizeGb(SIZE_GB).diskType(TYPE)).build();
    private static final SnapshotDiskConfiguration SNAPSHOT_DISK_CONFIGURATION = ((SnapshotDiskConfiguration.Builder)SnapshotDiskConfiguration.builder((SnapshotId)SNAPSHOT).sizeGb(SIZE_GB).diskType(TYPE)).sourceSnapshotId("snapshotId").build();
    private static final ImageDiskConfiguration IMAGE_DISK_CONFIGURATION = ((ImageDiskConfiguration.Builder)ImageDiskConfiguration.builder((ImageId)IMAGE).sizeGb(SIZE_GB).diskType(TYPE)).sourceImageId("snapshotId").build();
    private static final DiskInfo DISK_INFO = DiskInfo.builder((DiskId)DISK_ID, (DiskConfiguration)DISK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description("description").licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();
    private static final DiskInfo SNAPSHOT_DISK_INFO = DiskInfo.builder((DiskId)DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description("description").licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();
    private static final DiskInfo IMAGE_DISK_INFO = DiskInfo.builder((DiskId)DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description("description").licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();

    @Test
    public void testToBuilder() {
        this.compareDiskInfo(DISK_INFO, DISK_INFO.toBuilder().build());
        this.compareDiskInfo(IMAGE_DISK_INFO, IMAGE_DISK_INFO.toBuilder().build());
        this.compareDiskInfo(SNAPSHOT_DISK_INFO, SNAPSHOT_DISK_INFO.toBuilder().build());
        DiskInfo diskInfo = DISK_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)diskInfo.description());
        diskInfo = diskInfo.toBuilder().description(DESCRIPTION).build();
        this.compareDiskInfo(DISK_INFO, diskInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        DiskInfo diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)DISK_CONFIGURATION);
        Assert.assertEquals((Object)diskInfo, (Object)diskInfo.toBuilder().build());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION);
        Assert.assertEquals((Object)diskInfo, (Object)diskInfo.toBuilder().build());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION);
        Assert.assertEquals((Object)diskInfo, (Object)diskInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)DISK_INFO.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)DISK_INFO.diskId());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)DISK_INFO.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)DISK_INFO.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)DISK_INFO.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DISK_INFO.description());
        Assert.assertEquals(LICENSES, (Object)DISK_INFO.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)DISK_INFO.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)DISK_INFO.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)DISK_INFO.lastDetachTimestamp());
        Assert.assertEquals((Object)GENERATED_ID, (Object)IMAGE_DISK_INFO.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)IMAGE_DISK_INFO.diskId());
        Assert.assertEquals((Object)IMAGE_DISK_CONFIGURATION, (Object)IMAGE_DISK_INFO.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)IMAGE_DISK_INFO.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)IMAGE_DISK_INFO.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)IMAGE_DISK_INFO.description());
        Assert.assertEquals(LICENSES, (Object)IMAGE_DISK_INFO.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)IMAGE_DISK_INFO.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)IMAGE_DISK_INFO.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)IMAGE_DISK_INFO.lastDetachTimestamp());
        Assert.assertEquals((Object)GENERATED_ID, (Object)SNAPSHOT_DISK_INFO.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)SNAPSHOT_DISK_INFO.diskId());
        Assert.assertEquals((Object)SNAPSHOT_DISK_CONFIGURATION, (Object)SNAPSHOT_DISK_INFO.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)SNAPSHOT_DISK_INFO.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)SNAPSHOT_DISK_INFO.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)SNAPSHOT_DISK_INFO.description());
        Assert.assertEquals(LICENSES, (Object)SNAPSHOT_DISK_INFO.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)SNAPSHOT_DISK_INFO.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)SNAPSHOT_DISK_INFO.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)SNAPSHOT_DISK_INFO.lastDetachTimestamp());
    }

    @Test
    public void testOf() {
        DiskInfo diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)DISK_CONFIGURATION);
        Assert.assertNull((Object)diskInfo.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)diskInfo.diskId());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)diskInfo.configuration());
        Assert.assertNull((Object)diskInfo.creationTimestamp());
        Assert.assertNull((Object)diskInfo.creationStatus());
        Assert.assertNull((Object)diskInfo.description());
        Assert.assertNull((Object)diskInfo.licenses());
        Assert.assertNull((Object)diskInfo.attachedInstances());
        Assert.assertNull((Object)diskInfo.lastAttachTimestamp());
        Assert.assertNull((Object)diskInfo.lastDetachTimestamp());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION);
        Assert.assertNull((Object)diskInfo.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)diskInfo.diskId());
        Assert.assertEquals((Object)IMAGE_DISK_CONFIGURATION, (Object)diskInfo.configuration());
        Assert.assertNull((Object)diskInfo.creationTimestamp());
        Assert.assertNull((Object)diskInfo.creationStatus());
        Assert.assertNull((Object)diskInfo.description());
        Assert.assertNull((Object)diskInfo.licenses());
        Assert.assertNull((Object)diskInfo.attachedInstances());
        Assert.assertNull((Object)diskInfo.lastAttachTimestamp());
        Assert.assertNull((Object)diskInfo.lastDetachTimestamp());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION);
        Assert.assertNull((Object)diskInfo.generatedId());
        Assert.assertEquals((Object)DISK_ID, (Object)diskInfo.diskId());
        Assert.assertEquals((Object)SNAPSHOT_DISK_CONFIGURATION, (Object)diskInfo.configuration());
        Assert.assertNull((Object)diskInfo.creationTimestamp());
        Assert.assertNull((Object)diskInfo.creationStatus());
        Assert.assertNull((Object)diskInfo.description());
        Assert.assertNull((Object)diskInfo.licenses());
        Assert.assertNull((Object)diskInfo.attachedInstances());
        Assert.assertNull((Object)diskInfo.lastAttachTimestamp());
        Assert.assertNull((Object)diskInfo.lastDetachTimestamp());
    }

    @Test
    public void testToAndFromPb() {
        DiskInfo diskInfo = DiskInfo.fromPb((Disk)DISK_INFO.toPb());
        this.compareDiskInfo(DISK_INFO, diskInfo);
        diskInfo = DiskInfo.fromPb((Disk)SNAPSHOT_DISK_INFO.toPb());
        this.compareDiskInfo(SNAPSHOT_DISK_INFO, diskInfo);
        diskInfo = DiskInfo.fromPb((Disk)IMAGE_DISK_INFO.toPb());
        this.compareDiskInfo(IMAGE_DISK_INFO, diskInfo);
        Disk disk = new Disk().setSelfLink(DISK_ID.selfLink()).setType(TYPE.selfLink()).setSizeGb(SIZE_GB);
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)DISK_CONFIGURATION);
        this.compareDiskInfo(diskInfo, DiskInfo.fromPb((Disk)disk));
        disk = new Disk().setType(TYPE.selfLink()).setSizeGb(SIZE_GB).setSelfLink(DISK_ID.selfLink()).setSourceSnapshotId("snapshotId").setSourceSnapshot(SNAPSHOT.selfLink());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION);
        this.compareDiskInfo(diskInfo, DiskInfo.fromPb((Disk)disk));
        disk = new Disk().setType(TYPE.selfLink()).setSizeGb(SIZE_GB).setSelfLink(DISK_ID.selfLink()).setSourceImageId("snapshotId").setSourceImage(IMAGE.selfLink());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION);
        this.compareDiskInfo(diskInfo, DiskInfo.fromPb((Disk)disk));
    }

    @Test
    public void testSetProjectId() {
        StandardDiskConfiguration standardDiskConfiguration = ((StandardDiskConfiguration.Builder)DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)TYPE.zone(), (String)TYPE.type()))).build();
        DiskInfo diskInfo = DISK_INFO.toBuilder().diskId(DiskId.of((String)DISK_ID.zone(), (String)DISK_ID.disk())).configuration((DiskConfiguration)standardDiskConfiguration).build();
        this.compareDiskInfo(DISK_INFO, diskInfo.setProjectId("project"));
        SnapshotDiskConfiguration snapshotDiskConfiguration = ((SnapshotDiskConfiguration.Builder)SNAPSHOT_DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)TYPE.zone(), (String)TYPE.type()))).sourceSnapshot(SnapshotId.of((String)SNAPSHOT.snapshot())).build();
        diskInfo = SNAPSHOT_DISK_INFO.toBuilder().diskId(DiskId.of((String)DISK_ID.zone(), (String)DISK_ID.disk())).configuration((DiskConfiguration)snapshotDiskConfiguration).build();
        this.compareDiskInfo(SNAPSHOT_DISK_INFO, diskInfo.setProjectId("project"));
        ImageDiskConfiguration imageDiskConfiguration = ((ImageDiskConfiguration.Builder)IMAGE_DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)TYPE.zone(), (String)TYPE.type()))).sourceImage(ImageId.of((String)IMAGE.image())).build();
        diskInfo = IMAGE_DISK_INFO.toBuilder().diskId(DiskId.of((String)DISK_ID.zone(), (String)DISK_ID.disk())).configuration((DiskConfiguration)imageDiskConfiguration).build();
        this.compareDiskInfo(IMAGE_DISK_INFO, diskInfo.setProjectId("project"));
    }

    public void compareDiskInfo(DiskInfo expected, DiskInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.diskId(), (Object)value.diskId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.creationStatus(), (Object)value.creationStatus());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.attachedInstances(), (Object)value.attachedInstances());
        Assert.assertEquals((Object)expected.lastAttachTimestamp(), (Object)value.lastAttachTimestamp());
        Assert.assertEquals((Object)expected.lastDetachTimestamp(), (Object)value.lastDetachTimestamp());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

