/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DiskTest {
    private static final String GENERATED_ID = "42";
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final DiskInfo.CreationStatus CREATION_STATUS = DiskInfo.CreationStatus.READY;
    private static final String DESCRIPTION = "description";
    private static final Long SIZE_GB = 500L;
    private static final DiskTypeId TYPE = DiskTypeId.of((String)"project", (String)"zone", (String)"disk");
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final List<InstanceId> ATTACHED_INSTANCES = ImmutableList.of((Object)InstanceId.of((String)"project", (String)"zone", (String)"instance1"), (Object)InstanceId.of((String)"project", (String)"zone", (String)"instance2"));
    private static final SnapshotId SNAPSHOT = SnapshotId.of((String)"project", (String)"snapshot");
    private static final ImageId IMAGE = ImageId.of((String)"project", (String)"image");
    private static final String SNAPSHOT_ID = "snapshotId";
    private static final String IMAGE_ID = "imageId";
    private static final Long LAST_ATTACH_TIMESTAMP = 1453293600000L;
    private static final Long LAST_DETACH_TIMESTAMP = 1453293660000L;
    private static final StandardDiskConfiguration DISK_CONFIGURATION = ((StandardDiskConfiguration.Builder)StandardDiskConfiguration.builder().sizeGb(SIZE_GB).diskType(TYPE)).build();
    private static final SnapshotDiskConfiguration SNAPSHOT_DISK_CONFIGURATION = ((SnapshotDiskConfiguration.Builder)SnapshotDiskConfiguration.builder((SnapshotId)SNAPSHOT).sizeGb(SIZE_GB).diskType(TYPE)).sourceSnapshotId("snapshotId").build();
    private static final ImageDiskConfiguration IMAGE_DISK_CONFIGURATION = ((ImageDiskConfiguration.Builder)ImageDiskConfiguration.builder((ImageId)IMAGE).sizeGb(SIZE_GB).diskType(TYPE)).sourceImageId("imageId").build();
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Disk disk;
    private Disk standardDisk;
    private Disk snapshotDisk;
    private Disk imageDisk;

    private void initializeExpectedDisk(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.standardDisk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description(DESCRIPTION).licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();
        this.snapshotDisk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description(DESCRIPTION).licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();
        this.imageDisk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description(DESCRIPTION).licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).lastAttachTimestamp(LAST_ATTACH_TIMESTAMP).lastDetachTimestamp(LAST_DETACH_TIMESTAMP).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeDisk() {
        this.disk = new Disk.Builder(this.compute, DISK_ID, (DiskConfiguration)DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).creationStatus(CREATION_STATUS).description(DESCRIPTION).licenses(LICENSES).attachedInstances(ATTACHED_INSTANCES).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedDisk(16);
        this.compareDisk(this.standardDisk, this.standardDisk.toBuilder().build());
        this.compareDisk(this.imageDisk, this.imageDisk.toBuilder().build());
        this.compareDisk(this.snapshotDisk, this.snapshotDisk.toBuilder().build());
        Disk newDisk = this.standardDisk.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newDisk.description());
        newDisk = newDisk.toBuilder().description(DESCRIPTION).build();
        this.compareDisk(this.standardDisk, newDisk);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedDisk(18);
        DiskInfo diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)DISK_CONFIGURATION);
        Disk disk = new Disk(this.serviceMockReturnsOptions, new DiskInfo.BuilderImpl(diskInfo));
        this.compareDisk(disk, disk.toBuilder().build());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION);
        disk = new Disk(this.serviceMockReturnsOptions, new DiskInfo.BuilderImpl(diskInfo));
        this.compareDisk(disk, disk.toBuilder().build());
        diskInfo = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION);
        disk = new Disk(this.serviceMockReturnsOptions, new DiskInfo.BuilderImpl(diskInfo));
        this.compareDisk(disk, disk.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedDisk(4);
        Assert.assertEquals((Object)DISK_ID, (Object)this.standardDisk.diskId());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.standardDisk.generatedId());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)this.standardDisk.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.standardDisk.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)this.standardDisk.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.standardDisk.description());
        Assert.assertEquals(LICENSES, (Object)this.standardDisk.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)this.standardDisk.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)this.standardDisk.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)this.standardDisk.lastDetachTimestamp());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.standardDisk.compute());
        Assert.assertEquals((Object)DISK_ID, (Object)this.imageDisk.diskId());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.imageDisk.generatedId());
        Assert.assertEquals((Object)IMAGE_DISK_CONFIGURATION, (Object)this.imageDisk.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.imageDisk.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)this.imageDisk.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.imageDisk.description());
        Assert.assertEquals(LICENSES, (Object)this.imageDisk.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)this.imageDisk.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)this.imageDisk.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)this.imageDisk.lastDetachTimestamp());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.imageDisk.compute());
        Assert.assertEquals((Object)DISK_ID, (Object)this.snapshotDisk.diskId());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.snapshotDisk.generatedId());
        Assert.assertEquals((Object)SNAPSHOT_DISK_CONFIGURATION, (Object)this.snapshotDisk.configuration());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.snapshotDisk.creationTimestamp());
        Assert.assertEquals((Object)CREATION_STATUS, (Object)this.snapshotDisk.creationStatus());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.snapshotDisk.description());
        Assert.assertEquals(LICENSES, (Object)this.snapshotDisk.licenses());
        Assert.assertEquals(ATTACHED_INSTANCES, (Object)this.snapshotDisk.attachedInstances());
        Assert.assertEquals((Object)LAST_ATTACH_TIMESTAMP, (Object)this.snapshotDisk.lastAttachTimestamp());
        Assert.assertEquals((Object)LAST_DETACH_TIMESTAMP, (Object)this.snapshotDisk.lastDetachTimestamp());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.snapshotDisk.compute());
        Disk disk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)DISK_CONFIGURATION).diskId(DiskId.of((String)"newProject", (String)"newZone")).configuration((DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION).build();
        Assert.assertEquals((Object)DiskId.of((String)"newProject", (String)"newZone"), (Object)disk.diskId());
        Assert.assertNull((Object)disk.generatedId());
        Assert.assertEquals((Object)SNAPSHOT_DISK_CONFIGURATION, (Object)disk.configuration());
        Assert.assertNull((Object)disk.creationTimestamp());
        Assert.assertNull((Object)disk.creationStatus());
        Assert.assertNull((Object)disk.description());
        Assert.assertNull((Object)disk.licenses());
        Assert.assertNull((Object)disk.attachedInstances());
        Assert.assertNull((Object)disk.lastAttachTimestamp());
        Assert.assertNull((Object)disk.lastDetachTimestamp());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)disk.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedDisk(24);
        this.compareDisk(this.standardDisk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)this.standardDisk.toPb()));
        this.compareDisk(this.imageDisk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)this.imageDisk.toPb()));
        this.compareDisk(this.snapshotDisk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)this.snapshotDisk.toPb()));
        Disk disk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)DISK_CONFIGURATION).build();
        this.compareDisk(disk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)disk.toPb()));
        disk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)SNAPSHOT_DISK_CONFIGURATION).build();
        this.compareDisk(disk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)disk.toPb()));
        disk = new Disk.Builder(this.serviceMockReturnsOptions, DISK_ID, (DiskConfiguration)IMAGE_DISK_CONFIGURATION).build();
        this.compareDisk(disk, Disk.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Disk)disk.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteDisk(DISK_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedDisk(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteDisk(DISK_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertNull((Object)this.disk.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedDisk(3);
        Compute.DiskOption[] expectedOptions = new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getDisk(DISK_ID, expectedOptions)).andReturn((Object)this.imageDisk);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertTrue((boolean)this.disk.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedDisk(3);
        Compute.DiskOption[] expectedOptions = new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getDisk(DISK_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertFalse((boolean)this.disk.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedDisk(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getDisk(DISK_ID, new Compute.DiskOption[0])).andReturn((Object)this.imageDisk);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Disk updatedDisk = this.disk.reload(new Compute.DiskOption[0]);
        this.compareDisk(this.imageDisk, updatedDisk);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedDisk(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getDisk(DISK_ID, new Compute.DiskOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertNull((Object)this.disk.reload(new Compute.DiskOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedDisk(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getDisk(DISK_ID, new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])})).andReturn((Object)this.imageDisk);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Disk updatedDisk = this.disk.reload(new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])});
        this.compareDisk(this.imageDisk, updatedDisk);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testCreateSnapshot() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        SnapshotId snapshotId = SnapshotId.of((String)SNAPSHOT.snapshot());
        SnapshotInfo snapshot = SnapshotInfo.builder((SnapshotId)snapshotId, (DiskId)DISK_ID).build();
        EasyMock.expect((Object)this.compute.create(snapshot, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createSnapshot(SNAPSHOT.snapshot(), new Compute.OperationOption[0]));
    }

    @Test
    public void testCreateSnapshotWithDescription() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        SnapshotId snapshotId = SnapshotId.of((String)SNAPSHOT.snapshot());
        SnapshotInfo snapshot = SnapshotInfo.builder((SnapshotId)snapshotId, (DiskId)DISK_ID).description(DESCRIPTION).build();
        EasyMock.expect((Object)this.compute.create(snapshot, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createSnapshot(SNAPSHOT.snapshot(), DESCRIPTION, new Compute.OperationOption[0]));
    }

    @Test
    public void testCreateSnapshotWithOptions() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        SnapshotId snapshotId = SnapshotId.of((String)SNAPSHOT.snapshot());
        SnapshotInfo snapshot = SnapshotInfo.builder((SnapshotId)snapshotId, (DiskId)DISK_ID).build();
        EasyMock.expect((Object)this.compute.create(snapshot, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createSnapshot(SNAPSHOT.snapshot(), new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testCreateSnapshotWithDescriptionAndOptions() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        SnapshotId snapshotId = SnapshotId.of((String)SNAPSHOT.snapshot());
        SnapshotInfo snapshot = SnapshotInfo.builder((SnapshotId)snapshotId, (DiskId)DISK_ID).description(DESCRIPTION).build();
        EasyMock.expect((Object)this.compute.create(snapshot, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createSnapshot(SNAPSHOT.snapshot(), DESCRIPTION, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testCreateImage() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        ImageId imageId = ImageId.of((String)IMAGE.image());
        ImageInfo image = ImageInfo.of((ImageId)imageId, (ImageConfiguration)DiskImageConfiguration.of((DiskId)DISK_ID));
        EasyMock.expect((Object)this.compute.create(image, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createImage(IMAGE.image(), new Compute.OperationOption[0]));
    }

    @Test
    public void testCreateImageWithDescription() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        ImageId imageId = ImageId.of((String)IMAGE.image());
        ImageInfo image = ImageInfo.builder((ImageId)imageId, (ImageConfiguration)DiskImageConfiguration.of((DiskId)DISK_ID)).description(DESCRIPTION).build();
        EasyMock.expect((Object)this.compute.create(image, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createImage(IMAGE.image(), DESCRIPTION, new Compute.OperationOption[0]));
    }

    @Test
    public void testCreateImageWithOptions() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        ImageId imageId = ImageId.of((String)IMAGE.image());
        ImageInfo image = ImageInfo.of((ImageId)imageId, (ImageConfiguration)DiskImageConfiguration.of((DiskId)DISK_ID));
        EasyMock.expect((Object)this.compute.create(image, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createImage(IMAGE.image(), new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testCreateImageWithDescriptionAndOptions() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        ImageId imageId = ImageId.of((String)IMAGE.image());
        ImageInfo image = ImageInfo.builder((ImageId)imageId, (ImageConfiguration)DiskImageConfiguration.of((DiskId)DISK_ID)).description(DESCRIPTION).build();
        EasyMock.expect((Object)this.compute.create(image, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.createImage(IMAGE.image(), DESCRIPTION, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testResizeOperation() {
        this.initializeExpectedDisk(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"zone", (String)"op")).build();
        EasyMock.expect((Object)this.compute.resize(DISK_ID, 42L, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertSame((Object)operation, (Object)this.disk.resize(42L, new Compute.OperationOption[0]));
    }

    @Test
    public void testResizeNull() {
        this.initializeExpectedDisk(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.resize(DISK_ID, 42L, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeDisk();
        Assert.assertNull((Object)this.disk.resize(42L, new Compute.OperationOption[0]));
    }

    public void compareDisk(Disk expected, Disk value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.diskId(), (Object)value.diskId());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.creationStatus(), (Object)value.creationStatus());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.attachedInstances(), (Object)value.attachedInstances());
        Assert.assertEquals((Object)expected.lastAttachTimestamp(), (Object)value.lastAttachTimestamp());
        Assert.assertEquals((Object)expected.lastDetachTimestamp(), (Object)value.lastDetachTimestamp());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

