/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DiskTypeId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DiskTypeIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String DISK_TYPE = "diskType";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        DiskTypeId diskTypeId = DiskTypeId.of((String)PROJECT, (String)ZONE, (String)DISK_TYPE);
        Assert.assertEquals((Object)PROJECT, (Object)diskTypeId.project());
        Assert.assertEquals((Object)ZONE, (Object)diskTypeId.zone());
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskTypeId.type());
        Assert.assertEquals((Object)URL, (Object)diskTypeId.selfLink());
        diskTypeId = DiskTypeId.of((String)ZONE, (String)DISK_TYPE);
        Assert.assertNull((Object)diskTypeId.project());
        Assert.assertEquals((Object)ZONE, (Object)diskTypeId.zone());
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskTypeId.type());
    }

    @Test
    public void testToAndFromUrl() {
        DiskTypeId diskTypeId = DiskTypeId.of((String)PROJECT, (String)ZONE, (String)DISK_TYPE);
        Assert.assertSame((Object)diskTypeId, (Object)diskTypeId.setProjectId(PROJECT));
        this.compareDiskTypeId(diskTypeId, DiskTypeId.fromUrl((String)diskTypeId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid disk type URL");
        DiskTypeId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        DiskTypeId diskTypeId = DiskTypeId.of((String)PROJECT, (String)ZONE, (String)DISK_TYPE);
        Assert.assertSame((Object)diskTypeId, (Object)diskTypeId.setProjectId(PROJECT));
        this.compareDiskTypeId(diskTypeId, DiskTypeId.of((String)ZONE, (String)DISK_TYPE).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)DiskTypeId.matchesUrl((String)DiskTypeId.of((String)PROJECT, (String)ZONE, (String)DISK_TYPE).selfLink()));
        Assert.assertFalse((boolean)DiskTypeId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareDiskTypeId(DiskTypeId expected, DiskTypeId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.type(), (Object)expected.type());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

