/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ResourceId;
import org.junit.Assert;
import org.junit.Test;

public class DiskTypeTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final String VALID_DISK_SIZE = "10GB-10TB";
    private static final Long DEFAULT_DISK_SIZE_GB = 10L;
    private static final DiskTypeId DISK_TYPE_ID = DiskTypeId.of((String)"project", (String)"zone", (String)"diskType");
    private static final DeprecationStatus<DiskTypeId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)DISK_TYPE_ID);
    private static final DiskType DISK_TYPE = DiskType.builder().generatedId("42").diskTypeId(DISK_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").validDiskSize("10GB-10TB").defaultDiskSizeGb(DEFAULT_DISK_SIZE_GB).deprecationStatus(DEPRECATION_STATUS).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)DISK_TYPE.generatedId());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)DISK_TYPE.diskTypeId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)DISK_TYPE.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DISK_TYPE.description());
        Assert.assertEquals((Object)VALID_DISK_SIZE, (Object)DISK_TYPE.validDiskSize());
        Assert.assertEquals((Object)DEFAULT_DISK_SIZE_GB, (Object)DISK_TYPE.defaultDiskSizeGb());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)DISK_TYPE.deprecationStatus());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareDiskTypes(DISK_TYPE, DiskType.fromPb((com.google.api.services.compute.model.DiskType)DISK_TYPE.toPb()));
        DiskType diskType = DiskType.builder().diskTypeId(DISK_TYPE_ID).build();
        this.compareDiskTypes(diskType, DiskType.fromPb((com.google.api.services.compute.model.DiskType)diskType.toPb()));
    }

    private void compareDiskTypes(DiskType expected, DiskType value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.diskTypeId(), (Object)value.diskTypeId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.validDiskSize(), (Object)value.validDiskSize());
        Assert.assertEquals((Object)expected.defaultDiskSizeGb(), (Object)value.defaultDiskSizeGb());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

