/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ForwardingRuleId;
import com.google.cloud.compute.GlobalForwardingRuleId;
import com.google.cloud.compute.RegionForwardingRuleId;
import com.google.cloud.compute.RegionId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ForwardingRuleIdTest {
    private static final String PROJECT = "project";
    private static final String REGION = "region";
    private static final String NAME = "rule";
    private static final String GLOBAL_URL = "https://www.googleapis.com/compute/v1/projects/project/global/forwardingRules/rule";
    private static final String REGION_URL = "https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/rule";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        GlobalForwardingRuleId forwardingRuleId = GlobalForwardingRuleId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)forwardingRuleId.project());
        Assert.assertEquals((Object)NAME, (Object)forwardingRuleId.rule());
        Assert.assertEquals((Object)GLOBAL_URL, (Object)forwardingRuleId.selfLink());
        Assert.assertEquals((Object)ForwardingRuleId.Type.GLOBAL, (Object)forwardingRuleId.type());
        forwardingRuleId = GlobalForwardingRuleId.of((String)NAME);
        Assert.assertNull((Object)forwardingRuleId.project());
        Assert.assertEquals((Object)NAME, (Object)forwardingRuleId.rule());
        Assert.assertEquals((Object)ForwardingRuleId.Type.GLOBAL, (Object)forwardingRuleId.type());
        RegionForwardingRuleId regionForwardingRuleId = RegionForwardingRuleId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)regionForwardingRuleId.project());
        Assert.assertEquals((Object)REGION, (Object)regionForwardingRuleId.region());
        Assert.assertEquals((Object)NAME, (Object)regionForwardingRuleId.rule());
        Assert.assertEquals((Object)REGION_URL, (Object)regionForwardingRuleId.selfLink());
        Assert.assertEquals((Object)ForwardingRuleId.Type.REGION, (Object)regionForwardingRuleId.type());
        regionForwardingRuleId = RegionForwardingRuleId.of((RegionId)RegionId.of((String)PROJECT, (String)REGION), (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)regionForwardingRuleId.project());
        Assert.assertEquals((Object)REGION, (Object)regionForwardingRuleId.region());
        Assert.assertEquals((Object)NAME, (Object)regionForwardingRuleId.rule());
        Assert.assertEquals((Object)REGION_URL, (Object)regionForwardingRuleId.selfLink());
        Assert.assertEquals((Object)ForwardingRuleId.Type.REGION, (Object)regionForwardingRuleId.type());
        regionForwardingRuleId = RegionForwardingRuleId.of((String)REGION, (String)NAME);
        Assert.assertNull((Object)regionForwardingRuleId.project());
        Assert.assertEquals((Object)REGION, (Object)regionForwardingRuleId.region());
        Assert.assertEquals((Object)NAME, (Object)regionForwardingRuleId.rule());
        Assert.assertEquals((Object)ForwardingRuleId.Type.REGION, (Object)regionForwardingRuleId.type());
    }

    @Test
    public void testToAndFromUrlGlobal() {
        GlobalForwardingRuleId forwardingRuleId = GlobalForwardingRuleId.of((String)PROJECT, (String)NAME);
        this.compareGlobalForwardingRuleId(forwardingRuleId, GlobalForwardingRuleId.fromUrl((String)forwardingRuleId.selfLink()));
        RegionForwardingRuleId regionForwardingRuleId = RegionForwardingRuleId.of((String)PROJECT, (String)REGION, (String)NAME);
        this.compareRegionForwardingRuleId(regionForwardingRuleId, RegionForwardingRuleId.fromUrl((String)regionForwardingRuleId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid global forwarding rule URL");
        GlobalForwardingRuleId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testToAndFromUrlRegion() {
        RegionForwardingRuleId regionForwardingRuleId = RegionForwardingRuleId.of((String)PROJECT, (String)REGION, (String)NAME);
        this.compareRegionForwardingRuleId(regionForwardingRuleId, RegionForwardingRuleId.fromUrl((String)regionForwardingRuleId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid region forwarding rule URL");
        RegionForwardingRuleId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        GlobalForwardingRuleId forwardingRuleId = GlobalForwardingRuleId.of((String)PROJECT, (String)NAME);
        Assert.assertSame((Object)forwardingRuleId, (Object)forwardingRuleId.setProjectId(PROJECT));
        this.compareGlobalForwardingRuleId(forwardingRuleId, GlobalForwardingRuleId.of((String)NAME).setProjectId(PROJECT));
        RegionForwardingRuleId regionForwardingRuleId = RegionForwardingRuleId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertSame((Object)regionForwardingRuleId, (Object)regionForwardingRuleId.setProjectId(PROJECT));
        this.compareRegionForwardingRuleId(regionForwardingRuleId, RegionForwardingRuleId.of((String)REGION, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)GlobalForwardingRuleId.matchesUrl((String)GlobalForwardingRuleId.of((String)PROJECT, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)GlobalForwardingRuleId.matchesUrl((String)"notMatchingUrl"));
        Assert.assertTrue((boolean)RegionForwardingRuleId.matchesUrl((String)RegionForwardingRuleId.of((String)PROJECT, (String)REGION, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)RegionForwardingRuleId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareGlobalForwardingRuleId(GlobalForwardingRuleId expected, GlobalForwardingRuleId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.rule(), (Object)expected.rule());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }

    private void compareRegionForwardingRuleId(RegionForwardingRuleId expected, RegionForwardingRuleId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.region(), (Object)expected.region());
        Assert.assertEquals((Object)expected.rule(), (Object)expected.rule());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

