/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import org.junit.Assert;
import org.junit.Test;

public class ImageDiskConfigurationTest {
    private static final Long SIZE = 42L;
    private static final DiskTypeId DISK_TYPE = DiskTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final ImageId IMAGE = ImageId.of((String)"project", (String)"image");
    private static final String IMAGE_ID = "imageId";
    private static final ImageDiskConfiguration DISK_CONFIGURATION = ((ImageDiskConfiguration.Builder)ImageDiskConfiguration.builder((ImageId)IMAGE).sizeGb(SIZE).diskType(DISK_TYPE)).sourceImageId("imageId").build();

    @Test
    public void testToBuilder() {
        this.compareImageDiskConfiguration(DISK_CONFIGURATION, DISK_CONFIGURATION.toBuilder().build());
        ImageId newImageId = ImageId.of((String)"newProject", (String)"newImage");
        ImageDiskConfiguration diskConfiguration = DISK_CONFIGURATION.toBuilder().sizeGb(Long.valueOf(24L)).sourceImage(newImageId).sourceImageId("newImageId").build();
        Assert.assertEquals((long)24L, (long)diskConfiguration.sizeGb());
        Assert.assertEquals((Object)newImageId, (Object)diskConfiguration.sourceImage());
        Assert.assertEquals((Object)"newImageId", (Object)diskConfiguration.sourceImageId());
        diskConfiguration = diskConfiguration.toBuilder().sizeGb(SIZE).sourceImage(IMAGE).sourceImageId(IMAGE_ID).build();
        this.compareImageDiskConfiguration(DISK_CONFIGURATION, diskConfiguration);
    }

    @Test
    public void testToBuilderIncomplete() {
        ImageDiskConfiguration diskConfiguration = ImageDiskConfiguration.of((ImageId)IMAGE);
        this.compareImageDiskConfiguration(diskConfiguration, diskConfiguration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DISK_TYPE, (Object)DISK_CONFIGURATION.diskType());
        Assert.assertEquals((Object)SIZE, (Object)DISK_CONFIGURATION.sizeGb());
        Assert.assertEquals((Object)IMAGE, (Object)DISK_CONFIGURATION.sourceImage());
        Assert.assertEquals((Object)IMAGE_ID, (Object)DISK_CONFIGURATION.sourceImageId());
        Assert.assertEquals((Object)DiskConfiguration.Type.IMAGE, (Object)DISK_CONFIGURATION.type());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()) instanceof ImageDiskConfiguration));
        this.compareImageDiskConfiguration(DISK_CONFIGURATION, (ImageDiskConfiguration)DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()));
    }

    @Test
    public void testOf() {
        ImageDiskConfiguration configuration = ImageDiskConfiguration.of((ImageId)IMAGE);
        Assert.assertNull((Object)configuration.diskType());
        Assert.assertNull((Object)configuration.sizeGb());
        Assert.assertNull((Object)configuration.sourceImageId());
        Assert.assertEquals((Object)IMAGE, (Object)configuration.sourceImage());
        Assert.assertEquals((Object)DiskConfiguration.Type.IMAGE, (Object)configuration.type());
    }

    @Test
    public void testSetProjectId() {
        ImageDiskConfiguration diskConfiguration = ((ImageDiskConfiguration.Builder)DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)DISK_TYPE.zone(), (String)DISK_TYPE.type()))).sourceImage(ImageId.of((String)IMAGE.image())).build();
        this.compareImageDiskConfiguration(DISK_CONFIGURATION, diskConfiguration.setProjectId("project"));
    }

    private void compareImageDiskConfiguration(ImageDiskConfiguration expected, ImageDiskConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.diskType(), (Object)value.diskType());
        Assert.assertEquals((Object)expected.sizeGb(), (Object)value.sizeGb());
        Assert.assertEquals((Object)expected.sourceImage(), (Object)value.sourceImage());
        Assert.assertEquals((Object)expected.sourceImageId(), (Object)value.sourceImageId());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

