/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ImageId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImageIdTest {
    private static final String PROJECT = "project";
    private static final String NAME = "image";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/global/images/image";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        ImageId imageId = ImageId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)imageId.project());
        Assert.assertEquals((Object)NAME, (Object)imageId.image());
        Assert.assertEquals((Object)URL, (Object)imageId.selfLink());
        imageId = ImageId.of((String)NAME);
        Assert.assertNull((Object)imageId.project());
        Assert.assertEquals((Object)NAME, (Object)imageId.image());
    }

    @Test
    public void testToAndFromUrl() {
        ImageId imageId = ImageId.of((String)PROJECT, (String)NAME);
        this.compareImageId(imageId, ImageId.fromUrl((String)imageId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid image URL");
        ImageId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        ImageId imageId = ImageId.of((String)PROJECT, (String)NAME);
        Assert.assertSame((Object)imageId, (Object)imageId.setProjectId(PROJECT));
        this.compareImageId(imageId, ImageId.of((String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)ImageId.matchesUrl((String)ImageId.of((String)PROJECT, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)ImageId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareImageId(ImageId expected, ImageId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.image(), (Object)expected.image());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

