/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.StorageImageConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ImageInfoTest {
    private static final ImageId IMAGE_ID = ImageId.of((String)"project", (String)"image");
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final ImageInfo.Status STATUS = ImageInfo.Status.READY;
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final Long DISK_SIZE_GB = 42L;
    private static final String STORAGE_SOURCE = "source";
    private static final Long ARCHIVE_SIZE_BYTES = 24L;
    private static final String SHA1_CHECKSUM = "checksum";
    private static final DiskId SOURCE_DISK = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final String SOURCE_DISK_ID = "diskId";
    private static final ImageConfiguration.SourceType SOURCE_TYPE = ImageConfiguration.SourceType.RAW;
    private static final StorageImageConfiguration STORAGE_CONFIGURATION = ((StorageImageConfiguration.Builder)((StorageImageConfiguration.Builder)StorageImageConfiguration.builder((String)"source").archiveSizeBytes(ARCHIVE_SIZE_BYTES)).containerType(StorageImageConfiguration.ContainerType.TAR).sha1("checksum").sourceType(SOURCE_TYPE)).build();
    private static final DiskImageConfiguration DISK_CONFIGURATION = ((DiskImageConfiguration.Builder)((DiskImageConfiguration.Builder)DiskImageConfiguration.builder((DiskId)SOURCE_DISK).archiveSizeBytes(ARCHIVE_SIZE_BYTES)).sourceDiskId("diskId").sourceType(SOURCE_TYPE)).build();
    private static final DeprecationStatus<ImageId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)IMAGE_ID);
    private static final ImageInfo STORAGE_IMAGE = ImageInfo.builder((ImageId)IMAGE_ID, (ImageConfiguration)STORAGE_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).deprecationStatus(DEPRECATION_STATUS).build();
    private static final ImageInfo DISK_IMAGE = ImageInfo.builder((ImageId)IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).deprecationStatus(DEPRECATION_STATUS).build();

    @Test
    public void testToBuilder() {
        this.compareImageInfo(STORAGE_IMAGE, STORAGE_IMAGE.toBuilder().build());
        this.compareImageInfo(DISK_IMAGE, DISK_IMAGE.toBuilder().build());
        ImageInfo imageInfo = STORAGE_IMAGE.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)imageInfo.description());
        imageInfo = imageInfo.toBuilder().description(DESCRIPTION).build();
        this.compareImageInfo(STORAGE_IMAGE, imageInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        ImageInfo imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)STORAGE_CONFIGURATION);
        Assert.assertEquals((Object)imageInfo, (Object)imageInfo.toBuilder().build());
        imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION);
        Assert.assertEquals((Object)imageInfo, (Object)imageInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)STORAGE_IMAGE.generatedId());
        Assert.assertEquals((Object)IMAGE_ID, (Object)STORAGE_IMAGE.imageId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)STORAGE_IMAGE.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)STORAGE_IMAGE.description());
        Assert.assertEquals((Object)STORAGE_CONFIGURATION, (Object)STORAGE_IMAGE.configuration());
        Assert.assertEquals((Object)STATUS, (Object)STORAGE_IMAGE.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)STORAGE_IMAGE.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)STORAGE_IMAGE.licenses());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)STORAGE_IMAGE.deprecationStatus());
        Assert.assertEquals((Object)GENERATED_ID, (Object)DISK_IMAGE.generatedId());
        Assert.assertEquals((Object)IMAGE_ID, (Object)DISK_IMAGE.imageId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)DISK_IMAGE.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)DISK_IMAGE.description());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)DISK_IMAGE.configuration());
        Assert.assertEquals((Object)STATUS, (Object)DISK_IMAGE.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)DISK_IMAGE.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)DISK_IMAGE.licenses());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)DISK_IMAGE.deprecationStatus());
    }

    @Test
    public void testOf() {
        ImageInfo imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)STORAGE_CONFIGURATION);
        Assert.assertEquals((Object)IMAGE_ID, (Object)imageInfo.imageId());
        Assert.assertEquals((Object)STORAGE_CONFIGURATION, (Object)imageInfo.configuration());
        Assert.assertNull((Object)imageInfo.generatedId());
        Assert.assertNull((Object)imageInfo.creationTimestamp());
        Assert.assertNull((Object)imageInfo.description());
        Assert.assertNull((Object)imageInfo.status());
        Assert.assertNull((Object)imageInfo.diskSizeGb());
        Assert.assertNull((Object)imageInfo.licenses());
        Assert.assertNull((Object)imageInfo.deprecationStatus());
        imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION);
        Assert.assertEquals((Object)IMAGE_ID, (Object)imageInfo.imageId());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)imageInfo.configuration());
        Assert.assertNull((Object)imageInfo.generatedId());
        Assert.assertNull((Object)imageInfo.creationTimestamp());
        Assert.assertNull((Object)imageInfo.description());
        Assert.assertNull((Object)imageInfo.status());
        Assert.assertNull((Object)imageInfo.diskSizeGb());
        Assert.assertNull((Object)imageInfo.licenses());
        Assert.assertNull((Object)imageInfo.deprecationStatus());
    }

    @Test
    public void testToAndFromPb() {
        this.compareImageInfo(STORAGE_IMAGE, ImageInfo.fromPb((Image)STORAGE_IMAGE.toPb()));
        this.compareImageInfo(DISK_IMAGE, ImageInfo.fromPb((Image)DISK_IMAGE.toPb()));
        ImageInfo imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)StorageImageConfiguration.of((String)STORAGE_SOURCE));
        this.compareImageInfo(imageInfo, ImageInfo.fromPb((Image)imageInfo.toPb()));
        imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DiskImageConfiguration.of((DiskId)SOURCE_DISK));
        this.compareImageInfo(imageInfo, ImageInfo.fromPb((Image)imageInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        ImageInfo imageInfo = DISK_IMAGE.toBuilder().imageId(ImageId.of((String)"image")).configuration((ImageConfiguration)DISK_CONFIGURATION.toBuilder().sourceDisk(DiskId.of((String)"zone", (String)"disk")).build()).build();
        this.compareImageInfo(DISK_IMAGE, imageInfo.setProjectId("project"));
    }

    public void compareImageInfo(ImageInfo expected, ImageInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.imageId(), (Object)value.imageId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.diskSizeGb(), (Object)value.diskSizeGb());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

