/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.StorageImageConfiguration;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ImageTest {
    private static final ImageId IMAGE_ID = ImageId.of((String)"project", (String)"image");
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final ImageInfo.Status STATUS = ImageInfo.Status.READY;
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final Long DISK_SIZE_GB = 42L;
    private static final String STORAGE_SOURCE = "source";
    private static final Long ARCHIVE_SIZE_BYTES = 24L;
    private static final String SHA1_CHECKSUM = "checksum";
    private static final DiskId SOURCE_DISK = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final String SOURCE_DISK_ID = "diskId";
    private static final ImageConfiguration.SourceType SOURCE_TYPE = ImageConfiguration.SourceType.RAW;
    private static final StorageImageConfiguration STORAGE_CONFIGURATION = ((StorageImageConfiguration.Builder)((StorageImageConfiguration.Builder)StorageImageConfiguration.builder((String)"source").archiveSizeBytes(ARCHIVE_SIZE_BYTES)).containerType(StorageImageConfiguration.ContainerType.TAR).sha1("checksum").sourceType(SOURCE_TYPE)).build();
    private static final DiskImageConfiguration DISK_CONFIGURATION = ((DiskImageConfiguration.Builder)((DiskImageConfiguration.Builder)DiskImageConfiguration.builder((DiskId)SOURCE_DISK).archiveSizeBytes(ARCHIVE_SIZE_BYTES)).sourceDiskId("diskId").sourceType(SOURCE_TYPE)).build();
    private static final DeprecationStatus<ImageId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)IMAGE_ID);
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Image image;
    private Image diskImage;
    private Image storageImage;

    private void initializeExpectedImage(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.diskImage = new Image.Builder(this.serviceMockReturnsOptions, IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).deprecationStatus(DEPRECATION_STATUS).build();
        this.storageImage = new Image.Builder(this.serviceMockReturnsOptions, IMAGE_ID, (ImageConfiguration)STORAGE_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).deprecationStatus(DEPRECATION_STATUS).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeImage() {
        this.image = new Image.Builder(this.compute, IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).deprecationStatus(DEPRECATION_STATUS).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedImage(12);
        this.compareImage(this.diskImage, this.diskImage.toBuilder().build());
        this.compareImage(this.storageImage, this.storageImage.toBuilder().build());
        Image newImage = this.diskImage.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newImage.description());
        newImage = newImage.toBuilder().description(DESCRIPTION).build();
        this.compareImage(this.diskImage, newImage);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedImage(6);
        ImageInfo imageInfo = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION);
        Image image = new Image(this.serviceMockReturnsOptions, new ImageInfo.BuilderImpl(imageInfo));
        this.compareImage(image, image.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedImage(3);
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.diskImage.generatedId());
        Assert.assertEquals((Object)IMAGE_ID, (Object)this.diskImage.imageId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.diskImage.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.diskImage.description());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)this.diskImage.configuration());
        Assert.assertEquals((Object)STATUS, (Object)this.diskImage.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)this.diskImage.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)this.diskImage.licenses());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)this.diskImage.deprecationStatus());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.diskImage.compute());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.storageImage.generatedId());
        Assert.assertEquals((Object)IMAGE_ID, (Object)this.storageImage.imageId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.storageImage.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.storageImage.description());
        Assert.assertEquals((Object)STORAGE_CONFIGURATION, (Object)this.storageImage.configuration());
        Assert.assertEquals((Object)STATUS, (Object)this.storageImage.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)this.storageImage.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)this.storageImage.licenses());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)this.storageImage.deprecationStatus());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.storageImage.compute());
        ImageId imageId = ImageId.of((String)"otherImage");
        Image image = new Image.Builder(this.serviceMockReturnsOptions, IMAGE_ID, (ImageConfiguration)STORAGE_CONFIGURATION).imageId(imageId).configuration((ImageConfiguration)DISK_CONFIGURATION).build();
        Assert.assertNull((Object)image.generatedId());
        Assert.assertEquals((Object)imageId, (Object)image.imageId());
        Assert.assertNull((Object)image.creationTimestamp());
        Assert.assertNull((Object)image.description());
        Assert.assertEquals((Object)DISK_CONFIGURATION, (Object)image.configuration());
        Assert.assertNull((Object)image.status());
        Assert.assertNull((Object)image.diskSizeGb());
        Assert.assertNull((Object)image.licenses());
        Assert.assertNull((Object)image.deprecationStatus());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)image.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedImage(12);
        this.compareImage(this.diskImage, Image.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Image)this.diskImage.toPb()));
        this.compareImage(this.storageImage, Image.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Image)this.storageImage.toPb()));
        Image image = new Image.Builder(this.serviceMockReturnsOptions, IMAGE_ID, (ImageConfiguration)DISK_CONFIGURATION).build();
        this.compareImage(image, Image.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Image)image.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedImage(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteImage(IMAGE_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertSame((Object)operation, (Object)this.image.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedImage(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteImage(IMAGE_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertNull((Object)this.image.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedImage(2);
        Compute.ImageOption[] expectedOptions = new Compute.ImageOption[]{Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getImage(IMAGE_ID, expectedOptions)).andReturn((Object)this.diskImage);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertTrue((boolean)this.image.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedImage(2);
        Compute.ImageOption[] expectedOptions = new Compute.ImageOption[]{Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getImage(IMAGE_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertFalse((boolean)this.image.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedImage(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getImage(IMAGE_ID, new Compute.ImageOption[0])).andReturn((Object)this.storageImage);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Image updateImage = this.image.reload(new Compute.ImageOption[0]);
        this.compareImage(this.storageImage, updateImage);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedImage(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getImage(IMAGE_ID, new Compute.ImageOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertNull((Object)this.image.reload(new Compute.ImageOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedImage(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getImage(IMAGE_ID, new Compute.ImageOption[]{Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[0])})).andReturn((Object)this.storageImage);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Image updateImage = this.image.reload(new Compute.ImageOption[]{Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[0])});
        this.compareImage(this.storageImage, updateImage);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testDeprecateImage() {
        this.initializeExpectedImage(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        DeprecationStatus status = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DEPRECATED, (ResourceId)IMAGE_ID);
        EasyMock.expect((Object)this.compute.deprecate(IMAGE_ID, status, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertSame((Object)operation, (Object)this.image.deprecate(status, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeprecateNull() {
        this.initializeExpectedImage(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        DeprecationStatus status = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DEPRECATED, (ResourceId)IMAGE_ID);
        EasyMock.expect((Object)this.compute.deprecate(IMAGE_ID, status, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeImage();
        Assert.assertNull((Object)this.image.deprecate(status, new Compute.OperationOption[0]));
    }

    public void compareImage(Image expected, Image value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.imageId(), (Object)value.imageId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.diskSizeGb(), (Object)value.diskSizeGb());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

