/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.ZoneId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class InstanceIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String NAME = "instance";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        InstanceId instanceId = InstanceId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)instanceId.project());
        Assert.assertEquals((Object)ZONE, (Object)instanceId.zone());
        Assert.assertEquals((Object)NAME, (Object)instanceId.instance());
        Assert.assertEquals((Object)URL, (Object)instanceId.selfLink());
        instanceId = InstanceId.of((ZoneId)ZoneId.of((String)PROJECT, (String)ZONE), (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)instanceId.project());
        Assert.assertEquals((Object)ZONE, (Object)instanceId.zone());
        Assert.assertEquals((Object)NAME, (Object)instanceId.instance());
        Assert.assertEquals((Object)URL, (Object)instanceId.selfLink());
        instanceId = InstanceId.of((String)ZONE, (String)NAME);
        Assert.assertNull((Object)instanceId.project());
        Assert.assertEquals((Object)ZONE, (Object)instanceId.zone());
        Assert.assertEquals((Object)NAME, (Object)instanceId.instance());
    }

    @Test
    public void testToAndFromUrl() {
        InstanceId instanceId = InstanceId.of((String)PROJECT, (String)ZONE, (String)NAME);
        this.compareInstanceId(instanceId, InstanceId.fromUrl((String)instanceId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid instance URL");
        InstanceId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        InstanceId instanceId = InstanceId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertSame((Object)instanceId, (Object)instanceId.setProjectId(PROJECT));
        this.compareInstanceId(instanceId, InstanceId.of((String)ZONE, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)InstanceId.matchesUrl((String)InstanceId.of((String)PROJECT, (String)ZONE, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)InstanceId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareInstanceId(InstanceId expected, InstanceId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.instance(), (Object)expected.instance());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

