/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Instance;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.ServiceAccount;
import com.google.cloud.compute.Tags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class InstanceInfoTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final InstanceId INSTANCE_ID = InstanceId.of((String)"project", (String)"zone", (String)"instance");
    private static final InstanceInfo.Status STATUS = InstanceInfo.Status.RUNNING;
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final Tags TAGS = Tags.of((String[])new String[]{"tag1", "tag2"});
    private static final MachineTypeId MACHINE_TYPE = MachineTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final Boolean CAN_IP_FORWARD = true;
    private static final NetworkInterface NETWORK_INTERFACE = NetworkInterface.of((NetworkId)NetworkId.of((String)"project", (String)"network"));
    private static final List<NetworkInterface> NETWORK_INTERFACES = ImmutableList.of((Object)NETWORK_INTERFACE);
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final AttachedDisk ATTACHED_DISK = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID));
    private static final List<AttachedDisk> ATTACHED_DISKS = ImmutableList.of((Object)ATTACHED_DISK);
    private static final Metadata METADATA = Metadata.builder().add("key1", "value1").add("key2", "value2").build();
    private static final ServiceAccount SERVICE_ACCOUNT = ServiceAccount.of((String)"email", (List)ImmutableList.of((Object)"scope1"));
    private static final List<ServiceAccount> SERVICE_ACCOUNTS = ImmutableList.of((Object)SERVICE_ACCOUNT);
    private static final SchedulingOptions SCHEDULING_OPTIONS = SchedulingOptions.preemptible();
    private static final String CPU_PLATFORM = "cpuPlatform";
    private static final InstanceInfo INSTANCE_INFO = InstanceInfo.builder((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).statusMessage("statusMessage").tags(TAGS).canIpForward(CAN_IP_FORWARD).networkInterfaces(NETWORK_INTERFACES).attachedDisks(ATTACHED_DISKS).metadata(METADATA).serviceAccounts(SERVICE_ACCOUNTS).schedulingOptions(SCHEDULING_OPTIONS).cpuPlatform("cpuPlatform").build();

    @Test
    public void testToBuilder() {
        this.compareInstanceInfo(INSTANCE_INFO, INSTANCE_INFO.toBuilder().build());
        InstanceInfo instance = INSTANCE_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)instance.description());
        instance = instance.toBuilder().description(DESCRIPTION).build();
        this.compareInstanceInfo(INSTANCE_INFO, instance);
    }

    @Test
    public void testToBuilderIncomplete() {
        InstanceInfo instanceInfo = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        Assert.assertEquals((Object)instanceInfo, (Object)instanceInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)INSTANCE_INFO.generatedId());
        Assert.assertEquals((Object)INSTANCE_ID, (Object)INSTANCE_INFO.instanceId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)INSTANCE_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)INSTANCE_INFO.description());
        Assert.assertEquals((Object)STATUS, (Object)INSTANCE_INFO.status());
        Assert.assertEquals((Object)STATUS_MESSAGE, (Object)INSTANCE_INFO.statusMessage());
        Assert.assertEquals((Object)TAGS, (Object)INSTANCE_INFO.tags());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)INSTANCE_INFO.machineType());
        Assert.assertEquals((Object)CAN_IP_FORWARD, (Object)INSTANCE_INFO.canIpForward());
        Assert.assertEquals(NETWORK_INTERFACES, (Object)INSTANCE_INFO.networkInterfaces());
        Assert.assertEquals(ATTACHED_DISKS, (Object)INSTANCE_INFO.attachedDisks());
        Assert.assertEquals((Object)METADATA, (Object)INSTANCE_INFO.metadata());
        Assert.assertEquals(SERVICE_ACCOUNTS, (Object)INSTANCE_INFO.serviceAccounts());
        Assert.assertEquals((Object)SCHEDULING_OPTIONS, (Object)INSTANCE_INFO.schedulingOptions());
        Assert.assertEquals((Object)CPU_PLATFORM, (Object)INSTANCE_INFO.cpuPlatform());
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).statusMessage(STATUS_MESSAGE).tags(TAGS).canIpForward(CAN_IP_FORWARD).networkInterfaces(new NetworkInterface[]{NETWORK_INTERFACE}).attachedDisks(new AttachedDisk[]{ATTACHED_DISK}).metadata(METADATA).serviceAccounts(SERVICE_ACCOUNTS).schedulingOptions(SCHEDULING_OPTIONS).cpuPlatform(CPU_PLATFORM).build();
        this.compareInstanceInfo(INSTANCE_INFO, instanceInfo);
    }

    @Test
    public void testOf() {
        InstanceInfo instance = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        Assert.assertNull((Object)instance.generatedId());
        Assert.assertEquals((Object)INSTANCE_ID, (Object)instance.instanceId());
        Assert.assertNull((Object)instance.creationTimestamp());
        Assert.assertNull((Object)instance.description());
        Assert.assertNull((Object)instance.status());
        Assert.assertNull((Object)instance.statusMessage());
        Assert.assertNull((Object)instance.tags());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)instance.machineType());
        Assert.assertNull((Object)instance.canIpForward());
        Assert.assertEquals(NETWORK_INTERFACES, (Object)instance.networkInterfaces());
        Assert.assertEquals(ATTACHED_DISKS, (Object)instance.attachedDisks());
        Assert.assertNull((Object)instance.metadata());
        Assert.assertNull((Object)instance.serviceAccounts());
        Assert.assertNull((Object)instance.schedulingOptions());
        Assert.assertNull((Object)instance.cpuPlatform());
    }

    @Test
    public void testToAndFromPb() {
        this.compareInstanceInfo(INSTANCE_INFO, InstanceInfo.fromPb((Instance)INSTANCE_INFO.toPb()));
        InstanceInfo instance = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        this.compareInstanceInfo(instance, InstanceInfo.fromPb((Instance)instance.toPb()));
    }

    @Test
    public void testSetProjectId() {
        InstanceInfo instance = InstanceInfo.of((InstanceId)InstanceId.of((String)"zone", (String)"instance"), (MachineTypeId)MachineTypeId.of((String)"zone", (String)"type"), (AttachedDisk)AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)"zone", (String)"disk"))), (NetworkInterface)NetworkInterface.of((NetworkId)NetworkId.of((String)"project", (String)"network")));
        InstanceInfo instanceWithProject = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        this.compareInstanceInfo(instanceWithProject, instance.setProjectId("project"));
    }

    public void compareInstanceInfo(InstanceInfo expected, InstanceInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.instanceId(), (Object)value.instanceId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.statusMessage(), (Object)value.statusMessage());
        Assert.assertEquals((Object)expected.tags(), (Object)value.tags());
        Assert.assertEquals((Object)expected.machineType(), (Object)value.machineType());
        Assert.assertEquals((Object)expected.canIpForward(), (Object)value.canIpForward());
        Assert.assertEquals((Object)expected.networkInterfaces(), (Object)value.networkInterfaces());
        Assert.assertEquals((Object)expected.attachedDisks(), (Object)value.attachedDisks());
        Assert.assertEquals((Object)expected.metadata(), (Object)value.metadata());
        Assert.assertEquals((Object)expected.serviceAccounts(), (Object)value.serviceAccounts());
        Assert.assertEquals((Object)expected.schedulingOptions(), (Object)value.schedulingOptions());
        Assert.assertEquals((Object)expected.cpuPlatform(), (Object)value.cpuPlatform());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

