/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.ServiceAccount;
import com.google.cloud.compute.Tags;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class InstanceTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final InstanceId INSTANCE_ID = InstanceId.of((String)"project", (String)"zone", (String)"instance");
    private static final InstanceInfo.Status STATUS = InstanceInfo.Status.RUNNING;
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final Tags TAGS = Tags.builder((String[])new String[0]).values(new String[]{"tag1", "tag2"}).fingerprint("fingerprint").build();
    private static final MachineTypeId MACHINE_TYPE = MachineTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final Boolean CAN_IP_FORWARD = true;
    private static final NetworkInterface NETWORK_INTERFACE = NetworkInterface.of((NetworkId)NetworkId.of((String)"project", (String)"network"));
    private static final List<NetworkInterface> NETWORK_INTERFACES = ImmutableList.of((Object)NETWORK_INTERFACE);
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final AttachedDisk ATTACHED_DISK = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID));
    private static final List<AttachedDisk> ATTACHED_DISKS = ImmutableList.of((Object)ATTACHED_DISK);
    private static final Metadata METADATA = Metadata.builder().add("key1", "value1").add("key2", "value2").fingerprint("fingerprint").build();
    private static final ServiceAccount SERVICE_ACCOUNT = ServiceAccount.of((String)"email", (List)ImmutableList.of((Object)"scope1"));
    private static final List<ServiceAccount> SERVICE_ACCOUNTS = ImmutableList.of((Object)SERVICE_ACCOUNT);
    private static final SchedulingOptions SCHEDULING_OPTIONS = SchedulingOptions.preemptible();
    private static final String CPU_PLATFORM = "cpuPlatform";
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Instance instance;
    private Instance expectedInstance;

    private void initializeExpectedInstance(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.expectedInstance = new Instance.Builder(this.serviceMockReturnsOptions, INSTANCE_ID, MACHINE_TYPE, ATTACHED_DISK, NETWORK_INTERFACE).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).statusMessage(STATUS_MESSAGE).tags(TAGS).canIpForward(CAN_IP_FORWARD).metadata(METADATA).serviceAccounts(SERVICE_ACCOUNTS).schedulingOptions(SCHEDULING_OPTIONS).cpuPlatform(CPU_PLATFORM).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeInstance() {
        this.instance = new Instance.Builder(this.compute, INSTANCE_ID, MACHINE_TYPE, ATTACHED_DISK, NETWORK_INTERFACE).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).statusMessage(STATUS_MESSAGE).tags(TAGS).canIpForward(CAN_IP_FORWARD).metadata(METADATA).serviceAccounts(SERVICE_ACCOUNTS).schedulingOptions(SCHEDULING_OPTIONS).cpuPlatform(CPU_PLATFORM).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedInstance(8);
        this.compareInstance(this.expectedInstance, this.expectedInstance.toBuilder().build());
        Instance newInstance = this.expectedInstance.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newInstance.description());
        newInstance = newInstance.toBuilder().description(DESCRIPTION).build();
        this.compareInstance(this.expectedInstance, newInstance);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedInstance(5);
        InstanceInfo instanceInfo = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        Instance instance = new Instance(this.serviceMockReturnsOptions, new InstanceInfo.BuilderImpl(instanceInfo));
        this.compareInstance(instance, instance.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedInstance(2);
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.expectedInstance.generatedId());
        Assert.assertEquals((Object)INSTANCE_ID, (Object)this.expectedInstance.instanceId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.expectedInstance.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.expectedInstance.description());
        Assert.assertEquals((Object)STATUS, (Object)this.expectedInstance.status());
        Assert.assertEquals((Object)STATUS_MESSAGE, (Object)this.expectedInstance.statusMessage());
        Assert.assertEquals((Object)TAGS, (Object)this.expectedInstance.tags());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)this.expectedInstance.machineType());
        Assert.assertEquals((Object)CAN_IP_FORWARD, (Object)this.expectedInstance.canIpForward());
        Assert.assertEquals(NETWORK_INTERFACES, (Object)this.expectedInstance.networkInterfaces());
        Assert.assertEquals(ATTACHED_DISKS, (Object)this.expectedInstance.attachedDisks());
        Assert.assertEquals((Object)METADATA, (Object)this.expectedInstance.metadata());
        Assert.assertEquals(SERVICE_ACCOUNTS, (Object)this.expectedInstance.serviceAccounts());
        Assert.assertEquals((Object)SCHEDULING_OPTIONS, (Object)this.expectedInstance.schedulingOptions());
        Assert.assertEquals((Object)CPU_PLATFORM, (Object)this.expectedInstance.cpuPlatform());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedInstance.compute());
        InstanceInfo instanceInfo = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
        Instance instance = new Instance(this.serviceMockReturnsOptions, new InstanceInfo.BuilderImpl(instanceInfo));
        Assert.assertNull((Object)instance.generatedId());
        Assert.assertEquals((Object)INSTANCE_ID, (Object)instance.instanceId());
        Assert.assertNull((Object)instance.creationTimestamp());
        Assert.assertNull((Object)instance.description());
        Assert.assertNull((Object)instance.status());
        Assert.assertNull((Object)instance.statusMessage());
        Assert.assertNull((Object)instance.tags());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)instance.machineType());
        Assert.assertNull((Object)instance.canIpForward());
        Assert.assertEquals(NETWORK_INTERFACES, (Object)instance.networkInterfaces());
        Assert.assertEquals(ATTACHED_DISKS, (Object)instance.attachedDisks());
        Assert.assertNull((Object)instance.metadata());
        Assert.assertNull((Object)instance.serviceAccounts());
        Assert.assertNull((Object)instance.schedulingOptions());
        Assert.assertNull((Object)instance.cpuPlatform());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)instance.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedInstance(8);
        this.compareInstance(this.expectedInstance, Instance.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Instance)this.expectedInstance.toPb()));
        Instance instance = new Instance.Builder(this.serviceMockReturnsOptions, INSTANCE_ID, MACHINE_TYPE, ATTACHED_DISK, NETWORK_INTERFACE).build();
        this.compareInstance(instance, Instance.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Instance)instance.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteInstance(INSTANCE_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteInstance(INSTANCE_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedInstance(1);
        Compute.InstanceOption[] expectedOptions = new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getInstance(INSTANCE_ID, expectedOptions)).andReturn((Object)this.expectedInstance);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertTrue((boolean)this.instance.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedInstance(1);
        Compute.InstanceOption[] expectedOptions = new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getInstance(INSTANCE_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertFalse((boolean)this.instance.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedInstance(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[0])).andReturn((Object)this.expectedInstance);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Instance updatedInstance = this.instance.reload(new Compute.InstanceOption[0]);
        this.compareInstance(this.expectedInstance, updatedInstance);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.reload(new Compute.InstanceOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedInstance(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[0])})).andReturn((Object)this.expectedInstance);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Instance updateInstance = this.instance.reload(new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[0])});
        this.compareInstance(this.expectedInstance, updateInstance);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testAddAccessConfig() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.addAccessConfig(INSTANCE_ID, "nic0", accessConfig, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.addAccessConfig("nic0", accessConfig, new Compute.OperationOption[0]));
    }

    @Test
    public void testAddAccessConfig_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        EasyMock.expect((Object)this.compute.addAccessConfig(INSTANCE_ID, "nic0", accessConfig, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.addAccessConfig("nic0", accessConfig, new Compute.OperationOption[0]));
    }

    @Test
    public void testAddAccessConfigWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.addAccessConfig(INSTANCE_ID, "nic0", accessConfig, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.addAccessConfig("nic0", accessConfig, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testAttachDisk() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, configuration, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk(configuration, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDisk_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, configuration, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.attachDisk(configuration, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, configuration, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk(configuration, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testAttachDiskName() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk("dev0", configuration, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskName_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.attachDisk("dev0", configuration, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskNameWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk("dev0", configuration, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testAttachDiskNameIndex() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, 1, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk("dev0", configuration, 1, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskNameIndex_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, 1, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.attachDisk("dev0", configuration, 1, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskNameIndexWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        AttachedDisk.PersistentDiskConfiguration configuration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", configuration, 1, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.attachDisk("dev0", configuration, 1, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testDeleteAccessConfig() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteAccessConfig(INSTANCE_ID, "nic0", "NAT", new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.deleteAccessConfig("nic0", "NAT", new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteAccessConfig_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteAccessConfig(INSTANCE_ID, "nic0", "NAT", new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.deleteAccessConfig("nic0", "NAT", new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteAccessConfigWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteAccessConfig(INSTANCE_ID, "nic0", "NAT", new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.deleteAccessConfig("nic0", "NAT", new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testDetachDisk() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.detachDisk(INSTANCE_ID, "dev0", new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.detachDisk("dev0", new Compute.OperationOption[0]));
    }

    @Test
    public void testDetachDisk_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.detachDisk(INSTANCE_ID, "dev0", new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.detachDisk("dev0", new Compute.OperationOption[0]));
    }

    @Test
    public void testDetachDiskWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.detachDisk(INSTANCE_ID, "dev0", new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.detachDisk("dev0", new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testGetSerialPortOutputWithNumber() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSerialPortOutput(INSTANCE_ID, 2)).andReturn((Object)"output");
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)"output", (Object)this.instance.getSerialPortOutput(2));
    }

    @Test
    public void testGetSerialPortOutput() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSerialPortOutput(INSTANCE_ID)).andReturn((Object)"output");
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)"output", (Object)this.instance.getSerialPortOutput());
    }

    @Test
    public void testResetOperation() {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.reset(INSTANCE_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.reset(new Compute.OperationOption[0]));
    }

    @Test
    public void testResetNull() {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.reset(INSTANCE_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.reset(new Compute.OperationOption[0]));
    }

    @Test
    public void testSetDiskAutodelete() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.setDiskAutoDelete(INSTANCE_ID, "dev0", true, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setDiskAutoDelete("dev0", true, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetDiskAutodelete_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.setDiskAutoDelete(INSTANCE_ID, "dev0", false, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setDiskAutoDelete("dev0", false, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetDiskAutodeleteWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.setDiskAutoDelete(INSTANCE_ID, "dev0", true, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setDiskAutoDelete("dev0", true, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetMachineType() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.setMachineType(INSTANCE_ID, MACHINE_TYPE, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMachineType(MACHINE_TYPE, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMachineType_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.setMachineType(INSTANCE_ID, MACHINE_TYPE, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setMachineType(MACHINE_TYPE, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMachineTypeWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.setMachineType(INSTANCE_ID, MACHINE_TYPE, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMachineType(MACHINE_TYPE, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetMetadata() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        Metadata metadata = Metadata.builder().add("k", "v").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMetadata(metadata, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadata_Null() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Metadata metadata = Metadata.builder().add("k", "v").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setMetadata(metadata, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadataWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        Metadata metadata = Metadata.builder().add("k", "v").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMetadata(metadata, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetMetadataFromMap() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        ImmutableMap metadataMap = ImmutableMap.of((Object)"k", (Object)"v");
        Metadata metadata = Metadata.builder().values((Map)metadataMap).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMetadata((Map)metadataMap, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadataFromMap_Null() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        ImmutableMap metadataMap = ImmutableMap.of((Object)"k", (Object)"v");
        Metadata metadata = Metadata.builder().values((Map)metadataMap).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setMetadata((Map)metadataMap, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadataFromMapWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        ImmutableMap metadataMap = ImmutableMap.of((Object)"k", (Object)"v");
        Metadata metadata = Metadata.builder().values((Map)metadataMap).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setMetadata((Map)metadataMap, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetSchedulingOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setSchedulingOptions(schedulingOptions, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetSchedulingOptions_Null() throws Exception {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setSchedulingOptions(schedulingOptions, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetSchedulingOptionsWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setSchedulingOptions(schedulingOptions, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetTags() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        Tags tags = Tags.builder((String[])new String[0]).values(new String[]{"v1", "v2"}).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setTags(tags, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetTags_Null() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Tags tags = Tags.builder((String[])new String[0]).values(new String[]{"v1", "v2"}).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setTags(tags, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetTagsWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        Tags tags = Tags.builder((String[])new String[0]).values(new String[]{"v1", "v2"}).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setTags(tags, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testSetTagsFromList() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        ImmutableList tagList = ImmutableList.of((Object)"v1", (Object)"v2");
        Tags tags = Tags.builder((String[])new String[0]).values((Iterable)tagList).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setTags((Iterable)tagList, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetTagsFromList_Null() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        ImmutableList tagList = ImmutableList.of((Object)"v1", (Object)"v2");
        Tags tags = Tags.builder((String[])new String[0]).values((Iterable)tagList).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.setTags((Iterable)tagList, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetTagsFromListWithOptions() throws Exception {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        ImmutableList tagList = ImmutableList.of((Object)"v1", (Object)"v2");
        Tags tags = Tags.builder((String[])new String[0]).values((Iterable)tagList).fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.setTags((Iterable)tagList, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
    }

    @Test
    public void testStartOperation() {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.start(INSTANCE_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.start(new Compute.OperationOption[0]));
    }

    @Test
    public void testStartNull() {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.start(INSTANCE_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.start(new Compute.OperationOption[0]));
    }

    @Test
    public void testStopOperation() {
        this.initializeExpectedInstance(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZoneOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.stop(INSTANCE_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertSame((Object)operation, (Object)this.instance.stop(new Compute.OperationOption[0]));
    }

    @Test
    public void testStopNull() {
        this.initializeExpectedInstance(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.stop(INSTANCE_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeInstance();
        Assert.assertNull((Object)this.instance.stop(new Compute.OperationOption[0]));
    }

    public void compareInstance(Instance expected, Instance value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.instanceId(), (Object)value.instanceId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.statusMessage(), (Object)value.statusMessage());
        Assert.assertEquals((Object)expected.tags(), (Object)value.tags());
        Assert.assertEquals((Object)expected.machineType(), (Object)value.machineType());
        Assert.assertEquals((Object)expected.canIpForward(), (Object)value.canIpForward());
        Assert.assertEquals((Object)expected.networkInterfaces(), (Object)value.networkInterfaces());
        Assert.assertEquals((Object)expected.attachedDisks(), (Object)value.attachedDisks());
        Assert.assertEquals((Object)expected.metadata(), (Object)value.metadata());
        Assert.assertEquals((Object)expected.serviceAccounts(), (Object)value.serviceAccounts());
        Assert.assertEquals((Object)expected.schedulingOptions(), (Object)value.schedulingOptions());
        Assert.assertEquals((Object)expected.cpuPlatform(), (Object)value.cpuPlatform());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

