/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.LicenseId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LicenseIdTest {
    private static final String PROJECT = "project";
    private static final String LICENSE = "license";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/global/licenses/license";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        LicenseId licenseId = LicenseId.of((String)PROJECT, (String)LICENSE);
        Assert.assertEquals((Object)PROJECT, (Object)licenseId.project());
        Assert.assertEquals((Object)LICENSE, (Object)licenseId.license());
        Assert.assertEquals((Object)URL, (Object)licenseId.selfLink());
        licenseId = LicenseId.of((String)LICENSE);
        Assert.assertNull((Object)licenseId.project());
        Assert.assertEquals((Object)LICENSE, (Object)licenseId.license());
    }

    @Test
    public void testToAndFromUrl() {
        LicenseId licenseId = LicenseId.of((String)PROJECT, (String)LICENSE);
        this.compareLicenseId(licenseId, LicenseId.fromUrl((String)licenseId.selfLink()));
    }

    @Test
    public void testSetProjectId() {
        LicenseId licenseId = LicenseId.of((String)PROJECT, (String)LICENSE);
        Assert.assertSame((Object)licenseId, (Object)licenseId.setProjectId(PROJECT));
        this.compareLicenseId(licenseId, LicenseId.of((String)LICENSE).setProjectId(PROJECT));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid license URL");
        LicenseId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)LicenseId.matchesUrl((String)LicenseId.of((String)PROJECT, (String)LICENSE).selfLink()));
        Assert.assertFalse((boolean)LicenseId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareLicenseId(LicenseId expected, LicenseId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.license(), (Object)expected.license());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

