/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import org.junit.Assert;
import org.junit.Test;

public class LicenseTest {
    private static final LicenseId LICENSE_ID = LicenseId.of((String)"project", (String)"license");
    private static final Boolean CHARGES_USE_FEE = true;
    private static final License LICENSE = new License(LICENSE_ID, CHARGES_USE_FEE);

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)LICENSE_ID, (Object)LICENSE.licenseId());
        Assert.assertEquals((Object)CHARGES_USE_FEE, (Object)LICENSE.chargesUseFee());
    }

    @Test
    public void testToAndFromPb() {
        License license = License.fromPb((com.google.api.services.compute.model.License)LICENSE.toPb());
        this.compareLicenses(LICENSE, license);
        Assert.assertEquals((Object)LICENSE_ID.project(), (Object)license.licenseId().project());
        Assert.assertEquals((Object)LICENSE_ID.license(), (Object)license.licenseId().license());
    }

    private void compareLicenses(License expected, License value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.licenseId(), (Object)value.licenseId());
        Assert.assertEquals((Object)expected.chargesUseFee(), (Object)value.chargesUseFee());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

