/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.MachineTypeId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MachineTypeIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String TYPE = "type";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone/machineTypes/type";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        MachineTypeId machineTypeId = MachineTypeId.of((String)PROJECT, (String)ZONE, (String)TYPE);
        Assert.assertEquals((Object)PROJECT, (Object)machineTypeId.project());
        Assert.assertEquals((Object)ZONE, (Object)machineTypeId.zone());
        Assert.assertEquals((Object)TYPE, (Object)machineTypeId.type());
        Assert.assertEquals((Object)URL, (Object)machineTypeId.selfLink());
        machineTypeId = MachineTypeId.of((String)ZONE, (String)TYPE);
        Assert.assertNull((Object)machineTypeId.project());
        Assert.assertEquals((Object)ZONE, (Object)machineTypeId.zone());
        Assert.assertEquals((Object)TYPE, (Object)machineTypeId.type());
    }

    @Test
    public void testToAndFromUrl() {
        MachineTypeId machineTypeId = MachineTypeId.of((String)PROJECT, (String)ZONE, (String)TYPE);
        this.compareMachineTypeId(machineTypeId, MachineTypeId.fromUrl((String)machineTypeId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid machine type URL");
        MachineTypeId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        MachineTypeId machineTypeId = MachineTypeId.of((String)PROJECT, (String)ZONE, (String)TYPE);
        Assert.assertSame((Object)machineTypeId, (Object)machineTypeId.setProjectId(PROJECT));
        this.compareMachineTypeId(machineTypeId, MachineTypeId.of((String)ZONE, (String)TYPE).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)MachineTypeId.matchesUrl((String)MachineTypeId.of((String)PROJECT, (String)ZONE, (String)TYPE).selfLink()));
        Assert.assertFalse((boolean)MachineTypeId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareMachineTypeId(MachineTypeId expected, MachineTypeId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.type(), (Object)expected.type());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

