/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.ResourceId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MachineTypeTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final MachineTypeId MACHINE_TYPE_ID = MachineTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final Integer CPUS = 1;
    private static final Integer MEMORY_MB = 2;
    private static final List<Integer> SCRATCH_DISKS = ImmutableList.of((Object)3);
    private static final Integer MAXIMUM_PERSISTENT_DISKS = 4;
    private static final Long MAXIMUM_PERSISTENT_DISKS_SIZE_GB = 5L;
    private static final DeprecationStatus<MachineTypeId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)MACHINE_TYPE_ID);
    private static final MachineType MACHINE_TYPE = MachineType.builder().generatedId("42").machineTypeId(MACHINE_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").cpus(CPUS).memoryMb(MEMORY_MB).scratchDisksSizeGb(SCRATCH_DISKS).maximumPersistentDisks(MAXIMUM_PERSISTENT_DISKS).maximumPersistentDisksSizeGb(MAXIMUM_PERSISTENT_DISKS_SIZE_GB).deprecationStatus(DEPRECATION_STATUS).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)MACHINE_TYPE.generatedId());
        Assert.assertEquals((Object)MACHINE_TYPE_ID, (Object)MACHINE_TYPE.machineTypeId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)MACHINE_TYPE.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)MACHINE_TYPE.description());
        Assert.assertEquals((Object)CPUS, (Object)MACHINE_TYPE.cpus());
        Assert.assertEquals((Object)MEMORY_MB, (Object)MACHINE_TYPE.memoryMb());
        Assert.assertEquals(SCRATCH_DISKS, (Object)MACHINE_TYPE.scratchDisksSizeGb());
        Assert.assertEquals((Object)MAXIMUM_PERSISTENT_DISKS, (Object)MACHINE_TYPE.maximumPersistentDisks());
        Assert.assertEquals((Object)MAXIMUM_PERSISTENT_DISKS_SIZE_GB, (Object)MACHINE_TYPE.maximumPersistentDisksSizeGb());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)MACHINE_TYPE.deprecationStatus());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareMachineTypes(MACHINE_TYPE, MachineType.fromPb((com.google.api.services.compute.model.MachineType)MACHINE_TYPE.toPb()));
        MachineType machineType = MachineType.builder().machineTypeId(MACHINE_TYPE_ID).build();
        this.compareMachineTypes(machineType, MachineType.fromPb((com.google.api.services.compute.model.MachineType)machineType.toPb()));
    }

    private void compareMachineTypes(MachineType expected, MachineType value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.machineTypeId(), (Object)value.machineTypeId());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.cpus(), (Object)value.cpus());
        Assert.assertEquals((Object)expected.memoryMb(), (Object)value.memoryMb());
        Assert.assertEquals((Object)expected.scratchDisksSizeGb(), (Object)value.scratchDisksSizeGb());
        Assert.assertEquals((Object)expected.maximumPersistentDisks(), (Object)value.maximumPersistentDisks());
        Assert.assertEquals((Object)expected.maximumPersistentDisksSizeGb(), (Object)value.maximumPersistentDisksSizeGb());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

