/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Metadata;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    private static final Metadata METADATA = Metadata.builder().add("key1", "value1").add("key2", "value2").build();

    @Test
    public void testToBuilder() {
        Metadata metadata = METADATA.toBuilder().fingerprint("newFingerprint").build();
        Assert.assertEquals((Object)"newFingerprint", (Object)metadata.fingerprint());
        this.compareMetadata(METADATA, metadata.toBuilder().fingerprint(null).build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"), (Object)METADATA.values());
        Assert.assertNull((Object)METADATA.fingerprint());
        Metadata metadata = Metadata.builder().values((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"), (Object)metadata.values());
        Assert.assertNull((Object)metadata.fingerprint());
        metadata = Metadata.builder().values((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).fingerprint("fingerprint").build();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"), (Object)metadata.values());
        Assert.assertEquals((Object)"fingerprint", (Object)metadata.fingerprint());
    }

    @Test
    public void testOf() {
        ImmutableMap map = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        this.compareMetadata(METADATA, Metadata.of((Map)map));
    }

    @Test
    public void testToAndFromPb() {
        this.compareMetadata(METADATA, Metadata.fromPb((com.google.api.services.compute.model.Metadata)METADATA.toPb()));
        Metadata metadata = Metadata.builder().values((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).fingerprint("fingerprint").build();
        this.compareMetadata(metadata, Metadata.fromPb((com.google.api.services.compute.model.Metadata)metadata.toPb()));
    }

    public void compareMetadata(Metadata expected, Metadata value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.fingerprint(), (Object)value.fingerprint());
        Assert.assertEquals((Object)expected.values(), (Object)value.values());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

