/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.NetworkId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NetworkIdTest {
    private static final String PROJECT = "project";
    private static final String NETWORK = "network";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/global/networks/network";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        NetworkId networkId = NetworkId.of((String)PROJECT, (String)NETWORK);
        Assert.assertEquals((Object)PROJECT, (Object)networkId.project());
        Assert.assertEquals((Object)NETWORK, (Object)networkId.network());
        Assert.assertEquals((Object)URL, (Object)networkId.selfLink());
        networkId = NetworkId.of((String)NETWORK);
        Assert.assertNull((Object)networkId.project());
        Assert.assertEquals((Object)NETWORK, (Object)networkId.network());
    }

    @Test
    public void testToAndFromUrl() {
        NetworkId networkId = NetworkId.of((String)PROJECT, (String)NETWORK);
        this.compareNetworkId(networkId, NetworkId.fromUrl((String)networkId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid network URL");
        NetworkId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        NetworkId networkId = NetworkId.of((String)PROJECT, (String)NETWORK);
        Assert.assertSame((Object)networkId, (Object)networkId.setProjectId(PROJECT));
        this.compareNetworkId(networkId, NetworkId.of((String)NETWORK).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)NetworkId.matchesUrl((String)NetworkId.of((String)PROJECT, (String)NETWORK).selfLink()));
        Assert.assertFalse((boolean)NetworkId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareNetworkId(NetworkId expected, NetworkId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.network(), (Object)expected.network());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

