/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class NetworkInfoTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final SubnetworkId SUBNETWORK1 = SubnetworkId.of((String)"project", (String)"region1", (String)"network1");
    private static final SubnetworkId SUBNETWORK2 = SubnetworkId.of((String)"project", (String)"region2", (String)"network2");
    private static final List<SubnetworkId> SUBNETWORKS = ImmutableList.of((Object)SUBNETWORK1, (Object)SUBNETWORK2);
    private static final String GATEWAY_ADDRESS = "192.168.1.1";
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final String IP_RANGE = "192.168.0.0/16";
    private static final Boolean AUTO_CREATE_SUBNETWORKS = true;
    private static final StandardNetworkConfiguration NETWORK_CONFIGURATION = new StandardNetworkConfiguration("192.168.0.0/16", "192.168.1.1");
    private static final SubnetNetworkConfiguration SUBNET_NETWORK_CONFIGURATION = new SubnetNetworkConfiguration(AUTO_CREATE_SUBNETWORKS.booleanValue(), SUBNETWORKS);
    private static final NetworkInfo NETWORK_INFO = NetworkInfo.builder((NetworkId)NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").build();
    private static final NetworkInfo SUBNET_NETWORK_INFO = NetworkInfo.builder((NetworkId)NETWORK_ID, (NetworkConfiguration)SUBNET_NETWORK_CONFIGURATION).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").build();

    @Test
    public void testToBuilder() {
        this.compareNetworkInfo(NETWORK_INFO, NETWORK_INFO.toBuilder().build());
        NetworkInfo networkInfo = NETWORK_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)networkInfo.description());
        networkInfo = networkInfo.toBuilder().description(DESCRIPTION).build();
        this.compareNetworkInfo(NETWORK_INFO, networkInfo);
        this.compareNetworkInfo(SUBNET_NETWORK_INFO, SUBNET_NETWORK_INFO.toBuilder().build());
        networkInfo = SUBNET_NETWORK_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)networkInfo.description());
        networkInfo = networkInfo.toBuilder().description(DESCRIPTION).build();
        this.compareNetworkInfo(SUBNET_NETWORK_INFO, networkInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION);
        Assert.assertEquals((Object)networkInfo, (Object)networkInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)NETWORK_INFO.generatedId());
        Assert.assertEquals((Object)NETWORK_ID, (Object)NETWORK_INFO.networkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)NETWORK_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)NETWORK_INFO.description());
        Assert.assertEquals((Object)NETWORK_CONFIGURATION, (Object)NETWORK_INFO.configuration());
        Assert.assertEquals((Object)GENERATED_ID, (Object)SUBNET_NETWORK_INFO.generatedId());
        Assert.assertEquals((Object)NETWORK_ID, (Object)SUBNET_NETWORK_INFO.networkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)SUBNET_NETWORK_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)SUBNET_NETWORK_INFO.description());
        Assert.assertEquals((Object)SUBNET_NETWORK_CONFIGURATION, (Object)SUBNET_NETWORK_INFO.configuration());
    }

    @Test
    public void testOf() {
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION);
        Assert.assertNull((Object)networkInfo.generatedId());
        Assert.assertEquals((Object)NETWORK_ID, (Object)NETWORK_INFO.networkId());
        Assert.assertEquals((Object)NETWORK_CONFIGURATION, (Object)NETWORK_INFO.configuration());
        Assert.assertNull((Object)networkInfo.creationTimestamp());
        Assert.assertNull((Object)networkInfo.description());
    }

    @Test
    public void testToAndFromPb() {
        this.compareNetworkInfo(NETWORK_INFO, NetworkInfo.fromPb((Network)NETWORK_INFO.toPb()));
        this.compareNetworkInfo(SUBNET_NETWORK_INFO, NetworkInfo.fromPb((Network)SUBNET_NETWORK_INFO.toPb()));
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION);
        this.compareNetworkInfo(networkInfo, NetworkInfo.fromPb((Network)networkInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        NetworkInfo networkInfo = NETWORK_INFO.toBuilder().networkId(NetworkId.of((String)"network")).build();
        this.compareNetworkInfo(NETWORK_INFO, networkInfo.setProjectId("project"));
    }

    public void compareNetworkInfo(NetworkInfo expected, NetworkInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.networkId(), (Object)value.networkId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

