/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.AccessConfig;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class NetworkInterfaceTest {
    private static final String NAME = "networkInterface";
    private static final NetworkId NETWORK = NetworkId.of((String)"project", (String)"network");
    private static final String NETWORK_IP = "192.168.1.1";
    private static final SubnetworkId SUBNETWORK = SubnetworkId.of((String)"project", (String)"region", (String)"subnetwork");
    private static final NetworkInterface.AccessConfig ACCESS_CONFIG = NetworkInterface.AccessConfig.builder().name("accessConfig").natIp("192.168.1.1").type(NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT).build();
    private static final List<NetworkInterface.AccessConfig> ACCESS_CONFIGURATIONS = ImmutableList.of((Object)ACCESS_CONFIG);
    private static final NetworkInterface NETWORK_INTERFACE = NetworkInterface.builder((NetworkId)NETWORK).name("networkInterface").networkIp("192.168.1.1").subnetwork(SUBNETWORK).accessConfigurations(ACCESS_CONFIGURATIONS).build();

    @Test
    public void testAccessConfigToBuilder() {
        NetworkInterface.AccessConfig accessConfig = ACCESS_CONFIG.toBuilder().name("newName").build();
        Assert.assertEquals((Object)"newName", (Object)accessConfig.name());
        this.compareAccessConfig(ACCESS_CONFIG, accessConfig.toBuilder().name("accessConfig").build());
    }

    @Test
    public void testAccessConfigToBuilderIncomplete() {
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of();
        this.compareAccessConfig(accessConfig, accessConfig.toBuilder().build());
    }

    @Test
    public void testToBuilder() {
        this.compareNetworkInterface(NETWORK_INTERFACE, NETWORK_INTERFACE.toBuilder().build());
        NetworkInterface networkInterface = NETWORK_INTERFACE.toBuilder().name("newInterface").build();
        Assert.assertEquals((Object)"newInterface", (Object)networkInterface.name());
        networkInterface = networkInterface.toBuilder().name(NAME).build();
        this.compareNetworkInterface(NETWORK_INTERFACE, networkInterface);
    }

    @Test
    public void testToBuilderIncomplete() {
        NetworkInterface networkInterface = NetworkInterface.of((NetworkId)NETWORK);
        Assert.assertEquals((Object)networkInterface, (Object)networkInterface.toBuilder().build());
        networkInterface = NetworkInterface.of((String)NETWORK.network());
        Assert.assertEquals((Object)networkInterface, (Object)networkInterface.toBuilder().build());
    }

    @Test
    public void testAccessConfigBuilder() {
        Assert.assertEquals((Object)"accessConfig", (Object)ACCESS_CONFIG.name());
        Assert.assertEquals((Object)NETWORK_IP, (Object)ACCESS_CONFIG.natIp());
        Assert.assertEquals((Object)NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT, (Object)ACCESS_CONFIG.type());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)NAME, (Object)NETWORK_INTERFACE.name());
        Assert.assertEquals((Object)NETWORK, (Object)NETWORK_INTERFACE.network());
        Assert.assertEquals((Object)NETWORK_IP, (Object)NETWORK_INTERFACE.networkIp());
        Assert.assertEquals((Object)SUBNETWORK, (Object)NETWORK_INTERFACE.subnetwork());
        Assert.assertEquals(ACCESS_CONFIGURATIONS, (Object)NETWORK_INTERFACE.accessConfigurations());
        NetworkInterface networkInterface = NetworkInterface.builder((String)"network").name(NAME).networkIp(NETWORK_IP).subnetwork(SUBNETWORK).accessConfigurations(new NetworkInterface.AccessConfig[]{ACCESS_CONFIG}).build();
        Assert.assertEquals((Object)NAME, (Object)networkInterface.name());
        Assert.assertEquals((Object)NetworkId.of((String)"network"), (Object)networkInterface.network());
        Assert.assertEquals((Object)NETWORK_IP, (Object)networkInterface.networkIp());
        Assert.assertEquals((Object)SUBNETWORK, (Object)networkInterface.subnetwork());
        Assert.assertEquals(ACCESS_CONFIGURATIONS, (Object)networkInterface.accessConfigurations());
    }

    @Test
    public void testAccessConfigOf() {
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)NETWORK_IP);
        Assert.assertNull((Object)accessConfig.name());
        Assert.assertEquals((Object)NETWORK_IP, (Object)accessConfig.natIp());
        Assert.assertNull((Object)accessConfig.type());
        accessConfig = NetworkInterface.AccessConfig.of();
        Assert.assertNull((Object)accessConfig.name());
        Assert.assertNull((Object)accessConfig.natIp());
        Assert.assertNull((Object)accessConfig.type());
    }

    @Test
    public void testOf() {
        NetworkInterface networkInterface = NetworkInterface.of((NetworkId)NETWORK);
        Assert.assertNull((Object)networkInterface.name());
        Assert.assertEquals((Object)NETWORK, (Object)networkInterface.network());
        Assert.assertNull((Object)networkInterface.networkIp());
        Assert.assertNull((Object)networkInterface.subnetwork());
        networkInterface = NetworkInterface.of((String)NETWORK.network());
        Assert.assertNull((Object)networkInterface.name());
        Assert.assertNull((Object)networkInterface.network().project());
        Assert.assertEquals((Object)NETWORK.network(), (Object)networkInterface.network().network());
        Assert.assertNull((Object)networkInterface.networkIp());
        Assert.assertNull((Object)networkInterface.subnetwork());
    }

    @Test
    public void testAccessConfigToAndFromPb() {
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.fromPb((AccessConfig)ACCESS_CONFIG.toPb());
        this.compareAccessConfig(ACCESS_CONFIG, accessConfig);
        accessConfig = NetworkInterface.AccessConfig.of();
        this.compareAccessConfig(accessConfig, NetworkInterface.AccessConfig.fromPb((AccessConfig)accessConfig.toPb()));
    }

    @Test
    public void testToAndFromPb() {
        NetworkInterface networkInterface = NetworkInterface.fromPb((com.google.api.services.compute.model.NetworkInterface)NETWORK_INTERFACE.toPb());
        this.compareNetworkInterface(NETWORK_INTERFACE, networkInterface);
        networkInterface = NetworkInterface.of((NetworkId)NETWORK);
        this.compareNetworkInterface(networkInterface, NetworkInterface.fromPb((com.google.api.services.compute.model.NetworkInterface)networkInterface.toPb()));
    }

    @Test
    public void testSetProjectId() {
        NetworkInterface networkInterface = NetworkInterface.of((NetworkId)NETWORK);
        this.compareNetworkInterface(networkInterface, NetworkInterface.of((NetworkId)NetworkId.of((String)"network")).setProjectId("project"));
        networkInterface = NETWORK_INTERFACE.toBuilder().network(NetworkId.of((String)"network")).subnetwork(SubnetworkId.of((String)"region", (String)"subnetwork")).build();
        this.compareNetworkInterface(NETWORK_INTERFACE, networkInterface.setProjectId("project"));
    }

    public void compareAccessConfig(NetworkInterface.AccessConfig expected, NetworkInterface.AccessConfig value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.natIp(), (Object)value.natIp());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }

    public void compareNetworkInterface(NetworkInterface expected, NetworkInterface value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.name(), (Object)value.name());
        Assert.assertEquals((Object)expected.network(), (Object)value.network());
        Assert.assertEquals((Object)expected.networkIp(), (Object)value.networkIp());
        Assert.assertEquals((Object)expected.subnetwork(), (Object)value.subnetwork());
        Assert.assertEquals((Object)expected.accessConfigurations(), (Object)value.accessConfigurations());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

