/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class NetworkTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final SubnetworkId SUBNETWORK1 = SubnetworkId.of((String)"project", (String)"region1", (String)"network1");
    private static final SubnetworkId SUBNETWORK2 = SubnetworkId.of((String)"project", (String)"region2", (String)"network2");
    private static final List<SubnetworkId> SUBNETWORKS = ImmutableList.of((Object)SUBNETWORK1, (Object)SUBNETWORK2);
    private static final String GATEWAY_ADDRESS = "192.168.1.1";
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final String IP_RANGE = "192.168.0.0/16";
    private static final Boolean AUTO_CREATE_SUBNETWORKS = true;
    private static final StandardNetworkConfiguration NETWORK_CONFIGURATION = new StandardNetworkConfiguration("192.168.0.0/16", "192.168.1.1");
    private static final SubnetNetworkConfiguration SUBNET_NETWORK_CONFIGURATION = new SubnetNetworkConfiguration(AUTO_CREATE_SUBNETWORKS.booleanValue(), SUBNETWORKS);
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Network network;
    private Network standardNetwork;
    private Network subnetNetwork;

    private void initializeExpectedNetwork(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.standardNetwork = new Network.Builder(this.serviceMockReturnsOptions, NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).build();
        this.subnetNetwork = new Network.Builder(this.serviceMockReturnsOptions, NETWORK_ID, (NetworkConfiguration)SUBNET_NETWORK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeNetwork() {
        this.network = new Network.Builder(this.compute, NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedNetwork(9);
        this.compareNetwork(this.standardNetwork, this.standardNetwork.toBuilder().build());
        Network newNetwork = this.standardNetwork.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newNetwork.description());
        newNetwork = newNetwork.toBuilder().description(DESCRIPTION).build();
        this.compareNetwork(this.standardNetwork, newNetwork);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedNetwork(6);
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION);
        Network network = new Network(this.serviceMockReturnsOptions, new NetworkInfo.BuilderImpl(networkInfo));
        this.compareNetwork(network, network.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedNetwork(2);
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.standardNetwork.generatedId());
        Assert.assertEquals((Object)NETWORK_ID, (Object)this.standardNetwork.networkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.standardNetwork.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.standardNetwork.description());
        Assert.assertEquals((Object)NETWORK_CONFIGURATION, (Object)this.standardNetwork.configuration());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.standardNetwork.compute());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.subnetNetwork.generatedId());
        Assert.assertEquals((Object)NETWORK_ID, (Object)this.subnetNetwork.networkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.subnetNetwork.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.subnetNetwork.description());
        Assert.assertEquals((Object)SUBNET_NETWORK_CONFIGURATION, (Object)this.subnetNetwork.configuration());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.subnetNetwork.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedNetwork(12);
        this.compareNetwork(this.standardNetwork, Network.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Network)this.standardNetwork.toPb()));
        this.compareNetwork(this.subnetNetwork, Network.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Network)this.subnetNetwork.toPb()));
        Network network = new Network.Builder(this.serviceMockReturnsOptions, NETWORK_ID, (NetworkConfiguration)NETWORK_CONFIGURATION).build();
        this.compareNetwork(network, Network.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Network)network.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedNetwork(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteNetwork(NETWORK_ID.network(), new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertSame((Object)operation, (Object)this.network.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedNetwork(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteNetwork(NETWORK_ID.network(), new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertNull((Object)this.network.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedNetwork(2);
        Compute.NetworkOption[] expectedOptions = new Compute.NetworkOption[]{Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getNetwork(NETWORK_ID.network(), expectedOptions)).andReturn((Object)this.standardNetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertTrue((boolean)this.network.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedNetwork(2);
        Compute.NetworkOption[] expectedOptions = new Compute.NetworkOption[]{Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getNetwork(NETWORK_ID.network(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertFalse((boolean)this.network.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedNetwork(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[0])).andReturn((Object)this.standardNetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Network updatedNetwork = this.network.reload(new Compute.NetworkOption[0]);
        this.compareNetwork(this.standardNetwork, updatedNetwork);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedNetwork(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertNull((Object)this.network.reload(new Compute.NetworkOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedNetwork(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[]{Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[0])})).andReturn((Object)this.standardNetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Network updatedNetwork = this.network.reload(new Compute.NetworkOption[]{Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[0])});
        this.compareNetwork(this.standardNetwork, updatedNetwork);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testCreateSubnetwork() throws Exception {
        this.initializeExpectedNetwork(3);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)RegionOperationId.of((RegionId)SUBNETWORK1.regionId(), (String)"op")).build();
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.create(SubnetworkInfo.of((SubnetworkId)SUBNETWORK1, (NetworkId)NETWORK_ID, (String)IP_RANGE), new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertSame((Object)operation, (Object)this.network.createSubnetwork(SUBNETWORK1, IP_RANGE, new Compute.OperationOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testCreateSubnetworkWithOptions() throws Exception {
        this.initializeExpectedNetwork(3);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)RegionOperationId.of((RegionId)SUBNETWORK1.regionId(), (String)"op")).build();
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.create(SubnetworkInfo.of((SubnetworkId)SUBNETWORK1, (NetworkId)NETWORK_ID, (String)IP_RANGE), new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeNetwork();
        Assert.assertSame((Object)operation, (Object)this.network.createSubnetwork(SUBNETWORK1, IP_RANGE, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])}));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    public void compareNetwork(Network expected, Network value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.networkId(), (Object)value.networkId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

