/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ZoneId;
import com.google.cloud.compute.ZoneOperationId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OperationIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String REGION = "region";
    private static final String NAME = "op";
    private static final String GLOBAL_URL = "https://www.googleapis.com/compute/v1/projects/project/global/operations/op";
    private static final String ZONE_URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone/operations/op";
    private static final String REGION_URL = "https://www.googleapis.com/compute/v1/projects/project/regions/region/operations/op";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        GlobalOperationId operationId = GlobalOperationId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.GLOBAL, (Object)operationId.type());
        Assert.assertEquals((Object)PROJECT, (Object)operationId.project());
        Assert.assertEquals((Object)NAME, (Object)operationId.operation());
        Assert.assertEquals((Object)GLOBAL_URL, (Object)operationId.selfLink());
        operationId = GlobalOperationId.of((String)NAME);
        Assert.assertEquals((Object)OperationId.Type.GLOBAL, (Object)operationId.type());
        Assert.assertNull((Object)operationId.project());
        Assert.assertEquals((Object)NAME, (Object)operationId.operation());
        ZoneOperationId zoneOperationId = ZoneOperationId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.ZONE, (Object)zoneOperationId.type());
        Assert.assertEquals((Object)PROJECT, (Object)zoneOperationId.project());
        Assert.assertEquals((Object)ZONE, (Object)zoneOperationId.zone());
        Assert.assertEquals((Object)NAME, (Object)zoneOperationId.operation());
        Assert.assertEquals((Object)ZONE_URL, (Object)zoneOperationId.selfLink());
        zoneOperationId = ZoneOperationId.of((String)ZONE, (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.ZONE, (Object)zoneOperationId.type());
        Assert.assertNull((Object)zoneOperationId.project());
        Assert.assertEquals((Object)ZONE, (Object)zoneOperationId.zone());
        Assert.assertEquals((Object)NAME, (Object)zoneOperationId.operation());
        zoneOperationId = ZoneOperationId.of((ZoneId)ZoneId.of((String)PROJECT, (String)ZONE), (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.ZONE, (Object)zoneOperationId.type());
        Assert.assertEquals((Object)PROJECT, (Object)zoneOperationId.project());
        Assert.assertEquals((Object)ZONE, (Object)zoneOperationId.zone());
        Assert.assertEquals((Object)NAME, (Object)zoneOperationId.operation());
        RegionOperationId regionOperationId = RegionOperationId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.REGION, (Object)regionOperationId.type());
        Assert.assertEquals((Object)PROJECT, (Object)regionOperationId.project());
        Assert.assertEquals((Object)REGION, (Object)regionOperationId.region());
        Assert.assertEquals((Object)NAME, (Object)regionOperationId.operation());
        Assert.assertEquals((Object)REGION_URL, (Object)regionOperationId.selfLink());
        regionOperationId = RegionOperationId.of((String)REGION, (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.REGION, (Object)regionOperationId.type());
        Assert.assertNull((Object)regionOperationId.project());
        Assert.assertEquals((Object)REGION, (Object)regionOperationId.region());
        Assert.assertEquals((Object)NAME, (Object)regionOperationId.operation());
        regionOperationId = RegionOperationId.of((RegionId)RegionId.of((String)PROJECT, (String)REGION), (String)NAME);
        Assert.assertEquals((Object)OperationId.Type.REGION, (Object)regionOperationId.type());
        Assert.assertEquals((Object)PROJECT, (Object)regionOperationId.project());
        Assert.assertEquals((Object)REGION, (Object)regionOperationId.region());
        Assert.assertEquals((Object)NAME, (Object)regionOperationId.operation());
    }

    @Test
    public void testToAndFromUrlGlobal() {
        GlobalOperationId operationId = GlobalOperationId.of((String)PROJECT, (String)NAME);
        this.compareOperationId(operationId, GlobalOperationId.fromUrl((String)operationId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid global operation URL");
        GlobalOperationId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testToAndFromUrlRegion() {
        RegionOperationId regionOperationId = RegionOperationId.of((String)PROJECT, (String)REGION, (String)NAME);
        this.compareRegionOperationId(regionOperationId, RegionOperationId.fromUrl((String)regionOperationId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid region operation URL");
        RegionOperationId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testToAndFromUrlZone() {
        ZoneOperationId zoneOperationId = ZoneOperationId.of((String)PROJECT, (String)ZONE, (String)NAME);
        this.compareZoneOperationId(zoneOperationId, ZoneOperationId.fromUrl((String)zoneOperationId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid zone operation URL");
        ZoneOperationId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        GlobalOperationId operationId = GlobalOperationId.of((String)PROJECT, (String)NAME);
        Assert.assertSame((Object)operationId, (Object)operationId.setProjectId(PROJECT));
        this.compareOperationId(operationId, GlobalOperationId.of((String)NAME).setProjectId(PROJECT));
        ZoneOperationId zoneOperationId = ZoneOperationId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertSame((Object)zoneOperationId, (Object)zoneOperationId.setProjectId(PROJECT));
        this.compareZoneOperationId(zoneOperationId, ZoneOperationId.of((String)ZONE, (String)NAME).setProjectId(PROJECT));
        RegionOperationId regionOperationId = RegionOperationId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertSame((Object)regionOperationId, (Object)regionOperationId.setProjectId(PROJECT));
        this.compareRegionOperationId(regionOperationId, RegionOperationId.of((String)REGION, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)GlobalOperationId.matchesUrl((String)GlobalOperationId.of((String)PROJECT, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)GlobalOperationId.matchesUrl((String)"notMatchingUrl"));
        Assert.assertTrue((boolean)RegionOperationId.matchesUrl((String)RegionOperationId.of((String)PROJECT, (String)REGION, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)RegionOperationId.matchesUrl((String)"notMatchingUrl"));
        Assert.assertTrue((boolean)ZoneOperationId.matchesUrl((String)ZoneOperationId.of((String)PROJECT, (String)REGION, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)ZoneOperationId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareOperationId(GlobalOperationId expected, GlobalOperationId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.operation(), (Object)expected.operation());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }

    private void compareZoneOperationId(ZoneOperationId expected, ZoneOperationId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.operation(), (Object)expected.operation());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }

    private void compareRegionOperationId(RegionOperationId expected, RegionOperationId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.region(), (Object)expected.region());
        Assert.assertEquals((Object)expected.operation(), (Object)expected.operation());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

