/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.Clock;
import com.google.cloud.WaitForOption;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OperationTest {
    private static final Operation.OperationError OPERATION_ERROR1 = new Operation.OperationError("code1", "location1", "message1");
    private static final Operation.OperationError OPERATION_ERROR2 = new Operation.OperationError("code2", "location2", "message2");
    private static final Operation.OperationWarning OPERATION_WARNING1 = new Operation.OperationWarning("code1", "message1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1"));
    private static final Operation.OperationWarning OPERATION_WARNING2 = new Operation.OperationWarning("code2", "location2", (Map)ImmutableMap.of((Object)"k2", (Object)"v2"));
    private static final String GENERATED_ID = "1";
    private static final String CLIENT_OPERATION_ID = "clientOperationId";
    private static final String OPERATION_TYPE = "delete";
    private static final String TARGET_LINK = "targetLink";
    private static final String TARGET_ID = "42";
    private static final Operation.Status STATUS = Operation.Status.DONE;
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String USER = "user";
    private static final Integer PROGRESS = 100;
    private static final Long INSERT_TIME = 1453293540000L;
    private static final Long START_TIME = 1453293420000L;
    private static final Long END_TIME = 1453293480000L;
    private static final List<Operation.OperationError> ERRORS = ImmutableList.of((Object)OPERATION_ERROR1, (Object)OPERATION_ERROR2);
    private static final List<Operation.OperationWarning> WARNINGS = ImmutableList.of((Object)OPERATION_WARNING1, (Object)OPERATION_WARNING2);
    private static final Integer HTTP_ERROR_STATUS_CODE = 404;
    private static final String HTTP_ERROR_MESSAGE = "NOT FOUND";
    private static final String DESCRIPTION = "description";
    private static final GlobalOperationId GLOBAL_OPERATION_ID = GlobalOperationId.of((String)"project", (String)"op");
    private static final ZoneOperationId ZONE_OPERATION_ID = ZoneOperationId.of((String)"project", (String)"zone", (String)"op");
    private static final RegionOperationId REGION_OPERATION_ID = RegionOperationId.of((String)"project", (String)"region", (String)"op");
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Operation globalOperation;
    private Operation regionOperation;
    private Operation zoneOperation;
    private Operation operation;

    private void initializeExpectedOperation(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.globalOperation = new Operation.Builder(this.serviceMockReturnsOptions).generatedId(GENERATED_ID).operationId((OperationId)GLOBAL_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId(TARGET_ID).status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
        this.zoneOperation = new Operation.Builder(this.serviceMockReturnsOptions).generatedId(GENERATED_ID).operationId((OperationId)ZONE_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId(TARGET_ID).status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
        this.regionOperation = new Operation.Builder(this.serviceMockReturnsOptions).generatedId(GENERATED_ID).operationId((OperationId)REGION_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId(TARGET_ID).status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeOperation() {
        this.operation = new Operation.Builder(this.compute).generatedId(GENERATED_ID).operationId((OperationId)GLOBAL_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId(TARGET_ID).status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.serviceMockReturnsOptions});
    }

    private void assertEqualsCommonFields(Operation operation) {
        Assert.assertEquals((Object)GENERATED_ID, (Object)operation.generatedId());
        Assert.assertEquals((Object)CLIENT_OPERATION_ID, (Object)operation.clientOperationId());
        Assert.assertEquals((Object)OPERATION_TYPE, (Object)operation.operationType());
        Assert.assertEquals((Object)TARGET_LINK, (Object)operation.targetLink());
        Assert.assertEquals((Object)TARGET_ID, (Object)operation.targetId());
        Assert.assertEquals((Object)STATUS, (Object)operation.status());
        Assert.assertEquals((Object)STATUS_MESSAGE, (Object)operation.statusMessage());
        Assert.assertEquals((Object)USER, (Object)operation.user());
        Assert.assertEquals((Object)PROGRESS, (Object)operation.progress());
        Assert.assertEquals((Object)INSERT_TIME, (Object)operation.insertTime());
        Assert.assertEquals((Object)START_TIME, (Object)operation.startTime());
        Assert.assertEquals((Object)END_TIME, (Object)operation.endTime());
        Assert.assertEquals(ERRORS, (Object)operation.errors());
        Assert.assertEquals(WARNINGS, (Object)operation.warnings());
        Assert.assertEquals((Object)HTTP_ERROR_STATUS_CODE, (Object)this.globalOperation.httpErrorStatusCode());
        Assert.assertEquals((Object)HTTP_ERROR_MESSAGE, (Object)this.globalOperation.httpErrorMessage());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.globalOperation.description());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.globalOperation.compute());
    }

    private void assertNullCommonFields(Operation operation) {
        Assert.assertNull((Object)operation.generatedId());
        Assert.assertNull((Object)operation.clientOperationId());
        Assert.assertNull((Object)operation.operationType());
        Assert.assertNull((Object)operation.targetLink());
        Assert.assertNull((Object)operation.targetId());
        Assert.assertNull((Object)operation.status());
        Assert.assertNull((Object)operation.statusMessage());
        Assert.assertNull((Object)operation.user());
        Assert.assertNull((Object)operation.progress());
        Assert.assertNull((Object)operation.insertTime());
        Assert.assertNull((Object)operation.startTime());
        Assert.assertNull((Object)operation.endTime());
        Assert.assertNull((Object)operation.errors());
        Assert.assertNull((Object)operation.warnings());
        Assert.assertNull((Object)operation.httpErrorStatusCode());
        Assert.assertNull((Object)operation.httpErrorMessage());
        Assert.assertNull((Object)operation.description());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)operation.compute());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedOperation(6);
        this.assertEqualsCommonFields(this.globalOperation);
        Assert.assertEquals((Object)GLOBAL_OPERATION_ID, (Object)this.globalOperation.operationId());
        this.assertEqualsCommonFields(this.regionOperation);
        Assert.assertEquals((Object)REGION_OPERATION_ID, (Object)this.regionOperation.operationId());
        this.assertEqualsCommonFields(this.zoneOperation);
        Assert.assertEquals((Object)ZONE_OPERATION_ID, (Object)this.zoneOperation.operationId());
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GLOBAL_OPERATION_ID).build();
        this.assertNullCommonFields(operation);
        Assert.assertEquals((Object)GLOBAL_OPERATION_ID, (Object)operation.operationId());
        operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZONE_OPERATION_ID).build();
        this.assertNullCommonFields(operation);
        Assert.assertEquals((Object)ZONE_OPERATION_ID, (Object)operation.operationId());
        operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)REGION_OPERATION_ID).build();
        this.assertNullCommonFields(operation);
        Assert.assertEquals((Object)REGION_OPERATION_ID, (Object)operation.operationId());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedOperation(24);
        this.compareOperation(this.globalOperation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb()));
        Assert.assertNotNull((Object)this.regionOperation.toPb().getRegion());
        this.compareOperation(this.regionOperation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.regionOperation.toPb()));
        Assert.assertNotNull((Object)this.zoneOperation.toPb().getZone());
        this.compareOperation(this.zoneOperation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.zoneOperation.toPb()));
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GLOBAL_OPERATION_ID).build();
        this.compareOperation(operation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)operation.toPb()));
        operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)ZONE_OPERATION_ID).build();
        this.compareOperation(operation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)operation.toPb()));
        operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)REGION_OPERATION_ID).build();
        this.compareOperation(operation, Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)operation.toPb()));
    }

    @Test
    public void testDeleteTrue() {
        this.initializeExpectedOperation(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteOperation((OperationId)GLOBAL_OPERATION_ID)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertTrue((boolean)this.operation.delete());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testDeleteFalse() {
        this.initializeExpectedOperation(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteOperation((OperationId)GLOBAL_OPERATION_ID)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertFalse((boolean)this.operation.delete());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedOperation(3);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)this.globalOperation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertTrue((boolean)this.operation.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedOperation(3);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertFalse((boolean)this.operation.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testIsDone_True() throws Exception {
        this.initializeExpectedOperation(3);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)this.globalOperation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertTrue((boolean)this.operation.isDone());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testIsDone_False() throws Exception {
        this.initializeExpectedOperation(4);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setStatus("PENDING")));
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertFalse((boolean)this.operation.isDone());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testIsDone_NotExists() throws Exception {
        this.initializeExpectedOperation(3);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertTrue((boolean)this.operation.isDone());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testWaitFor() throws InterruptedException, TimeoutException {
        this.initializeExpectedOperation(4);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        Operation successOperation = Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setError(null));
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.mockOptions.clock()).andReturn((Object)Clock.defaultClock());
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)successOperation);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn((Object)successOperation);
        EasyMock.replay((Object[])new Object[]{this.compute, this.mockOptions});
        this.initializeOperation();
        Assert.assertSame((Object)successOperation, (Object)this.operation.waitFor(new WaitForOption[0]));
        EasyMock.verify((Object[])new Object[]{this.mockOptions});
    }

    @Test
    public void testWaitFor_Null() throws InterruptedException, TimeoutException {
        this.initializeExpectedOperation(3);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.mockOptions.clock()).andReturn((Object)Clock.defaultClock());
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn(null);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute, this.mockOptions});
        this.initializeOperation();
        Assert.assertNull((Object)this.operation.waitFor(new WaitForOption[0]));
        EasyMock.verify((Object[])new Object[]{this.mockOptions});
    }

    @Test
    public void testWaitForCheckingPeriod() throws InterruptedException, TimeoutException {
        this.initializeExpectedOperation(5);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        TimeUnit timeUnit = (TimeUnit)((Object)EasyMock.createStrictMock(TimeUnit.class));
        timeUnit.sleep(42L);
        EasyMock.expectLastCall();
        Operation runningOperation = Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setError(null).setStatus("RUNNING"));
        Operation completedOperation = Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setError(null));
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.mockOptions.clock()).andReturn((Object)Clock.defaultClock());
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)runningOperation);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)completedOperation);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn((Object)completedOperation);
        EasyMock.replay((Object[])new Object[]{this.compute, timeUnit, this.mockOptions});
        this.initializeOperation();
        Assert.assertSame((Object)completedOperation, (Object)this.operation.waitFor(new WaitForOption[]{WaitForOption.checkEvery((long)42L, (TimeUnit)timeUnit)}));
        EasyMock.verify((Object[])new Object[]{timeUnit, this.mockOptions});
    }

    @Test
    public void testWaitForCheckingPeriod_Null() throws InterruptedException, TimeoutException {
        this.initializeExpectedOperation(4);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        TimeUnit timeUnit = (TimeUnit)((Object)EasyMock.createStrictMock(TimeUnit.class));
        timeUnit.sleep(42L);
        EasyMock.expectLastCall();
        Operation runningOperation = Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setError(null).setStatus("RUNNING"));
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.mockOptions.clock()).andReturn((Object)Clock.defaultClock());
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)runningOperation);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn(null);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute, timeUnit, this.mockOptions});
        this.initializeOperation();
        Assert.assertNull((Object)this.operation.waitFor(new WaitForOption[]{WaitForOption.checkEvery((long)42L, (TimeUnit)timeUnit)}));
        EasyMock.verify((Object[])new Object[]{this.compute, timeUnit, this.mockOptions});
    }

    @Test
    public void testWaitForWithTimeout() throws InterruptedException, TimeoutException {
        this.initializeExpectedOperation(4);
        Compute.OperationOption[] expectedOptions = new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.STATUS})};
        TimeUnit timeUnit = (TimeUnit)((Object)EasyMock.createStrictMock(TimeUnit.class));
        timeUnit.sleep(1L);
        EasyMock.expectLastCall();
        Clock clock = (Clock)EasyMock.createStrictMock(Clock.class);
        EasyMock.expect((Object)clock.millis()).andReturn((Object)0L);
        EasyMock.expect((Object)clock.millis()).andReturn((Object)1L);
        EasyMock.expect((Object)clock.millis()).andReturn((Object)3L);
        Operation runningOperation = Operation.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Operation)this.globalOperation.toPb().setError(null).setStatus("RUNNING"));
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.mockOptions.clock()).andReturn((Object)clock);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)runningOperation);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, expectedOptions)).andReturn((Object)runningOperation);
        EasyMock.replay((Object[])new Object[]{this.compute, timeUnit, clock, this.mockOptions});
        this.initializeOperation();
        this.thrown.expect(TimeoutException.class);
        this.operation.waitFor(new WaitForOption[]{WaitForOption.checkEvery((long)1L, (TimeUnit)timeUnit), WaitForOption.timeout((long)3L, (TimeUnit)TimeUnit.MILLISECONDS)});
        EasyMock.verify((Object[])new Object[]{this.compute, timeUnit, clock, this.mockOptions});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedOperation(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn((Object)this.globalOperation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Operation updatedOperation = this.operation.reload(new Compute.OperationOption[0]);
        this.compareOperation(this.globalOperation, updatedOperation);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedOperation(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Assert.assertNull((Object)this.operation.reload(new Compute.OperationOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedOperation(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])})).andReturn((Object)this.globalOperation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeOperation();
        Operation updatedOperation = this.operation.reload(new Compute.OperationOption[]{Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0])});
        this.compareOperation(this.globalOperation, updatedOperation);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    private void compareOperation(Operation expected, Operation value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.operationId(), (Object)value.operationId());
        Assert.assertEquals((Object)expected.clientOperationId(), (Object)value.clientOperationId());
        Assert.assertEquals((Object)expected.operationType(), (Object)value.operationType());
        Assert.assertEquals((Object)expected.targetLink(), (Object)value.targetLink());
        Assert.assertEquals((Object)expected.targetId(), (Object)value.targetId());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.statusMessage(), (Object)value.statusMessage());
        Assert.assertEquals((Object)expected.user(), (Object)value.user());
        Assert.assertEquals((Object)expected.progress(), (Object)value.progress());
        Assert.assertEquals((Object)expected.insertTime(), (Object)value.insertTime());
        Assert.assertEquals((Object)expected.startTime(), (Object)value.startTime());
        Assert.assertEquals((Object)expected.endTime(), (Object)value.endTime());
        Assert.assertEquals((Object)expected.errors(), (Object)value.errors());
        Assert.assertEquals((Object)expected.warnings(), (Object)value.warnings());
        Assert.assertEquals((Object)expected.httpErrorStatusCode(), (Object)value.httpErrorStatusCode());
        Assert.assertEquals((Object)expected.httpErrorMessage(), (Object)value.httpErrorMessage());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

