/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.RegionId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RegionIdTest {
    private static final String PROJECT = "project";
    private static final String REGION = "region";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/regions/region";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        RegionId regionId = RegionId.of((String)PROJECT, (String)REGION);
        Assert.assertEquals((Object)PROJECT, (Object)regionId.project());
        Assert.assertEquals((Object)REGION, (Object)regionId.region());
        Assert.assertEquals((Object)URL, (Object)regionId.selfLink());
        regionId = RegionId.of((String)REGION);
        Assert.assertNull((Object)regionId.project());
        Assert.assertEquals((Object)REGION, (Object)regionId.region());
    }

    @Test
    public void testToAndFromUrl() {
        RegionId regionId = RegionId.of((String)PROJECT, (String)REGION);
        this.compareRegionId(regionId, RegionId.fromUrl((String)regionId.selfLink()));
    }

    @Test
    public void testSetProjectId() {
        RegionId regionId = RegionId.of((String)PROJECT, (String)REGION);
        Assert.assertSame((Object)regionId, (Object)regionId.setProjectId(PROJECT));
        this.compareRegionId(regionId, RegionId.of((String)REGION).setProjectId(PROJECT));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid region URL");
        RegionId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)RegionId.matchesUrl((String)RegionId.of((String)PROJECT, (String)REGION).selfLink()));
        Assert.assertFalse((boolean)RegionId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareRegionId(RegionId expected, RegionId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.region(), (Object)expected.region());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

