/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.ZoneId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RegionTest {
    private static final RegionId REGION_ID = RegionId.of((String)"project", (String)"region");
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final Region.Status STATUS = Region.Status.DOWN;
    private static final ZoneId ZONE_ID1 = ZoneId.of((String)"project", (String)"zone1");
    private static final ZoneId ZONE_ID2 = ZoneId.of((String)"project", (String)"zone2");
    private static final List<ZoneId> ZONES = ImmutableList.of((Object)ZONE_ID1, (Object)ZONE_ID2);
    private static final Region.Quota QUOTA1 = new Region.Quota("METRIC1", 2.0, 1.0);
    private static final Region.Quota QUOTA2 = new Region.Quota("METRIC2", 4.0, 3.0);
    private static final List<Region.Quota> QUOTAS = ImmutableList.of((Object)QUOTA1, (Object)QUOTA2);
    private static final DeprecationStatus<RegionId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)REGION_ID);
    private static final Region REGION = Region.builder().regionId(REGION_ID).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).zones(ZONES).quotas(QUOTAS).deprecationStatus(DEPRECATION_STATUS).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)REGION_ID, (Object)REGION.regionId());
        Assert.assertEquals((Object)GENERATED_ID, (Object)REGION.generatedId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)REGION.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)REGION.description());
        Assert.assertEquals((Object)STATUS, (Object)REGION.status());
        Assert.assertEquals(ZONES, (Object)REGION.zones());
        Assert.assertEquals(QUOTAS, (Object)REGION.quotas());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)REGION.deprecationStatus());
    }

    @Test
    public void testToAndFromPb() {
        Region region = Region.fromPb((com.google.api.services.compute.model.Region)REGION.toPb());
        this.compareRegions(REGION, region);
        Assert.assertEquals((Object)REGION_ID.project(), (Object)region.regionId().project());
        Assert.assertEquals((Object)REGION_ID.region(), (Object)region.regionId().region());
        region = Region.builder().regionId(REGION_ID).build();
        this.compareRegions(region, Region.fromPb((com.google.api.services.compute.model.Region)region.toPb()));
    }

    private void compareRegions(Region expected, Region value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.regionId(), (Object)value.regionId());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.zones(), (Object)value.zones());
        Assert.assertEquals((Object)expected.quotas(), (Object)value.quotas());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

