/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Scheduling;
import com.google.cloud.compute.SchedulingOptions;
import org.junit.Assert;
import org.junit.Test;

public class SchedulingOptionsTest {
    private static final SchedulingOptions SCHEDULING_OPTIONS = SchedulingOptions.preemptible();

    @Test
    public void testFactoryMethods() {
        Assert.assertTrue((boolean)SCHEDULING_OPTIONS.isPreemptible());
        Assert.assertFalse((boolean)SCHEDULING_OPTIONS.automaticRestart());
        Assert.assertEquals((Object)SchedulingOptions.Maintenance.TERMINATE, (Object)SCHEDULING_OPTIONS.maintenance());
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        Assert.assertFalse((boolean)schedulingOptions.isPreemptible());
        Assert.assertTrue((boolean)schedulingOptions.automaticRestart());
        Assert.assertEquals((Object)SchedulingOptions.Maintenance.MIGRATE, (Object)schedulingOptions.maintenance());
    }

    @Test
    public void testToAndFromPb() {
        this.compareSchedulingOptions(SCHEDULING_OPTIONS, SchedulingOptions.fromPb((Scheduling)SCHEDULING_OPTIONS.toPb()));
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        this.compareSchedulingOptions(schedulingOptions, SchedulingOptions.fromPb((Scheduling)schedulingOptions.toPb()));
    }

    public void compareSchedulingOptions(SchedulingOptions expected, SchedulingOptions value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.isPreemptible(), (Object)value.isPreemptible());
        Assert.assertEquals((Object)expected.maintenance(), (Object)value.maintenance());
        Assert.assertEquals((Object)expected.automaticRestart(), (Object)value.automaticRestart());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

