/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.AuthCredentials;
import com.google.cloud.BaseSerializationTest;
import com.google.cloud.Restorable;
import com.google.cloud.RetryParams;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.GlobalForwardingRuleId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionForwardingRuleId;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.ServiceAccount;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.StorageImageConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.Tags;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.ZoneId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class SerializationTest
extends BaseSerializationTest {
    private static final Compute COMPUTE = (Compute)((ComputeOptions.Builder)ComputeOptions.builder().projectId("p")).build().service();
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final String VALID_DISK_SIZE = "10GB-10TB";
    private static final Long DEFAULT_DISK_SIZE_GB = 10L;
    private static final DiskTypeId DISK_TYPE_ID = DiskTypeId.of((String)"project", (String)"zone", (String)"diskType");
    private static final DiskType DISK_TYPE = DiskType.builder().diskTypeId(DISK_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").validDiskSize("10GB-10TB").defaultDiskSizeGb(DEFAULT_DISK_SIZE_GB).build();
    private static final MachineTypeId MACHINE_TYPE_ID = MachineTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final Integer GUEST_CPUS = 1;
    private static final Integer MEMORY_MB = 2;
    private static final List<Integer> SCRATCH_DISKS = ImmutableList.of((Object)3);
    private static final Integer MAXIMUM_PERSISTENT_DISKS = 4;
    private static final Long MAXIMUM_PERSISTENT_DISKS_SIZE_GB = 5L;
    private static final MachineType MACHINE_TYPE = MachineType.builder().machineTypeId(MACHINE_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").cpus(GUEST_CPUS).memoryMb(MEMORY_MB).scratchDisksSizeGb(SCRATCH_DISKS).maximumPersistentDisks(MAXIMUM_PERSISTENT_DISKS).maximumPersistentDisksSizeGb(MAXIMUM_PERSISTENT_DISKS_SIZE_GB).build();
    private static final RegionId REGION_ID = RegionId.of((String)"project", (String)"region");
    private static final Region.Status REGION_STATUS = Region.Status.DOWN;
    private static final ZoneId ZONE_ID1 = ZoneId.of((String)"project", (String)"zone1");
    private static final ZoneId ZONE_ID2 = ZoneId.of((String)"project", (String)"zone2");
    private static final List<ZoneId> ZONES = ImmutableList.of((Object)ZONE_ID1, (Object)ZONE_ID2);
    private static final Region.Quota QUOTA1 = new Region.Quota("METRIC1", 2.0, 1.0);
    private static final Region.Quota QUOTA2 = new Region.Quota("METRIC2", 4.0, 3.0);
    private static final List<Region.Quota> QUOTAS = ImmutableList.of((Object)QUOTA1, (Object)QUOTA2);
    private static final Region REGION = Region.builder().regionId(REGION_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").status(REGION_STATUS).zones(ZONES).quotas(QUOTAS).build();
    private static final ZoneId ZONE_ID = ZoneId.of((String)"project", (String)"zone");
    private static final Zone.Status ZONE_STATUS = Zone.Status.DOWN;
    private static final Zone ZONE = Zone.builder().zoneId(ZONE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").status(ZONE_STATUS).region(REGION_ID).build();
    private static final DeprecationStatus<MachineTypeId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)MACHINE_TYPE_ID);
    private static final LicenseId LICENSE_ID = LicenseId.of((String)"project", (String)"license");
    private static final Boolean CHARGES_USE_FEE = true;
    private static final License LICENSE = new License(LICENSE_ID, CHARGES_USE_FEE);
    private static final GlobalOperationId GLOBAL_OPERATION_ID = GlobalOperationId.of((String)"project", (String)"op");
    private static final ZoneOperationId ZONE_OPERATION_ID = ZoneOperationId.of((String)"project", (String)"zone", (String)"op");
    private static final RegionOperationId REGION_OPERATION_ID = RegionOperationId.of((String)"project", (String)"region", (String)"op");
    private static final Operation GLOBAL_OPERATION = new Operation.Builder(COMPUTE).operationId((OperationId)GLOBAL_OPERATION_ID).build();
    private static final Operation ZONE_OPERATION = new Operation.Builder(COMPUTE).operationId((OperationId)ZONE_OPERATION_ID).build();
    private static final Operation REGION_OPERATION = new Operation.Builder(COMPUTE).operationId((OperationId)REGION_OPERATION_ID).build();
    private static final InstanceId INSTANCE_ID = InstanceId.of((String)"project", (String)"zone", (String)"instance");
    private static final GlobalForwardingRuleId GLOBAL_FORWARDING_RULE_ID = GlobalForwardingRuleId.of((String)"project", (String)"rule");
    private static final RegionForwardingRuleId REGION_FORWARDING_RULE_ID = RegionForwardingRuleId.of((String)"project", (String)"region", (String)"rule");
    private static final GlobalAddressId GLOBAL_ADDRESS_ID = GlobalAddressId.of((String)"project", (String)"address");
    private static final RegionAddressId REGION_ADDRESS_ID = RegionAddressId.of((String)"project", (String)"region", (String)"address");
    private static final AddressInfo.InstanceUsage INSTANCE_USAGE = new AddressInfo.InstanceUsage(INSTANCE_ID);
    private static final AddressInfo.GlobalForwardingUsage GLOBAL_FORWARDING_USAGE = new AddressInfo.GlobalForwardingUsage((List)ImmutableList.of((Object)GLOBAL_FORWARDING_RULE_ID));
    private static final AddressInfo.RegionForwardingUsage REGION_FORWARDING_USAGE = new AddressInfo.RegionForwardingUsage((List)ImmutableList.of((Object)REGION_FORWARDING_RULE_ID));
    private static final AddressInfo ADDRESS_INFO = AddressInfo.builder((AddressId)REGION_ADDRESS_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").usage((AddressInfo.Usage)INSTANCE_USAGE).build();
    private static final Address ADDRESS = new Address.Builder(COMPUTE, (AddressId)REGION_ADDRESS_ID).build();
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final SnapshotId SNAPSHOT_ID = SnapshotId.of((String)"project", (String)"snapshot");
    private static final SnapshotInfo SNAPSHOT_INFO = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)DISK_ID);
    private static final Snapshot SNAPSHOT = new Snapshot.Builder(COMPUTE, SNAPSHOT_ID, DISK_ID).build();
    private static final ImageId IMAGE_ID = ImageId.of((String)"project", (String)"image");
    private static final DiskImageConfiguration DISK_IMAGE_CONFIGURATION = DiskImageConfiguration.of((DiskId)DISK_ID);
    private static final StorageImageConfiguration STORAGE_IMAGE_CONFIGURATION = StorageImageConfiguration.of((String)"gs:/bucket/file");
    private static final ImageInfo IMAGE_INFO = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DISK_IMAGE_CONFIGURATION);
    private static final Image IMAGE = new Image.Builder(COMPUTE, IMAGE_ID, (ImageConfiguration)DISK_IMAGE_CONFIGURATION).build();
    private static final StandardDiskConfiguration STANDARD_DISK_CONFIGURATION = StandardDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID);
    private static final ImageDiskConfiguration IMAGE_DISK_CONFIGURATION = ImageDiskConfiguration.of((ImageId)IMAGE_ID);
    private static final SnapshotDiskConfiguration SNAPSHOT_DISK_CONFIGURATION = SnapshotDiskConfiguration.of((SnapshotId)SNAPSHOT_ID);
    private static final DiskInfo DISK_INFO = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)STANDARD_DISK_CONFIGURATION);
    private static final Disk DISK = new Disk.Builder(COMPUTE, DISK_ID, (DiskConfiguration)STANDARD_DISK_CONFIGURATION).build();
    private static final SubnetworkId SUBNETWORK_ID = SubnetworkId.of((String)"project", (String)"region", (String)"subnetwork");
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final SubnetworkInfo SUBNETWORK_INFO = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)"192.168.0.0/16");
    private static final Subnetwork SUBNETWORK = new Subnetwork.Builder(COMPUTE, SUBNETWORK_ID, NETWORK_ID, "192.168.0.0/16").build();
    private static final StandardNetworkConfiguration STANDARD_NETWORK_CONFIGURATION = StandardNetworkConfiguration.of((String)"192.168.0.0/16");
    private static final SubnetNetworkConfiguration SUBNET_NETWORK_CONFIGURATION = SubnetNetworkConfiguration.of((boolean)false);
    private static final NetworkInfo NETWORK_INFO = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)STANDARD_NETWORK_CONFIGURATION);
    private static final Network NETWORK = new Network.Builder(COMPUTE, NETWORK_ID, (NetworkConfiguration)STANDARD_NETWORK_CONFIGURATION).build();
    private static final NetworkInterface.AccessConfig ACCESS_CONFIG = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
    private static final NetworkInterface NETWORK_INTERFACE = NetworkInterface.builder((NetworkId)NETWORK_ID).accessConfigurations(new NetworkInterface.AccessConfig[]{ACCESS_CONFIG}).build();
    private static final AttachedDisk.CreateDiskConfiguration CREATE_DISK_CONFIGURATION = AttachedDisk.CreateDiskConfiguration.of((ImageId)IMAGE_ID);
    private static final AttachedDisk.PersistentDiskConfiguration PERSISTENT_DISK_CONFIGURATION = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
    private static final AttachedDisk.ScratchDiskConfiguration SCRATCH_DISK_CONFIGURATION = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID);
    private static final AttachedDisk ATTACHED_DISK = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
    private static final Tags TAGS = Tags.of((String[])new String[]{"tag1", "tag2"});
    private static final Metadata METADATA = Metadata.of((Map)ImmutableMap.of((Object)"key1", (Object)"val1"));
    private static final ServiceAccount SERVICE_ACCOUNT = ServiceAccount.of((String)"email", (String[])new String[0]);
    private static final SchedulingOptions SCHEDULING_OPTIONS = SchedulingOptions.preemptible();
    private static final InstanceInfo INSTANCE_INFO = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE_ID, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
    private static final Instance INSTANCE = new Instance.Builder(COMPUTE, INSTANCE_ID, MACHINE_TYPE_ID, ATTACHED_DISK, NETWORK_INTERFACE).build();
    private static final Compute.DiskTypeOption DISK_TYPE_OPTION = Compute.DiskTypeOption.fields((Compute.DiskTypeField[])new Compute.DiskTypeField[0]);
    private static final Compute.DiskTypeFilter DISK_TYPE_FILTER = Compute.DiskTypeFilter.equals((Compute.DiskTypeField)Compute.DiskTypeField.SELF_LINK, (String)"selfLink");
    private static final Compute.DiskTypeListOption DISK_TYPE_LIST_OPTION = Compute.DiskTypeListOption.filter((Compute.DiskTypeFilter)DISK_TYPE_FILTER);
    private static final Compute.DiskTypeAggregatedListOption DISK_TYPE_AGGREGATED_LIST_OPTION = Compute.DiskTypeAggregatedListOption.filter((Compute.DiskTypeFilter)DISK_TYPE_FILTER);
    private static final Compute.MachineTypeOption MACHINE_TYPE_OPTION = Compute.MachineTypeOption.fields((Compute.MachineTypeField[])new Compute.MachineTypeField[0]);
    private static final Compute.MachineTypeFilter MACHINE_TYPE_FILTER = Compute.MachineTypeFilter.equals((Compute.MachineTypeField)Compute.MachineTypeField.SELF_LINK, (String)"selfLink");
    private static final Compute.MachineTypeListOption MACHINE_TYPE_LIST_OPTION = Compute.MachineTypeListOption.filter((Compute.MachineTypeFilter)MACHINE_TYPE_FILTER);
    private static final Compute.MachineTypeAggregatedListOption MACHINE_TYPE_AGGREGATED_LIST_OPTION = Compute.MachineTypeAggregatedListOption.filter((Compute.MachineTypeFilter)MACHINE_TYPE_FILTER);
    private static final Compute.RegionOption REGION_OPTION = Compute.RegionOption.fields((Compute.RegionField[])new Compute.RegionField[0]);
    private static final Compute.RegionFilter REGION_FILTER = Compute.RegionFilter.equals((Compute.RegionField)Compute.RegionField.SELF_LINK, (String)"selfLink");
    private static final Compute.RegionListOption REGION_LIST_OPTION = Compute.RegionListOption.filter((Compute.RegionFilter)REGION_FILTER);
    private static final Compute.ZoneOption ZONE_OPTION = Compute.ZoneOption.fields((Compute.ZoneField[])new Compute.ZoneField[0]);
    private static final Compute.ZoneFilter ZONE_FILTER = Compute.ZoneFilter.equals((Compute.ZoneField)Compute.ZoneField.SELF_LINK, (String)"selfLink");
    private static final Compute.ZoneListOption ZONE_LIST_OPTION = Compute.ZoneListOption.filter((Compute.ZoneFilter)ZONE_FILTER);
    private static final Compute.LicenseOption LICENSE_OPTION = Compute.LicenseOption.fields((Compute.LicenseField[])new Compute.LicenseField[0]);
    private static final Compute.OperationOption OPERATION_OPTION = Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[0]);
    private static final Compute.OperationFilter OPERATION_FILTER = Compute.OperationFilter.equals((Compute.OperationField)Compute.OperationField.SELF_LINK, (String)"selfLink");
    private static final Compute.OperationListOption OPERATION_LIST_OPTION = Compute.OperationListOption.filter((Compute.OperationFilter)OPERATION_FILTER);
    private static final Compute.AddressOption ADDRESS_OPTION = Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0]);
    private static final Compute.AddressFilter ADDRESS_FILTER = Compute.AddressFilter.equals((Compute.AddressField)Compute.AddressField.SELF_LINK, (String)"selfLink");
    private static final Compute.AddressListOption ADDRESS_LIST_OPTION = Compute.AddressListOption.filter((Compute.AddressFilter)ADDRESS_FILTER);
    private static final Compute.AddressAggregatedListOption ADDRESS_AGGREGATED_LIST_OPTION = Compute.AddressAggregatedListOption.filter((Compute.AddressFilter)ADDRESS_FILTER);
    private static final Compute.SnapshotOption SNAPSHOT_OPTION = Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[0]);
    private static final Compute.SnapshotFilter SNAPSHOT_FILTER = Compute.SnapshotFilter.equals((Compute.SnapshotField)Compute.SnapshotField.SELF_LINK, (String)"selfLink");
    private static final Compute.SnapshotListOption SNAPSHOT_LIST_OPTION = Compute.SnapshotListOption.filter((Compute.SnapshotFilter)SNAPSHOT_FILTER);
    private static final Compute.ImageOption IMAGE_OPTION = Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[0]);
    private static final Compute.ImageFilter IMAGE_FILTER = Compute.ImageFilter.equals((Compute.ImageField)Compute.ImageField.SELF_LINK, (String)"selfLink");
    private static final Compute.ImageListOption IMAGE_LIST_OPTION = Compute.ImageListOption.filter((Compute.ImageFilter)IMAGE_FILTER);
    private static final Compute.DiskOption DISK_OPTION = Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0]);
    private static final Compute.DiskFilter DISK_FILTER = Compute.DiskFilter.equals((Compute.DiskField)Compute.DiskField.SELF_LINK, (String)"selfLink");
    private static final Compute.DiskListOption DISK_LIST_OPTION = Compute.DiskListOption.filter((Compute.DiskFilter)DISK_FILTER);
    private static final Compute.DiskAggregatedListOption DISK_AGGREGATED_LIST_OPTION = Compute.DiskAggregatedListOption.filter((Compute.DiskFilter)DISK_FILTER);
    private static final Compute.SubnetworkOption SUBNETWORK_OPTION = Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[0]);
    private static final Compute.SubnetworkFilter SUBNETWORK_FILTER = Compute.SubnetworkFilter.equals((Compute.SubnetworkField)Compute.SubnetworkField.SELF_LINK, (String)"selfLink");
    private static final Compute.SubnetworkListOption SUBNETWORK_LIST_OPTION = Compute.SubnetworkListOption.filter((Compute.SubnetworkFilter)SUBNETWORK_FILTER);
    private static final Compute.SubnetworkAggregatedListOption SUBNETWORK_AGGREGATED_LIST_OPTION = Compute.SubnetworkAggregatedListOption.filter((Compute.SubnetworkFilter)SUBNETWORK_FILTER);
    private static final Compute.NetworkOption NETWORK_OPTION = Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[0]);
    private static final Compute.NetworkFilter NETWORK_FILTER = Compute.NetworkFilter.equals((Compute.NetworkField)Compute.NetworkField.SELF_LINK, (String)"selfLink");
    private static final Compute.NetworkListOption NETWORK_LIST_OPTION = Compute.NetworkListOption.filter((Compute.NetworkFilter)NETWORK_FILTER);
    private static final Compute.InstanceOption INSTANCE_OPTION = Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[0]);
    private static final Compute.InstanceFilter INSTANCE_FILTER = Compute.InstanceFilter.equals((Compute.InstanceField)Compute.InstanceField.SELF_LINK, (String)"selfLink");
    private static final Compute.InstanceListOption INSTANCE_LIST_OPTION = Compute.InstanceListOption.filter((Compute.InstanceFilter)INSTANCE_FILTER);
    private static final Compute.InstanceAggregatedListOption INSTANCE_AGGREGATED_LIST_OPTION = Compute.InstanceAggregatedListOption.filter((Compute.InstanceFilter)INSTANCE_FILTER);

    protected Serializable[] serializableObjects() {
        ComputeOptions options = ((ComputeOptions.Builder)((ComputeOptions.Builder)ComputeOptions.builder().projectId("p1")).authCredentials(AuthCredentials.createForAppEngine())).build();
        ComputeOptions otherOptions = ((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)options.toBuilder().projectId("p2")).retryParams(RetryParams.defaultInstance())).authCredentials(null)).build();
        return new Serializable[]{DISK_TYPE_ID, DISK_TYPE, MACHINE_TYPE_ID, MACHINE_TYPE, REGION_ID, REGION, ZONE_ID, ZONE, LICENSE_ID, LICENSE, DEPRECATION_STATUS, GLOBAL_OPERATION_ID, REGION_OPERATION_ID, ZONE_OPERATION_ID, GLOBAL_OPERATION, REGION_OPERATION, ZONE_OPERATION, INSTANCE_ID, REGION_FORWARDING_RULE_ID, GLOBAL_FORWARDING_RULE_ID, GLOBAL_ADDRESS_ID, REGION_ADDRESS_ID, INSTANCE_USAGE, GLOBAL_FORWARDING_USAGE, REGION_FORWARDING_USAGE, ADDRESS_INFO, ADDRESS, DISK_ID, SNAPSHOT_ID, SNAPSHOT_INFO, SNAPSHOT, IMAGE_ID, DISK_IMAGE_CONFIGURATION, STORAGE_IMAGE_CONFIGURATION, IMAGE_INFO, IMAGE, STANDARD_DISK_CONFIGURATION, IMAGE_DISK_CONFIGURATION, SNAPSHOT_DISK_CONFIGURATION, DISK_INFO, DISK, SUBNETWORK_ID, NETWORK_ID, SUBNETWORK_INFO, SUBNETWORK, STANDARD_NETWORK_CONFIGURATION, SUBNET_NETWORK_CONFIGURATION, NETWORK_INFO, NETWORK, ACCESS_CONFIG, NETWORK_INTERFACE, CREATE_DISK_CONFIGURATION, PERSISTENT_DISK_CONFIGURATION, SCRATCH_DISK_CONFIGURATION, ATTACHED_DISK, TAGS, METADATA, SERVICE_ACCOUNT, SCHEDULING_OPTIONS, INSTANCE_INFO, INSTANCE, DISK_TYPE_OPTION, DISK_TYPE_FILTER, DISK_TYPE_LIST_OPTION, DISK_TYPE_AGGREGATED_LIST_OPTION, MACHINE_TYPE_OPTION, MACHINE_TYPE_FILTER, MACHINE_TYPE_LIST_OPTION, MACHINE_TYPE_AGGREGATED_LIST_OPTION, REGION_OPTION, REGION_FILTER, REGION_LIST_OPTION, ZONE_OPTION, ZONE_FILTER, ZONE_LIST_OPTION, LICENSE_OPTION, OPERATION_OPTION, OPERATION_FILTER, OPERATION_LIST_OPTION, ADDRESS_OPTION, ADDRESS_FILTER, ADDRESS_LIST_OPTION, ADDRESS_AGGREGATED_LIST_OPTION, SNAPSHOT_OPTION, SNAPSHOT_FILTER, SNAPSHOT_LIST_OPTION, IMAGE_OPTION, IMAGE_FILTER, IMAGE_LIST_OPTION, DISK_OPTION, DISK_FILTER, DISK_LIST_OPTION, DISK_AGGREGATED_LIST_OPTION, SUBNETWORK_OPTION, SUBNETWORK_FILTER, SUBNETWORK_LIST_OPTION, SUBNETWORK_AGGREGATED_LIST_OPTION, NETWORK_OPTION, NETWORK_FILTER, NETWORK_LIST_OPTION, INSTANCE_OPTION, INSTANCE_FILTER, INSTANCE_LIST_OPTION, INSTANCE_AGGREGATED_LIST_OPTION, options, otherOptions};
    }

    protected Restorable<?>[] restorableObjects() {
        return null;
    }
}

