/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotDiskConfigurationTest {
    private static final Long SIZE = 42L;
    private static final DiskTypeId DISK_TYPE = DiskTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final SnapshotId SNAPSHOT = SnapshotId.of((String)"project", (String)"snapshot");
    private static final String SNAPSHOT_ID = "snapshotId";
    private static final SnapshotDiskConfiguration DISK_CONFIGURATION = ((SnapshotDiskConfiguration.Builder)SnapshotDiskConfiguration.builder((SnapshotId)SNAPSHOT).sizeGb(SIZE).diskType(DISK_TYPE)).sourceSnapshotId("snapshotId").build();

    @Test
    public void testToBuilder() {
        this.compareSnapshotDiskConfiguration(DISK_CONFIGURATION, DISK_CONFIGURATION.toBuilder().build());
        SnapshotId newSnapshot = SnapshotId.of((String)"newProject", (String)"newSnapshot");
        SnapshotDiskConfiguration diskConfiguration = DISK_CONFIGURATION.toBuilder().sizeGb(Long.valueOf(24L)).sourceSnapshot(newSnapshot).sourceSnapshotId("newSnapshotId").build();
        Assert.assertEquals((long)24L, (long)diskConfiguration.sizeGb());
        Assert.assertEquals((Object)newSnapshot, (Object)diskConfiguration.sourceSnapshot());
        Assert.assertEquals((Object)"newSnapshotId", (Object)diskConfiguration.sourceSnapshotId());
        diskConfiguration = diskConfiguration.toBuilder().sizeGb(SIZE).sourceSnapshot(SNAPSHOT).sourceSnapshotId(SNAPSHOT_ID).build();
        this.compareSnapshotDiskConfiguration(DISK_CONFIGURATION, diskConfiguration);
    }

    @Test
    public void testToBuilderIncomplete() {
        SnapshotDiskConfiguration diskConfiguration = SnapshotDiskConfiguration.of((SnapshotId)SNAPSHOT);
        this.compareSnapshotDiskConfiguration(diskConfiguration, diskConfiguration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DISK_TYPE, (Object)DISK_CONFIGURATION.diskType());
        Assert.assertEquals((Object)SIZE, (Object)DISK_CONFIGURATION.sizeGb());
        Assert.assertEquals((Object)SNAPSHOT, (Object)DISK_CONFIGURATION.sourceSnapshot());
        Assert.assertEquals((Object)SNAPSHOT_ID, (Object)DISK_CONFIGURATION.sourceSnapshotId());
        Assert.assertEquals((Object)DiskConfiguration.Type.SNAPSHOT, (Object)DISK_CONFIGURATION.type());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()) instanceof SnapshotDiskConfiguration));
        this.compareSnapshotDiskConfiguration(DISK_CONFIGURATION, (SnapshotDiskConfiguration)DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()));
    }

    @Test
    public void testOf() {
        SnapshotDiskConfiguration configuration = SnapshotDiskConfiguration.of((SnapshotId)SNAPSHOT);
        Assert.assertNull((Object)configuration.diskType());
        Assert.assertNull((Object)configuration.sizeGb());
        Assert.assertNull((Object)configuration.sourceSnapshotId());
        Assert.assertEquals((Object)SNAPSHOT, (Object)configuration.sourceSnapshot());
        Assert.assertEquals((Object)DiskConfiguration.Type.SNAPSHOT, (Object)configuration.type());
    }

    @Test
    public void testSetProjectId() {
        SnapshotDiskConfiguration configuration = ((SnapshotDiskConfiguration.Builder)DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)DISK_TYPE.zone(), (String)DISK_TYPE.type()))).sourceSnapshot(SnapshotId.of((String)SNAPSHOT.snapshot())).build();
        this.compareSnapshotDiskConfiguration(DISK_CONFIGURATION, configuration.setProjectId("project"));
    }

    private void compareSnapshotDiskConfiguration(SnapshotDiskConfiguration expected, SnapshotDiskConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.diskType(), (Object)value.diskType());
        Assert.assertEquals((Object)expected.sizeGb(), (Object)value.sizeGb());
        Assert.assertEquals((Object)expected.sourceSnapshot(), (Object)value.sourceSnapshot());
        Assert.assertEquals((Object)expected.sourceSnapshotId(), (Object)value.sourceSnapshotId());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

