/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.SnapshotId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SnapshotIdTest {
    private static final String PROJECT = "project";
    private static final String NAME = "snapshot";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        SnapshotId snapshotId = SnapshotId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)snapshotId.project());
        Assert.assertEquals((Object)NAME, (Object)snapshotId.snapshot());
        Assert.assertEquals((Object)URL, (Object)snapshotId.selfLink());
        snapshotId = SnapshotId.of((String)NAME);
        Assert.assertNull((Object)snapshotId.project());
        Assert.assertEquals((Object)NAME, (Object)snapshotId.snapshot());
    }

    @Test
    public void testToAndFromUrl() {
        SnapshotId snapshotId = SnapshotId.of((String)PROJECT, (String)NAME);
        this.compareSnapshotId(snapshotId, SnapshotId.fromUrl((String)snapshotId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid snapshot URL");
        SnapshotId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        SnapshotId snapshotId = SnapshotId.of((String)PROJECT, (String)NAME);
        Assert.assertSame((Object)snapshotId, (Object)snapshotId.setProjectId(PROJECT));
        this.compareSnapshotId(snapshotId, SnapshotId.of((String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)SnapshotId.matchesUrl((String)SnapshotId.of((String)PROJECT, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)SnapshotId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareSnapshotId(SnapshotId expected, SnapshotId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.snapshot(), (Object)expected.snapshot());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

