/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Snapshot;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotInfoTest {
    private static final String GENERATED_ID = "42";
    private static final DiskId SOURCE_DISK = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final SnapshotId SNAPSHOT_ID = SnapshotId.of((String)"project", (String)"snapshot");
    private static final SnapshotInfo.Status STATUS = SnapshotInfo.Status.CREATING;
    private static final Long DISK_SIZE_GB = 42L;
    private static final String SOURCE_DISK_ID = "diskId";
    private static final Long STORAGE_BYTES = 24L;
    private static final SnapshotInfo.StorageBytesStatus STORAGE_BYTES_STATUS = SnapshotInfo.StorageBytesStatus.UP_TO_DATE;
    private static final SnapshotInfo SNAPSHOT_INFO = SnapshotInfo.builder((SnapshotId)SNAPSHOT_ID, (DiskId)SOURCE_DISK).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).sourceDiskId("diskId").storageBytes(STORAGE_BYTES).storageBytesStatus(STORAGE_BYTES_STATUS).build();

    @Test
    public void testToBuilder() {
        this.compareSnapshotInfo(SNAPSHOT_INFO, SNAPSHOT_INFO.toBuilder().build());
        SnapshotInfo snapshotInfo = SNAPSHOT_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)snapshotInfo.description());
        snapshotInfo = snapshotInfo.toBuilder().description(DESCRIPTION).build();
        this.compareSnapshotInfo(SNAPSHOT_INFO, snapshotInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        SnapshotInfo snapshotInfo = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)SOURCE_DISK);
        Assert.assertEquals((Object)snapshotInfo, (Object)snapshotInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)SNAPSHOT_INFO.generatedId());
        Assert.assertEquals((Object)SNAPSHOT_ID, (Object)SNAPSHOT_INFO.snapshotId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)SNAPSHOT_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)SNAPSHOT_INFO.description());
        Assert.assertEquals((Object)STATUS, (Object)SNAPSHOT_INFO.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)SNAPSHOT_INFO.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)SNAPSHOT_INFO.licenses());
        Assert.assertEquals((Object)SOURCE_DISK, (Object)SNAPSHOT_INFO.sourceDisk());
        Assert.assertEquals((Object)SOURCE_DISK_ID, (Object)SNAPSHOT_INFO.sourceDiskId());
        Assert.assertEquals((Object)STORAGE_BYTES, (Object)SNAPSHOT_INFO.storageBytes());
        Assert.assertEquals((Object)STORAGE_BYTES_STATUS, (Object)SNAPSHOT_INFO.storageBytesStatus());
    }

    @Test
    public void testOf() {
        SnapshotInfo snapshotInfo = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)SOURCE_DISK);
        Assert.assertNull((Object)snapshotInfo.generatedId());
        Assert.assertEquals((Object)SNAPSHOT_ID, (Object)snapshotInfo.snapshotId());
        Assert.assertNull((Object)snapshotInfo.creationTimestamp());
        Assert.assertNull((Object)snapshotInfo.description());
        Assert.assertNull((Object)snapshotInfo.status());
        Assert.assertNull((Object)snapshotInfo.diskSizeGb());
        Assert.assertNull((Object)snapshotInfo.licenses());
        Assert.assertEquals((Object)SOURCE_DISK, (Object)snapshotInfo.sourceDisk());
        Assert.assertNull((Object)snapshotInfo.sourceDiskId());
        Assert.assertNull((Object)snapshotInfo.storageBytes());
        Assert.assertNull((Object)snapshotInfo.storageBytesStatus());
    }

    @Test
    public void testToAndFromPb() {
        this.compareSnapshotInfo(SNAPSHOT_INFO, SnapshotInfo.fromPb((Snapshot)SNAPSHOT_INFO.toPb()));
        SnapshotInfo snapshotInfo = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)SOURCE_DISK);
        this.compareSnapshotInfo(snapshotInfo, SnapshotInfo.fromPb((Snapshot)snapshotInfo.toPb()));
        snapshotInfo = new SnapshotInfo.BuilderImpl().snapshotId(SNAPSHOT_ID).build();
        this.compareSnapshotInfo(snapshotInfo, SnapshotInfo.fromPb((Snapshot)snapshotInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        SnapshotInfo snapshotInfo = SNAPSHOT_INFO.toBuilder().snapshotId(SnapshotId.of((String)"snapshot")).sourceDisk(DiskId.of((String)"zone", (String)"disk")).build();
        this.compareSnapshotInfo(SNAPSHOT_INFO, snapshotInfo.setProjectId("project"));
    }

    public void compareSnapshotInfo(SnapshotInfo expected, SnapshotInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.snapshotId(), (Object)value.snapshotId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.diskSizeGb(), (Object)value.diskSizeGb());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.sourceDisk(), (Object)value.sourceDisk());
        Assert.assertEquals((Object)expected.sourceDiskId(), (Object)value.sourceDiskId());
        Assert.assertEquals((Object)expected.storageBytes(), (Object)value.storageBytes());
        Assert.assertEquals((Object)expected.storageBytesStatus(), (Object)value.storageBytesStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

