/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SnapshotTest {
    private static final String GENERATED_ID = "42";
    private static final DiskId SOURCE_DISK = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final SnapshotId SNAPSHOT_ID = SnapshotId.of((String)"project", (String)"snapshot");
    private static final SnapshotInfo.Status STATUS = SnapshotInfo.Status.CREATING;
    private static final Long DISK_SIZE_GB = 42L;
    private static final String SOURCE_DISK_ID = "diskId";
    private static final Long STORAGE_BYTES = 24L;
    private static final SnapshotInfo.StorageBytesStatus STORAGE_BYTES_STATUS = SnapshotInfo.StorageBytesStatus.UP_TO_DATE;
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Snapshot snapshot;
    private Snapshot expectedSnapshot;

    private void initializeExpectedSnapshot(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.expectedSnapshot = new Snapshot.Builder(this.serviceMockReturnsOptions, SNAPSHOT_ID, SOURCE_DISK).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).sourceDiskId(SOURCE_DISK_ID).storageBytes(STORAGE_BYTES).storageBytesStatus(STORAGE_BYTES_STATUS).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeSnapshot() {
        this.snapshot = new Snapshot.Builder(this.compute, SNAPSHOT_ID, SOURCE_DISK).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).status(STATUS).diskSizeGb(DISK_SIZE_GB).licenses(LICENSES).sourceDiskId(SOURCE_DISK_ID).storageBytes(STORAGE_BYTES).storageBytesStatus(STORAGE_BYTES_STATUS).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedSnapshot(8);
        this.compareSnapshot(this.expectedSnapshot, this.expectedSnapshot.toBuilder().build());
        Snapshot newSnapshot = this.expectedSnapshot.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newSnapshot.description());
        newSnapshot = newSnapshot.toBuilder().description(DESCRIPTION).build();
        this.compareSnapshot(this.expectedSnapshot, newSnapshot);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedSnapshot(5);
        SnapshotInfo snapshotInfo = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)SOURCE_DISK);
        Snapshot snapshot = new Snapshot(this.serviceMockReturnsOptions, new SnapshotInfo.BuilderImpl(snapshotInfo));
        this.compareSnapshot(snapshot, snapshot.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedSnapshot(2);
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.expectedSnapshot.generatedId());
        Assert.assertEquals((Object)SNAPSHOT_ID, (Object)this.expectedSnapshot.snapshotId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.expectedSnapshot.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.expectedSnapshot.description());
        Assert.assertEquals((Object)STATUS, (Object)this.expectedSnapshot.status());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)this.expectedSnapshot.diskSizeGb());
        Assert.assertEquals(LICENSES, (Object)this.expectedSnapshot.licenses());
        Assert.assertEquals((Object)SOURCE_DISK, (Object)this.expectedSnapshot.sourceDisk());
        Assert.assertEquals((Object)SOURCE_DISK_ID, (Object)this.expectedSnapshot.sourceDiskId());
        Assert.assertEquals((Object)STORAGE_BYTES, (Object)this.expectedSnapshot.storageBytes());
        Assert.assertEquals((Object)STORAGE_BYTES_STATUS, (Object)this.expectedSnapshot.storageBytesStatus());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedSnapshot.compute());
        SnapshotId otherSnapshotId = SnapshotId.of((String)"otherSnapshot");
        DiskId otherSourceDisk = DiskId.of((String)"zone", (String)"otherDisk");
        Snapshot snapshot = new Snapshot.Builder(this.serviceMockReturnsOptions, SNAPSHOT_ID, SOURCE_DISK).snapshotId(otherSnapshotId).sourceDisk(otherSourceDisk).build();
        Assert.assertNull((Object)snapshot.generatedId());
        Assert.assertEquals((Object)otherSnapshotId, (Object)snapshot.snapshotId());
        Assert.assertNull((Object)snapshot.creationTimestamp());
        Assert.assertNull((Object)snapshot.description());
        Assert.assertNull((Object)snapshot.status());
        Assert.assertNull((Object)snapshot.diskSizeGb());
        Assert.assertNull((Object)snapshot.licenses());
        Assert.assertEquals((Object)otherSourceDisk, (Object)snapshot.sourceDisk());
        Assert.assertNull((Object)snapshot.sourceDiskId());
        Assert.assertNull((Object)snapshot.storageBytes());
        Assert.assertNull((Object)snapshot.storageBytesStatus());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)snapshot.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedSnapshot(8);
        this.compareSnapshot(this.expectedSnapshot, Snapshot.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Snapshot)this.expectedSnapshot.toPb()));
        Snapshot snapshot = new Snapshot.Builder(this.serviceMockReturnsOptions, SNAPSHOT_ID, SOURCE_DISK).build();
        this.compareSnapshot(snapshot, Snapshot.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Snapshot)snapshot.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedSnapshot(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteSnapshot(SNAPSHOT_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Assert.assertSame((Object)operation, (Object)this.snapshot.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedSnapshot(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteSnapshot(SNAPSHOT_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Assert.assertNull((Object)this.snapshot.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedSnapshot(1);
        Compute.SnapshotOption[] expectedOptions = new Compute.SnapshotOption[]{Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), expectedOptions)).andReturn((Object)this.expectedSnapshot);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Assert.assertTrue((boolean)this.snapshot.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedSnapshot(1);
        Compute.SnapshotOption[] expectedOptions = new Compute.SnapshotOption[]{Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Assert.assertFalse((boolean)this.snapshot.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedSnapshot(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[0])).andReturn((Object)this.expectedSnapshot);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Snapshot updatedSnapshot = this.snapshot.reload(new Compute.SnapshotOption[0]);
        this.compareSnapshot(this.expectedSnapshot, updatedSnapshot);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedSnapshot(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Assert.assertNull((Object)this.snapshot.reload(new Compute.SnapshotOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedSnapshot(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[]{Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[0])})).andReturn((Object)this.expectedSnapshot);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSnapshot();
        Snapshot updatedSnapshot = this.snapshot.reload(new Compute.SnapshotOption[]{Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[0])});
        this.compareSnapshot(this.expectedSnapshot, updatedSnapshot);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    public void compareSnapshot(Snapshot expected, Snapshot value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.snapshotId(), (Object)value.snapshotId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.diskSizeGb(), (Object)value.diskSizeGb());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((Object)expected.sourceDisk(), (Object)value.sourceDisk());
        Assert.assertEquals((Object)expected.sourceDiskId(), (Object)value.sourceDiskId());
        Assert.assertEquals((Object)expected.storageBytes(), (Object)value.storageBytes());
        Assert.assertEquals((Object)expected.storageBytesStatus(), (Object)value.storageBytesStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

