/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.StandardDiskConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class StandardDiskConfigurationTest {
    private static final Long SIZE = 42L;
    private static final DiskTypeId DISK_TYPE = DiskTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final StandardDiskConfiguration DISK_CONFIGURATION = ((StandardDiskConfiguration.Builder)StandardDiskConfiguration.builder().sizeGb(SIZE).diskType(DISK_TYPE)).build();

    @Test
    public void testToBuilder() {
        this.compareStandardDiskConfiguration(DISK_CONFIGURATION, DISK_CONFIGURATION.toBuilder().build());
        StandardDiskConfiguration diskConfiguration = DISK_CONFIGURATION.toBuilder().sizeGb(Long.valueOf(24L)).build();
        Assert.assertEquals((long)24L, (long)diskConfiguration.sizeGb());
        diskConfiguration = diskConfiguration.toBuilder().sizeGb(SIZE).build();
        this.compareStandardDiskConfiguration(DISK_CONFIGURATION, diskConfiguration);
    }

    @Test
    public void testToBuilderIncomplete() {
        StandardDiskConfiguration diskConfiguration = StandardDiskConfiguration.of((DiskTypeId)DISK_TYPE);
        this.compareStandardDiskConfiguration(diskConfiguration, diskConfiguration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)DISK_TYPE, (Object)DISK_CONFIGURATION.diskType());
        Assert.assertEquals((Object)SIZE, (Object)DISK_CONFIGURATION.sizeGb());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)DISK_CONFIGURATION.type());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()) instanceof StandardDiskConfiguration));
        this.compareStandardDiskConfiguration(DISK_CONFIGURATION, (StandardDiskConfiguration)DiskConfiguration.fromPb((Disk)DISK_CONFIGURATION.toPb()));
    }

    @Test
    public void testOf() {
        StandardDiskConfiguration configuration = StandardDiskConfiguration.of((DiskTypeId)DISK_TYPE);
        Assert.assertEquals((Object)DISK_TYPE, (Object)configuration.diskType());
        Assert.assertNull((Object)configuration.sizeGb());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)configuration.type());
        configuration = StandardDiskConfiguration.of((DiskTypeId)DISK_TYPE, (long)SIZE);
        Assert.assertEquals((Object)DISK_TYPE, (Object)configuration.diskType());
        Assert.assertEquals((Object)SIZE, (Object)configuration.sizeGb());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)configuration.type());
        configuration = StandardDiskConfiguration.of((long)SIZE);
        Assert.assertNull((Object)configuration.diskType());
        Assert.assertEquals((Object)SIZE, (Object)configuration.sizeGb());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)configuration.type());
    }

    @Test
    public void testSetProjectId() {
        StandardDiskConfiguration configuration = ((StandardDiskConfiguration.Builder)DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)DISK_TYPE.zone(), (String)DISK_TYPE.type()))).build();
        this.compareStandardDiskConfiguration(DISK_CONFIGURATION, configuration.setProjectId("project"));
    }

    private void compareStandardDiskConfiguration(StandardDiskConfiguration expected, StandardDiskConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.diskType(), (Object)value.diskType());
        Assert.assertEquals((Object)expected.sizeGb(), (Object)value.sizeGb());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

