/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.StandardNetworkConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class StandardNetworkConfigurationTest {
    private static final String IP_RANGE = "192.168.0.0/16";
    private static final String GATEWAY_ADDRESS = "192.168.1.1";
    private static final StandardNetworkConfiguration NETWORK_CONFIGURATION = new StandardNetworkConfiguration("192.168.0.0/16", "192.168.1.1");

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)NETWORK_CONFIGURATION.type());
        Assert.assertEquals((Object)IP_RANGE, (Object)NETWORK_CONFIGURATION.ipRange());
        Assert.assertEquals((Object)GATEWAY_ADDRESS, (Object)NETWORK_CONFIGURATION.gatewayAddress());
        StandardNetworkConfiguration networkConfiguration = new StandardNetworkConfiguration(IP_RANGE, null);
        Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)networkConfiguration.type());
        Assert.assertEquals((Object)IP_RANGE, (Object)networkConfiguration.ipRange());
        Assert.assertNull((Object)networkConfiguration.gatewayAddress());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(NetworkConfiguration.fromPb((Network)NETWORK_CONFIGURATION.toPb()) instanceof StandardNetworkConfiguration));
        this.compareNetworkConfiguration(NETWORK_CONFIGURATION, (StandardNetworkConfiguration)NetworkConfiguration.fromPb((Network)NETWORK_CONFIGURATION.toPb()));
        StandardNetworkConfiguration networkConfiguration = new StandardNetworkConfiguration(IP_RANGE, null);
        Assert.assertTrue((boolean)(NetworkConfiguration.fromPb((Network)networkConfiguration.toPb()) instanceof StandardNetworkConfiguration));
        this.compareNetworkConfiguration(networkConfiguration, (StandardNetworkConfiguration)NetworkConfiguration.fromPb((Network)networkConfiguration.toPb()));
    }

    @Test
    public void testOf() {
        StandardNetworkConfiguration configuration = StandardNetworkConfiguration.of((String)IP_RANGE);
        Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)configuration.type());
        Assert.assertEquals((Object)IP_RANGE, (Object)configuration.ipRange());
        Assert.assertNull((Object)configuration.gatewayAddress());
    }

    private void compareNetworkConfiguration(StandardNetworkConfiguration expected, StandardNetworkConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.ipRange(), (Object)value.ipRange());
        Assert.assertEquals((Object)expected.gatewayAddress(), (Object)value.gatewayAddress());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

