/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.StorageImageConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class StorageImageConfigurationTest {
    private static final String SOURCE = "source";
    private static final ImageConfiguration.SourceType SOURCE_TYPE = ImageConfiguration.SourceType.RAW;
    private static final StorageImageConfiguration.ContainerType CONTAINER_TYPE = StorageImageConfiguration.ContainerType.TAR;
    private static final Long ARCHIVE_SIZE_BYTES = 42L;
    private static final String SHA1 = "sha1";
    private static final StorageImageConfiguration CONFIGURATION = ((StorageImageConfiguration.Builder)((StorageImageConfiguration.Builder)StorageImageConfiguration.builder((String)"source").sourceType(SOURCE_TYPE)).containerType(CONTAINER_TYPE).archiveSizeBytes(ARCHIVE_SIZE_BYTES)).sha1("sha1").build();

    @Test
    public void testToBuilder() {
        this.compareRawImageConfiguration(CONFIGURATION, CONFIGURATION.toBuilder().build());
        String newSource = "newSource";
        StorageImageConfiguration configuration = CONFIGURATION.toBuilder().source(newSource).build();
        Assert.assertEquals((Object)newSource, (Object)configuration.source());
        configuration = configuration.toBuilder().source(SOURCE).build();
        this.compareRawImageConfiguration(CONFIGURATION, configuration);
    }

    @Test
    public void testToBuilderIncomplete() {
        StorageImageConfiguration configuration = StorageImageConfiguration.of((String)SOURCE);
        this.compareRawImageConfiguration(configuration, configuration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)SOURCE_TYPE, (Object)CONFIGURATION.sourceType());
        Assert.assertEquals((Object)SOURCE, (Object)CONFIGURATION.source());
        Assert.assertEquals((Object)CONTAINER_TYPE, (Object)CONFIGURATION.containerType());
        Assert.assertEquals((Object)ARCHIVE_SIZE_BYTES, (Object)CONFIGURATION.archiveSizeBytes());
        Assert.assertEquals((Object)SHA1, (Object)CONFIGURATION.sha1());
        Assert.assertEquals((Object)ImageConfiguration.Type.STORAGE, (Object)CONFIGURATION.type());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(ImageConfiguration.fromPb((Image)CONFIGURATION.toPb()) instanceof StorageImageConfiguration));
        this.compareRawImageConfiguration(CONFIGURATION, (StorageImageConfiguration)ImageConfiguration.fromPb((Image)CONFIGURATION.toPb()));
        StorageImageConfiguration configuration = StorageImageConfiguration.of((String)SOURCE);
        this.compareRawImageConfiguration(configuration, StorageImageConfiguration.fromPb((Image)configuration.toPb()));
    }

    @Test
    public void testOf() {
        StorageImageConfiguration configuration = StorageImageConfiguration.of((String)SOURCE);
        Assert.assertEquals((Object)ImageConfiguration.Type.STORAGE, (Object)configuration.type());
        Assert.assertNull((Object)configuration.sourceType());
        Assert.assertEquals((Object)SOURCE, (Object)configuration.source());
        Assert.assertNull((Object)configuration.containerType());
        Assert.assertNull((Object)configuration.archiveSizeBytes());
        Assert.assertNull((Object)configuration.sha1());
    }

    @Test
    public void testSetProjectId() {
        Assert.assertSame((Object)CONFIGURATION, (Object)CONFIGURATION.setProjectId("project"));
    }

    private void compareRawImageConfiguration(StorageImageConfiguration expected, StorageImageConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.source(), (Object)value.source());
        Assert.assertEquals((Object)expected.sourceType(), (Object)value.sourceType());
        Assert.assertEquals((Object)expected.containerType(), (Object)value.containerType());
        Assert.assertEquals((Object)expected.archiveSizeBytes(), (Object)value.archiveSizeBytes());
        Assert.assertEquals((Object)expected.sha1(), (Object)value.sha1());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

