/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.SubnetworkId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SubnetNetworkConfigurationTest {
    private static final Boolean AUTO_CREATE_SUBNETWORKS = true;
    private static final List<SubnetworkId> SUBNETWORKS = ImmutableList.of((Object)SubnetworkId.of((String)"project", (String)"region", (String)"subnetwork1"), (Object)SubnetworkId.of((String)"project", (String)"region", (String)"subnetwork2"));
    private static final SubnetNetworkConfiguration NETWORK_CONFIGURATION = new SubnetNetworkConfiguration(AUTO_CREATE_SUBNETWORKS.booleanValue(), SUBNETWORKS);

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)AUTO_CREATE_SUBNETWORKS, (Object)NETWORK_CONFIGURATION.autoCreateSubnetworks());
        Assert.assertEquals((Object)NetworkConfiguration.Type.SUBNET, (Object)NETWORK_CONFIGURATION.type());
        Assert.assertEquals(SUBNETWORKS, (Object)NETWORK_CONFIGURATION.subnetworks());
        Assert.assertEquals((Object)NetworkConfiguration.Type.SUBNET, (Object)NETWORK_CONFIGURATION.type());
        SubnetNetworkConfiguration networkConfiguration = new SubnetNetworkConfiguration(AUTO_CREATE_SUBNETWORKS.booleanValue(), null);
        Assert.assertEquals((Object)NetworkConfiguration.Type.SUBNET, (Object)networkConfiguration.type());
        Assert.assertEquals((Object)AUTO_CREATE_SUBNETWORKS, (Object)networkConfiguration.autoCreateSubnetworks());
        Assert.assertNull((Object)networkConfiguration.subnetworks());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(NetworkConfiguration.fromPb((Network)NETWORK_CONFIGURATION.toPb()) instanceof SubnetNetworkConfiguration));
        this.compareNetworkConfiguration(NETWORK_CONFIGURATION, (SubnetNetworkConfiguration)NetworkConfiguration.fromPb((Network)NETWORK_CONFIGURATION.toPb()));
        SubnetNetworkConfiguration networkConfiguration = new SubnetNetworkConfiguration(AUTO_CREATE_SUBNETWORKS.booleanValue(), null);
        Assert.assertTrue((boolean)(NetworkConfiguration.fromPb((Network)networkConfiguration.toPb()) instanceof SubnetNetworkConfiguration));
        this.compareNetworkConfiguration(networkConfiguration, (SubnetNetworkConfiguration)NetworkConfiguration.fromPb((Network)networkConfiguration.toPb()));
    }

    @Test
    public void testOf() {
        SubnetNetworkConfiguration configuration = SubnetNetworkConfiguration.of((boolean)AUTO_CREATE_SUBNETWORKS);
        Assert.assertEquals((Object)AUTO_CREATE_SUBNETWORKS, (Object)configuration.autoCreateSubnetworks());
        Assert.assertNull((Object)configuration.subnetworks());
        Assert.assertEquals((Object)NetworkConfiguration.Type.SUBNET, (Object)configuration.type());
    }

    private void compareNetworkConfiguration(SubnetNetworkConfiguration expected, SubnetNetworkConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.autoCreateSubnetworks(), (Object)value.autoCreateSubnetworks());
        Assert.assertEquals((Object)expected.subnetworks(), (Object)value.subnetworks());
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

