/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.SubnetworkId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SubnetworkIdTest {
    private static final String PROJECT = "project";
    private static final String REGION = "region";
    private static final String NAME = "subnet";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/regions/region/subnetworks/subnet";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        SubnetworkId subnetworkId = SubnetworkId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)subnetworkId.project());
        Assert.assertEquals((Object)REGION, (Object)subnetworkId.region());
        Assert.assertEquals((Object)NAME, (Object)subnetworkId.subnetwork());
        Assert.assertEquals((Object)URL, (Object)subnetworkId.selfLink());
        subnetworkId = SubnetworkId.of((String)REGION, (String)NAME);
        Assert.assertNull((Object)subnetworkId.project());
        Assert.assertEquals((Object)REGION, (Object)subnetworkId.region());
        Assert.assertEquals((Object)NAME, (Object)subnetworkId.subnetwork());
        subnetworkId = SubnetworkId.of((RegionId)RegionId.of((String)PROJECT, (String)REGION), (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)subnetworkId.project());
        Assert.assertEquals((Object)REGION, (Object)subnetworkId.region());
        Assert.assertEquals((Object)NAME, (Object)subnetworkId.subnetwork());
    }

    @Test
    public void testToAndFromUrl() {
        SubnetworkId subnetworkId = SubnetworkId.of((String)PROJECT, (String)REGION, (String)NAME);
        this.compareSubnetworkId(subnetworkId, SubnetworkId.fromUrl((String)subnetworkId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid subnetwork URL");
        SubnetworkId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        SubnetworkId subnetworkId = SubnetworkId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertSame((Object)subnetworkId, (Object)subnetworkId.setProjectId(PROJECT));
        this.compareSubnetworkId(subnetworkId, SubnetworkId.of((String)REGION, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)SubnetworkId.matchesUrl((String)SubnetworkId.of((String)PROJECT, (String)REGION, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)SubnetworkId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareSubnetworkId(SubnetworkId expected, SubnetworkId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.region(), (Object)expected.region());
        Assert.assertEquals((Object)expected.subnetwork(), (Object)expected.subnetwork());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

