/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Subnetwork;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import org.junit.Assert;
import org.junit.Test;

public class SubnetworkInfoTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final SubnetworkId SUBNETWORK_ID = SubnetworkId.of((String)"project", (String)"region", (String)"subnetwork");
    private static final String GATEWAY_ADDRESS = "192.168.1.1";
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final String IP_RANGE = "192.168.0.0/16";
    private static final SubnetworkInfo SUBNETWORK_INFO = SubnetworkInfo.builder((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)"192.168.0.0/16").generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").gatewayAddress("192.168.1.1").build();

    @Test
    public void testToBuilder() {
        this.compareSubnetworkInfo(SUBNETWORK_INFO, SUBNETWORK_INFO.toBuilder().build());
        SubnetworkInfo subnetworkInfo = SUBNETWORK_INFO.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)subnetworkInfo.description());
        subnetworkInfo = subnetworkInfo.toBuilder().description(DESCRIPTION).build();
        this.compareSubnetworkInfo(SUBNETWORK_INFO, subnetworkInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        SubnetworkInfo subnetworkInfo = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)IP_RANGE);
        Assert.assertEquals((Object)subnetworkInfo, (Object)subnetworkInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)GENERATED_ID, (Object)SUBNETWORK_INFO.generatedId());
        Assert.assertEquals((Object)SUBNETWORK_ID, (Object)SUBNETWORK_INFO.subnetworkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)SUBNETWORK_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)SUBNETWORK_INFO.description());
        Assert.assertEquals((Object)GATEWAY_ADDRESS, (Object)SUBNETWORK_INFO.gatewayAddress());
        Assert.assertEquals((Object)NETWORK_ID, (Object)SUBNETWORK_INFO.network());
        Assert.assertEquals((Object)IP_RANGE, (Object)SUBNETWORK_INFO.ipRange());
    }

    @Test
    public void testOf() {
        SubnetworkInfo subnetworkInfo = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)IP_RANGE);
        Assert.assertNull((Object)subnetworkInfo.generatedId());
        Assert.assertEquals((Object)SUBNETWORK_ID, (Object)subnetworkInfo.subnetworkId());
        Assert.assertNull((Object)subnetworkInfo.creationTimestamp());
        Assert.assertNull((Object)subnetworkInfo.description());
        Assert.assertNull((Object)subnetworkInfo.gatewayAddress());
        Assert.assertEquals((Object)NETWORK_ID, (Object)subnetworkInfo.network());
        Assert.assertEquals((Object)IP_RANGE, (Object)subnetworkInfo.ipRange());
    }

    @Test
    public void testToAndFromPb() {
        this.compareSubnetworkInfo(SUBNETWORK_INFO, SubnetworkInfo.fromPb((Subnetwork)SUBNETWORK_INFO.toPb()));
        SubnetworkInfo subnetworkInfo = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)IP_RANGE);
        this.compareSubnetworkInfo(subnetworkInfo, SubnetworkInfo.fromPb((Subnetwork)subnetworkInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        SubnetworkInfo subnetworkInfo = SUBNETWORK_INFO.toBuilder().subnetworkId(SubnetworkId.of((String)"region", (String)"subnetwork")).network(NetworkId.of((String)"network")).build();
        this.compareSubnetworkInfo(SUBNETWORK_INFO, subnetworkInfo.setProjectId("project"));
    }

    public void compareSubnetworkInfo(SubnetworkInfo expected, SubnetworkInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.subnetworkId(), (Object)value.subnetworkId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.gatewayAddress(), (Object)value.gatewayAddress());
        Assert.assertEquals((Object)expected.network(), (Object)value.network());
        Assert.assertEquals((Object)expected.ipRange(), (Object)value.ipRange());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

