/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SubnetworkTest {
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final SubnetworkId SUBNETWORK_ID = SubnetworkId.of((String)"project", (String)"region", (String)"network");
    private static final String GATEWAY_ADDRESS = "192.168.1.1";
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final String IP_RANGE = "192.168.0.0/16";
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Subnetwork subnetwork;
    private Subnetwork expectedSubnetwork;

    private void initializeExpectedSubnetwork(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.expectedSubnetwork = new Subnetwork.Builder(this.serviceMockReturnsOptions, SUBNETWORK_ID, NETWORK_ID, IP_RANGE).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).gatewayAddress(GATEWAY_ADDRESS).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeSubnetwork() {
        this.subnetwork = new Subnetwork.Builder(this.compute, SUBNETWORK_ID, NETWORK_ID, IP_RANGE).generatedId(GENERATED_ID).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).gatewayAddress(GATEWAY_ADDRESS).build();
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedSubnetwork(8);
        this.compareSubnetwork(this.expectedSubnetwork, this.expectedSubnetwork.toBuilder().build());
        Subnetwork newSubnetwork = this.expectedSubnetwork.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newSubnetwork.description());
        newSubnetwork = newSubnetwork.toBuilder().description(DESCRIPTION).build();
        this.compareSubnetwork(this.expectedSubnetwork, newSubnetwork);
    }

    @Test
    public void testToBuilderIncomplete() {
        this.initializeExpectedSubnetwork(5);
        SubnetworkInfo subnetworkInfo = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)IP_RANGE);
        Subnetwork subnetwork = new Subnetwork(this.serviceMockReturnsOptions, new SubnetworkInfo.BuilderImpl(subnetworkInfo));
        this.compareSubnetwork(subnetwork, subnetwork.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedSubnetwork(1);
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.expectedSubnetwork.generatedId());
        Assert.assertEquals((Object)SUBNETWORK_ID, (Object)this.expectedSubnetwork.subnetworkId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.expectedSubnetwork.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.expectedSubnetwork.description());
        Assert.assertEquals((Object)GATEWAY_ADDRESS, (Object)this.expectedSubnetwork.gatewayAddress());
        Assert.assertEquals((Object)NETWORK_ID, (Object)this.expectedSubnetwork.network());
        Assert.assertEquals((Object)IP_RANGE, (Object)this.expectedSubnetwork.ipRange());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.expectedSubnetwork.compute());
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedSubnetwork(8);
        this.compareSubnetwork(this.expectedSubnetwork, Subnetwork.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Subnetwork)this.expectedSubnetwork.toPb()));
        Subnetwork subnetwork = new Subnetwork.Builder(this.serviceMockReturnsOptions, SUBNETWORK_ID, NETWORK_ID, IP_RANGE).build();
        this.compareSubnetwork(subnetwork, Subnetwork.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Subnetwork)subnetwork.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedSubnetwork(2);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteSubnetwork(SUBNETWORK_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Assert.assertSame((Object)operation, (Object)this.subnetwork.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedSubnetwork(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteSubnetwork(SUBNETWORK_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Assert.assertNull((Object)this.subnetwork.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedSubnetwork(1);
        Compute.SubnetworkOption[] expectedOptions = new Compute.SubnetworkOption[]{Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSubnetwork(SUBNETWORK_ID, expectedOptions)).andReturn((Object)this.expectedSubnetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Assert.assertTrue((boolean)this.subnetwork.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedSubnetwork(1);
        Compute.SubnetworkOption[] expectedOptions = new Compute.SubnetworkOption[]{Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSubnetwork(SUBNETWORK_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Assert.assertFalse((boolean)this.subnetwork.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedSubnetwork(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[0])).andReturn((Object)this.expectedSubnetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Subnetwork updatedSubnetwork = this.subnetwork.reload(new Compute.SubnetworkOption[0]);
        this.compareSubnetwork(this.expectedSubnetwork, updatedSubnetwork);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedSubnetwork(1);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Assert.assertNull((Object)this.subnetwork.reload(new Compute.SubnetworkOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedSubnetwork(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[]{Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[0])})).andReturn((Object)this.expectedSubnetwork);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeSubnetwork();
        Subnetwork updatedSubnetwork = this.subnetwork.reload(new Compute.SubnetworkOption[]{Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[0])});
        this.compareSubnetwork(this.expectedSubnetwork, updatedSubnetwork);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    public void compareSubnetwork(Subnetwork expected, Subnetwork value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.subnetworkId(), (Object)value.subnetworkId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.gatewayAddress(), (Object)value.gatewayAddress());
        Assert.assertEquals((Object)expected.network(), (Object)value.network());
        Assert.assertEquals((Object)expected.ipRange(), (Object)value.ipRange());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

