/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Tags;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class TagsTest {
    private static final Tags TAGS = Tags.of((String[])new String[]{"tag1", "tag2"});

    @Test
    public void testToBuilder() {
        Tags tags = TAGS.toBuilder().values(new String[]{"tag1"}).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"tag1"), (Object)tags.values());
        this.compareTags(TAGS, tags.toBuilder().values(new String[]{"tag1", "tag2"}).build());
    }

    @Test
    public void testBuilder() {
        Tags tags = Tags.builder((String[])new String[0]).values((Iterable)ImmutableList.of((Object)"tag1", (Object)"tag2")).build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"tag1", (Object)"tag2"), (Object)tags.values());
        Assert.assertNull((Object)tags.fingerprint());
        tags = Tags.builder((String[])new String[0]).add("tag1").add("tag2").build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"tag1", (Object)"tag2"), (Object)tags.values());
        Assert.assertNull((Object)tags.fingerprint());
        tags = Tags.builder((String[])new String[0]).add("tag1").add("tag2").fingerprint("fingerprint").build();
        Assert.assertEquals((Object)ImmutableList.of((Object)"tag1", (Object)"tag2"), (Object)tags.values());
        Assert.assertEquals((Object)"fingerprint", (Object)tags.fingerprint());
    }

    @Test
    public void testOf() {
        this.compareTags(TAGS, Tags.of((String[])new String[]{"tag1", "tag2"}));
        this.compareTags(TAGS, Tags.of((Iterable)ImmutableList.of((Object)"tag1", (Object)"tag2")));
    }

    @Test
    public void testToAndFromPb() {
        this.compareTags(TAGS, Tags.fromPb((com.google.api.services.compute.model.Tags)TAGS.toPb()));
        Tags tags = Tags.builder((String[])new String[0]).add("tag1").add("tag2").fingerprint("fingerprint").build();
        this.compareTags(tags, Tags.fromPb((com.google.api.services.compute.model.Tags)tags.toPb()));
    }

    public void compareTags(Tags expected, Tags value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.fingerprint(), (Object)value.fingerprint());
        Assert.assertEquals((Object)expected.values(), (Object)value.values());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

