/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ZoneId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZoneIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        ZoneId zoneId = ZoneId.of((String)PROJECT, (String)ZONE);
        Assert.assertEquals((Object)PROJECT, (Object)zoneId.project());
        Assert.assertEquals((Object)ZONE, (Object)zoneId.zone());
        Assert.assertEquals((Object)URL, (Object)zoneId.selfLink());
        zoneId = ZoneId.of((String)ZONE);
        Assert.assertNull((Object)zoneId.project());
        Assert.assertEquals((Object)ZONE, (Object)zoneId.zone());
    }

    @Test
    public void testToAndFromUrl() {
        ZoneId zoneId = ZoneId.of((String)PROJECT, (String)ZONE);
        this.compareZoneId(zoneId, ZoneId.fromUrl((String)zoneId.selfLink()));
    }

    @Test
    public void testSetProjectId() {
        ZoneId zoneId = ZoneId.of((String)PROJECT, (String)ZONE);
        Assert.assertSame((Object)zoneId, (Object)zoneId.setProjectId(PROJECT));
        this.compareZoneId(zoneId, ZoneId.of((String)ZONE).setProjectId(PROJECT));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid zone URL");
        ZoneId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)ZoneId.matchesUrl((String)ZoneId.of((String)PROJECT, (String)ZONE).selfLink()));
        Assert.assertFalse((boolean)ZoneId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareZoneId(ZoneId expected, ZoneId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

