/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.ZoneId;
import org.junit.Assert;
import org.junit.Test;

public class ZoneTest {
    private static final ZoneId ZONE_ID = ZoneId.of((String)"project", (String)"zone");
    private static final RegionId REGION_ID = RegionId.of((String)"project", (String)"region");
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final Zone.Status STATUS = Zone.Status.DOWN;
    private static final DeprecationStatus<ZoneId> DEPRECATION_STATUS = DeprecationStatus.of((DeprecationStatus.Status)DeprecationStatus.Status.DELETED, (ResourceId)ZONE_ID);
    private static final Zone ZONE = Zone.builder().zoneId(ZONE_ID).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(STATUS).deprecationStatus(DEPRECATION_STATUS).region(REGION_ID).build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)REGION_ID, (Object)ZONE.region());
        Assert.assertEquals((Object)GENERATED_ID, (Object)ZONE.generatedId());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)ZONE.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)ZONE.description());
        Assert.assertEquals((Object)STATUS, (Object)ZONE.status());
        Assert.assertEquals((Object)REGION_ID, (Object)ZONE.region());
        Assert.assertEquals(DEPRECATION_STATUS, (Object)ZONE.deprecationStatus());
    }

    @Test
    public void testToAndFromPb() {
        com.google.api.services.compute.model.Zone zonePb = ZONE.toPb();
        Assert.assertEquals((Object)REGION_ID.selfLink(), (Object)zonePb.getRegion());
        Zone zone = Zone.fromPb((com.google.api.services.compute.model.Zone)zonePb);
        this.compareZones(ZONE, zone);
        Assert.assertEquals((Object)ZONE_ID.project(), (Object)zone.zoneId().project());
        Assert.assertEquals((Object)ZONE_ID.zone(), (Object)zone.zoneId().zone());
        zone = Zone.builder().zoneId(ZONE_ID).build();
        this.compareZones(zone, Zone.fromPb((com.google.api.services.compute.model.Zone)zone.toPb()));
    }

    private void compareZones(Zone expected, Zone value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.zoneId(), (Object)value.zoneId());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((Object)expected.region(), (Object)value.region());
        Assert.assertEquals((Object)expected.deprecationStatus(), (Object)value.deprecationStatus());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

