/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.it;

import com.google.cloud.Page;
import com.google.cloud.WaitForOption;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageDiskConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotDiskConfiguration;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.StorageImageConfiguration;
import com.google.cloud.compute.SubnetNetworkConfiguration;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.ZoneOperationId;
import com.google.cloud.compute.testing.RemoteComputeHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ITComputeTest {
    private static final String REGION = "us-central1";
    private static final String ZONE = "us-central1-a";
    private static final String DISK_TYPE = "local-ssd";
    private static final String MACHINE_TYPE = "f1-micro";
    private static final LicenseId LICENSE_ID = LicenseId.of((String)"ubuntu-os-cloud", (String)"ubuntu-1404-trusty");
    private static final String BASE_RESOURCE_NAME = RemoteComputeHelper.baseResourceName();
    private static final ImageId IMAGE_ID = ImageId.of((String)"debian-cloud", (String)"debian-8-jessie-v20160219");
    private static final String IMAGE_PROJECT = "debian-cloud";
    private static Compute compute;
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)300L);

    @BeforeClass
    public static void beforeClass() {
        RemoteComputeHelper computeHelper = RemoteComputeHelper.create();
        compute = (Compute)computeHelper.options().service();
    }

    @Test
    public void testGetDiskType() {
        DiskType diskType = compute.getDiskType(ZONE, DISK_TYPE, new Compute.DiskTypeOption[0]);
        Assert.assertEquals((Object)ZONE, (Object)diskType.diskTypeId().zone());
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType.diskTypeId().type());
        Assert.assertNotNull((Object)diskType.creationTimestamp());
        Assert.assertNotNull((Object)diskType.description());
        Assert.assertNotNull((Object)diskType.validDiskSize());
        Assert.assertNotNull((Object)diskType.defaultDiskSizeGb());
    }

    @Test
    public void testGetDiskTypeWithSelectedFields() {
        DiskType diskType = compute.getDiskType(ZONE, DISK_TYPE, new Compute.DiskTypeOption[]{Compute.DiskTypeOption.fields((Compute.DiskTypeField[])new Compute.DiskTypeField[]{Compute.DiskTypeField.CREATION_TIMESTAMP})});
        Assert.assertEquals((Object)ZONE, (Object)diskType.diskTypeId().zone());
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType.diskTypeId().type());
        Assert.assertNotNull((Object)diskType.creationTimestamp());
        Assert.assertNull((Object)diskType.description());
        Assert.assertNull((Object)diskType.validDiskSize());
        Assert.assertNull((Object)diskType.defaultDiskSizeGb());
    }

    @Test
    public void testListDiskTypes() {
        Page diskPage = compute.listDiskTypes(ZONE, new Compute.DiskTypeListOption[0]);
        Iterator diskTypeIterator = diskPage.iterateAll();
        Assert.assertTrue((boolean)diskTypeIterator.hasNext());
        while (diskTypeIterator.hasNext()) {
            DiskType diskType = (DiskType)diskTypeIterator.next();
            Assert.assertNotNull((Object)diskType.diskTypeId());
            Assert.assertEquals((Object)ZONE, (Object)diskType.diskTypeId().zone());
            Assert.assertNotNull((Object)diskType.creationTimestamp());
            Assert.assertNotNull((Object)diskType.description());
            Assert.assertNotNull((Object)diskType.validDiskSize());
            Assert.assertNotNull((Object)diskType.defaultDiskSizeGb());
        }
    }

    @Test
    public void testListDiskTypesWithSelectedFields() {
        Page diskPage = compute.listDiskTypes(ZONE, new Compute.DiskTypeListOption[]{Compute.DiskTypeListOption.fields((Compute.DiskTypeField[])new Compute.DiskTypeField[]{Compute.DiskTypeField.CREATION_TIMESTAMP})});
        Iterator diskTypeIterator = diskPage.iterateAll();
        Assert.assertTrue((boolean)diskTypeIterator.hasNext());
        while (diskTypeIterator.hasNext()) {
            DiskType diskType = (DiskType)diskTypeIterator.next();
            Assert.assertNull((Object)diskType.generatedId());
            Assert.assertNotNull((Object)diskType.diskTypeId());
            Assert.assertEquals((Object)ZONE, (Object)diskType.diskTypeId().zone());
            Assert.assertNotNull((Object)diskType.creationTimestamp());
            Assert.assertNull((Object)diskType.description());
            Assert.assertNull((Object)diskType.validDiskSize());
            Assert.assertNull((Object)diskType.defaultDiskSizeGb());
        }
    }

    @Test
    public void testListDiskTypesWithFilter() {
        Page diskPage = compute.listDiskTypes(ZONE, new Compute.DiskTypeListOption[]{Compute.DiskTypeListOption.filter((Compute.DiskTypeFilter)Compute.DiskTypeFilter.equals((Compute.DiskTypeField)Compute.DiskTypeField.DEFAULT_DISK_SIZE_GB, (long)375L))});
        Iterator diskTypeIterator = diskPage.iterateAll();
        Assert.assertTrue((boolean)diskTypeIterator.hasNext());
        while (diskTypeIterator.hasNext()) {
            DiskType diskType = (DiskType)diskTypeIterator.next();
            Assert.assertNotNull((Object)diskType.diskTypeId());
            Assert.assertEquals((Object)ZONE, (Object)diskType.diskTypeId().zone());
            Assert.assertNotNull((Object)diskType.creationTimestamp());
            Assert.assertNotNull((Object)diskType.description());
            Assert.assertNotNull((Object)diskType.validDiskSize());
            Assert.assertEquals((long)375L, (long)diskType.defaultDiskSizeGb());
        }
    }

    @Test
    public void testAggregatedListDiskTypes() {
        Page diskPage = compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[0]);
        Iterator diskTypeIterator = diskPage.iterateAll();
        Assert.assertTrue((boolean)diskTypeIterator.hasNext());
        while (diskTypeIterator.hasNext()) {
            DiskType diskType = (DiskType)diskTypeIterator.next();
            Assert.assertNotNull((Object)diskType.diskTypeId());
            Assert.assertNotNull((Object)diskType.creationTimestamp());
            Assert.assertNotNull((Object)diskType.description());
            Assert.assertNotNull((Object)diskType.validDiskSize());
            Assert.assertNotNull((Object)diskType.defaultDiskSizeGb());
        }
    }

    @Test
    public void testAggregatedListDiskTypesWithFilter() {
        Page diskPage = compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[]{Compute.DiskTypeAggregatedListOption.filter((Compute.DiskTypeFilter)Compute.DiskTypeFilter.notEquals((Compute.DiskTypeField)Compute.DiskTypeField.DEFAULT_DISK_SIZE_GB, (long)375L))});
        Iterator diskTypeIterator = diskPage.iterateAll();
        Assert.assertTrue((boolean)diskTypeIterator.hasNext());
        while (diskTypeIterator.hasNext()) {
            DiskType diskType = (DiskType)diskTypeIterator.next();
            Assert.assertNotNull((Object)diskType.diskTypeId());
            Assert.assertNotNull((Object)diskType.creationTimestamp());
            Assert.assertNotNull((Object)diskType.description());
            Assert.assertNotNull((Object)diskType.validDiskSize());
            Assert.assertNotEquals((long)375L, (long)diskType.defaultDiskSizeGb());
        }
    }

    @Test
    public void testGetMachineType() {
        MachineType machineType = compute.getMachineType(ZONE, MACHINE_TYPE, new Compute.MachineTypeOption[0]);
        Assert.assertEquals((Object)ZONE, (Object)machineType.machineTypeId().zone());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)machineType.machineTypeId().type());
        Assert.assertNotNull((Object)machineType.generatedId());
        Assert.assertNotNull((Object)machineType.creationTimestamp());
        Assert.assertNotNull((Object)machineType.description());
        Assert.assertNotNull((Object)machineType.cpus());
        Assert.assertNotNull((Object)machineType.memoryMb());
        Assert.assertNotNull((Object)machineType.maximumPersistentDisks());
        Assert.assertNotNull((Object)machineType.maximumPersistentDisksSizeGb());
    }

    @Test
    public void testGetMachineTypeWithSelectedFields() {
        MachineType machineType = compute.getMachineType(ZONE, MACHINE_TYPE, new Compute.MachineTypeOption[]{Compute.MachineTypeOption.fields((Compute.MachineTypeField[])new Compute.MachineTypeField[]{Compute.MachineTypeField.ID})});
        Assert.assertEquals((Object)ZONE, (Object)machineType.machineTypeId().zone());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)machineType.machineTypeId().type());
        Assert.assertNotNull((Object)machineType.generatedId());
        Assert.assertNull((Object)machineType.creationTimestamp());
        Assert.assertNull((Object)machineType.description());
        Assert.assertNull((Object)machineType.cpus());
        Assert.assertNull((Object)machineType.memoryMb());
        Assert.assertNull((Object)machineType.maximumPersistentDisks());
        Assert.assertNull((Object)machineType.maximumPersistentDisksSizeGb());
    }

    @Test
    public void testListMachineTypes() {
        Page machinePage = compute.listMachineTypes(ZONE, new Compute.MachineTypeListOption[0]);
        Iterator machineTypeIterator = machinePage.iterateAll();
        Assert.assertTrue((boolean)machineTypeIterator.hasNext());
        while (machineTypeIterator.hasNext()) {
            MachineType machineType = (MachineType)machineTypeIterator.next();
            Assert.assertNotNull((Object)machineType.machineTypeId());
            Assert.assertEquals((Object)ZONE, (Object)machineType.machineTypeId().zone());
            Assert.assertNotNull((Object)machineType.generatedId());
            Assert.assertNotNull((Object)machineType.creationTimestamp());
            Assert.assertNotNull((Object)machineType.description());
            Assert.assertNotNull((Object)machineType.cpus());
            Assert.assertNotNull((Object)machineType.memoryMb());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisks());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisksSizeGb());
        }
    }

    @Test
    public void testListMachineTypesWithSelectedFields() {
        Page machinePage = compute.listMachineTypes(ZONE, new Compute.MachineTypeListOption[]{Compute.MachineTypeListOption.fields((Compute.MachineTypeField[])new Compute.MachineTypeField[]{Compute.MachineTypeField.CREATION_TIMESTAMP})});
        Iterator machineTypeIterator = machinePage.iterateAll();
        Assert.assertTrue((boolean)machineTypeIterator.hasNext());
        while (machineTypeIterator.hasNext()) {
            MachineType machineType = (MachineType)machineTypeIterator.next();
            Assert.assertNotNull((Object)machineType.machineTypeId());
            Assert.assertEquals((Object)ZONE, (Object)machineType.machineTypeId().zone());
            Assert.assertNull((Object)machineType.generatedId());
            Assert.assertNotNull((Object)machineType.creationTimestamp());
            Assert.assertNull((Object)machineType.description());
            Assert.assertNull((Object)machineType.cpus());
            Assert.assertNull((Object)machineType.memoryMb());
            Assert.assertNull((Object)machineType.maximumPersistentDisks());
            Assert.assertNull((Object)machineType.maximumPersistentDisksSizeGb());
        }
    }

    @Test
    public void testListMachineTypesWithFilter() {
        Page machinePage = compute.listMachineTypes(ZONE, new Compute.MachineTypeListOption[]{Compute.MachineTypeListOption.filter((Compute.MachineTypeFilter)Compute.MachineTypeFilter.equals((Compute.MachineTypeField)Compute.MachineTypeField.GUEST_CPUS, (long)2L))});
        Iterator machineTypeIterator = machinePage.iterateAll();
        Assert.assertTrue((boolean)machineTypeIterator.hasNext());
        while (machineTypeIterator.hasNext()) {
            MachineType machineType = (MachineType)machineTypeIterator.next();
            Assert.assertNotNull((Object)machineType.machineTypeId());
            Assert.assertEquals((Object)ZONE, (Object)machineType.machineTypeId().zone());
            Assert.assertNotNull((Object)machineType.generatedId());
            Assert.assertNotNull((Object)machineType.creationTimestamp());
            Assert.assertNotNull((Object)machineType.description());
            Assert.assertNotNull((Object)machineType.cpus());
            Assert.assertEquals((long)2L, (long)machineType.cpus().intValue());
            Assert.assertNotNull((Object)machineType.memoryMb());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisks());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisksSizeGb());
        }
    }

    @Test
    public void testAggregatedListMachineTypes() {
        Page machinePage = compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[0]);
        Iterator machineTypeIterator = machinePage.iterateAll();
        Assert.assertTrue((boolean)machineTypeIterator.hasNext());
        while (machineTypeIterator.hasNext()) {
            MachineType machineType = (MachineType)machineTypeIterator.next();
            Assert.assertNotNull((Object)machineType.machineTypeId());
            Assert.assertNotNull((Object)machineType.generatedId());
            Assert.assertNotNull((Object)machineType.creationTimestamp());
            Assert.assertNotNull((Object)machineType.description());
            Assert.assertNotNull((Object)machineType.cpus());
            Assert.assertNotNull((Object)machineType.memoryMb());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisks());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisksSizeGb());
        }
    }

    @Test
    public void testAggregatedListMachineTypesWithFilter() {
        Page machinePage = compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[]{Compute.MachineTypeAggregatedListOption.filter((Compute.MachineTypeFilter)Compute.MachineTypeFilter.notEquals((Compute.MachineTypeField)Compute.MachineTypeField.GUEST_CPUS, (long)2L))});
        Iterator machineTypeIterator = machinePage.iterateAll();
        Assert.assertTrue((boolean)machineTypeIterator.hasNext());
        while (machineTypeIterator.hasNext()) {
            MachineType machineType = (MachineType)machineTypeIterator.next();
            Assert.assertNotNull((Object)machineType.machineTypeId());
            Assert.assertNotNull((Object)machineType.generatedId());
            Assert.assertNotNull((Object)machineType.creationTimestamp());
            Assert.assertNotNull((Object)machineType.description());
            Assert.assertNotNull((Object)machineType.cpus());
            Assert.assertNotEquals((long)2L, (long)machineType.cpus().intValue());
            Assert.assertNotNull((Object)machineType.memoryMb());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisks());
            Assert.assertNotNull((Object)machineType.maximumPersistentDisksSizeGb());
        }
    }

    @Test
    public void testGetLicense() {
        License license = compute.getLicense(LICENSE_ID, new Compute.LicenseOption[0]);
        Assert.assertEquals((Object)LICENSE_ID, (Object)license.licenseId());
        Assert.assertNotNull((Object)license.chargesUseFee());
    }

    @Test
    public void testGetLicenseWithSelectedFields() {
        License license = compute.getLicense(LICENSE_ID, new Compute.LicenseOption[]{Compute.LicenseOption.fields((Compute.LicenseField[])new Compute.LicenseField[0])});
        Assert.assertEquals((Object)LICENSE_ID, (Object)license.licenseId());
        Assert.assertNull((Object)license.chargesUseFee());
    }

    @Test
    public void testGetRegion() {
        Region region = compute.getRegion(REGION, new Compute.RegionOption[0]);
        Assert.assertEquals((Object)REGION, (Object)region.regionId().region());
        Assert.assertNotNull((Object)region.description());
        Assert.assertNotNull((Object)region.creationTimestamp());
        Assert.assertNotNull((Object)region.generatedId());
        Assert.assertNotNull((Object)region.quotas());
        Assert.assertNotNull((Object)region.status());
        Assert.assertNotNull((Object)region.zones());
    }

    @Test
    public void testGetRegionWithSelectedFields() {
        Region region = compute.getRegion(REGION, new Compute.RegionOption[]{Compute.RegionOption.fields((Compute.RegionField[])new Compute.RegionField[]{Compute.RegionField.ID})});
        Assert.assertEquals((Object)REGION, (Object)region.regionId().region());
        Assert.assertNotNull((Object)region.generatedId());
        Assert.assertNull((Object)region.description());
        Assert.assertNull((Object)region.creationTimestamp());
        Assert.assertNull((Object)region.quotas());
        Assert.assertNull((Object)region.status());
        Assert.assertNull((Object)region.zones());
    }

    @Test
    public void testListRegions() {
        Page regionPage = compute.listRegions(new Compute.RegionListOption[0]);
        Iterator regionIterator = regionPage.iterateAll();
        while (regionIterator.hasNext()) {
            Region region = (Region)regionIterator.next();
            Assert.assertNotNull((Object)region.regionId());
            Assert.assertNotNull((Object)region.description());
            Assert.assertNotNull((Object)region.creationTimestamp());
            Assert.assertNotNull((Object)region.generatedId());
            Assert.assertNotNull((Object)region.quotas());
            Assert.assertNotNull((Object)region.status());
            Assert.assertNotNull((Object)region.zones());
        }
    }

    @Test
    public void testListRegionsWithSelectedFields() {
        Page regionPage = compute.listRegions(new Compute.RegionListOption[]{Compute.RegionListOption.fields((Compute.RegionField[])new Compute.RegionField[]{Compute.RegionField.ID})});
        Iterator regionIterator = regionPage.iterateAll();
        while (regionIterator.hasNext()) {
            Region region = (Region)regionIterator.next();
            Assert.assertNotNull((Object)region.regionId());
            Assert.assertNull((Object)region.description());
            Assert.assertNull((Object)region.creationTimestamp());
            Assert.assertNotNull((Object)region.generatedId());
            Assert.assertNull((Object)region.quotas());
            Assert.assertNull((Object)region.status());
            Assert.assertNull((Object)region.zones());
        }
    }

    @Test
    public void testListRegionsWithFilter() {
        Page regionPage = compute.listRegions(new Compute.RegionListOption[]{Compute.RegionListOption.filter((Compute.RegionFilter)Compute.RegionFilter.equals((Compute.RegionField)Compute.RegionField.NAME, (String)REGION))});
        Iterator regionIterator = regionPage.iterateAll();
        Assert.assertEquals((Object)REGION, (Object)((Region)regionIterator.next()).regionId().region());
        Assert.assertFalse((boolean)regionIterator.hasNext());
    }

    @Test
    public void testGetZone() {
        Zone zone = compute.getZone(ZONE, new Compute.ZoneOption[0]);
        Assert.assertEquals((Object)ZONE, (Object)zone.zoneId().zone());
        Assert.assertNotNull((Object)zone.generatedId());
        Assert.assertNotNull((Object)zone.creationTimestamp());
        Assert.assertNotNull((Object)zone.description());
        Assert.assertNotNull((Object)zone.status());
        Assert.assertNotNull((Object)zone.region());
    }

    @Test
    public void testGetZoneWithSelectedFields() {
        Zone zone = compute.getZone(ZONE, new Compute.ZoneOption[]{Compute.ZoneOption.fields((Compute.ZoneField[])new Compute.ZoneField[]{Compute.ZoneField.ID})});
        Assert.assertEquals((Object)ZONE, (Object)zone.zoneId().zone());
        Assert.assertNotNull((Object)zone.generatedId());
        Assert.assertNull((Object)zone.creationTimestamp());
        Assert.assertNull((Object)zone.description());
        Assert.assertNull((Object)zone.status());
        Assert.assertNull((Object)zone.region());
    }

    @Test
    public void testListZones() {
        Page zonePage = compute.listZones(new Compute.ZoneListOption[0]);
        Iterator zoneIterator = zonePage.iterateAll();
        while (zoneIterator.hasNext()) {
            Zone zone = (Zone)zoneIterator.next();
            Assert.assertNotNull((Object)zone.zoneId());
            Assert.assertNotNull((Object)zone.generatedId());
            Assert.assertNotNull((Object)zone.creationTimestamp());
            Assert.assertNotNull((Object)zone.description());
            Assert.assertNotNull((Object)zone.status());
            Assert.assertNotNull((Object)zone.region());
        }
    }

    @Test
    public void testListZonesWithSelectedFields() {
        Page zonePage = compute.listZones(new Compute.ZoneListOption[]{Compute.ZoneListOption.fields((Compute.ZoneField[])new Compute.ZoneField[]{Compute.ZoneField.CREATION_TIMESTAMP})});
        Iterator zoneIterator = zonePage.iterateAll();
        while (zoneIterator.hasNext()) {
            Zone zone = (Zone)zoneIterator.next();
            Assert.assertNotNull((Object)zone.zoneId());
            Assert.assertNull((Object)zone.generatedId());
            Assert.assertNotNull((Object)zone.creationTimestamp());
            Assert.assertNull((Object)zone.description());
            Assert.assertNull((Object)zone.status());
            Assert.assertNull((Object)zone.region());
        }
    }

    @Test
    public void testListZonesWithFilter() {
        Page zonePage = compute.listZones(new Compute.ZoneListOption[]{Compute.ZoneListOption.filter((Compute.ZoneFilter)Compute.ZoneFilter.equals((Compute.ZoneField)Compute.ZoneField.NAME, (String)ZONE))});
        Iterator zoneIterator = zonePage.iterateAll();
        Assert.assertEquals((Object)ZONE, (Object)((Zone)zoneIterator.next()).zoneId().zone());
        Assert.assertFalse((boolean)zoneIterator.hasNext());
    }

    @Test
    public void testListGlobalOperations() {
        Page operationPage = compute.listGlobalOperations(new Compute.OperationListOption[0]);
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertNotNull((Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testListGlobalOperationsWithSelectedFields() {
        Page operationPage = compute.listGlobalOperations(new Compute.OperationListOption[]{Compute.OperationListOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.ID})});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.targetLink());
            Assert.assertNull((Object)operation.targetId());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.status());
            Assert.assertNull((Object)operation.statusMessage());
            Assert.assertNull((Object)operation.user());
            Assert.assertNull((Object)operation.progress());
            Assert.assertNull((Object)operation.description());
            Assert.assertNull((Object)operation.insertTime());
            Assert.assertNull((Object)operation.startTime());
            Assert.assertNull((Object)operation.endTime());
            Assert.assertNull((Object)operation.warnings());
            Assert.assertNull((Object)operation.httpErrorMessage());
        }
    }

    @Test
    public void testListGlobalOperationsWithFilter() {
        Page operationPage = compute.listGlobalOperations(new Compute.OperationListOption[]{Compute.OperationListOption.filter((Compute.OperationFilter)Compute.OperationFilter.equals((Compute.OperationField)Compute.OperationField.STATUS, (String)"DONE"))});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertEquals((Object)Operation.Status.DONE, (Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testListRegionOperations() {
        Page operationPage = compute.listRegionOperations(REGION, new Compute.OperationListOption[0]);
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)REGION, (Object)((RegionOperationId)operation.operationId()).region());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertNotNull((Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testListRegionOperationsWithSelectedFields() {
        Page operationPage = compute.listRegionOperations(REGION, new Compute.OperationListOption[]{Compute.OperationListOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.ID})});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)REGION, (Object)((RegionOperationId)operation.operationId()).region());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.targetLink());
            Assert.assertNull((Object)operation.targetId());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.status());
            Assert.assertNull((Object)operation.statusMessage());
            Assert.assertNull((Object)operation.user());
            Assert.assertNull((Object)operation.progress());
            Assert.assertNull((Object)operation.description());
            Assert.assertNull((Object)operation.insertTime());
            Assert.assertNull((Object)operation.startTime());
            Assert.assertNull((Object)operation.endTime());
            Assert.assertNull((Object)operation.warnings());
            Assert.assertNull((Object)operation.httpErrorMessage());
        }
    }

    @Test
    public void testListRegionOperationsWithFilter() {
        Page operationPage = compute.listRegionOperations(REGION, new Compute.OperationListOption[]{Compute.OperationListOption.filter((Compute.OperationFilter)Compute.OperationFilter.equals((Compute.OperationField)Compute.OperationField.STATUS, (String)"DONE"))});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)REGION, (Object)((RegionOperationId)operation.operationId()).region());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertEquals((Object)Operation.Status.DONE, (Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testListZoneOperations() {
        Page operationPage = compute.listZoneOperations(ZONE, new Compute.OperationListOption[0]);
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)ZONE, (Object)((ZoneOperationId)operation.operationId()).zone());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertNotNull((Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testListZoneOperationsWithSelectedFields() {
        Page operationPage = compute.listZoneOperations(ZONE, new Compute.OperationListOption[]{Compute.OperationListOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.ID})});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)ZONE, (Object)((ZoneOperationId)operation.operationId()).zone());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.targetLink());
            Assert.assertNull((Object)operation.targetId());
            Assert.assertNull((Object)operation.operationType());
            Assert.assertNull((Object)operation.status());
            Assert.assertNull((Object)operation.statusMessage());
            Assert.assertNull((Object)operation.user());
            Assert.assertNull((Object)operation.progress());
            Assert.assertNull((Object)operation.description());
            Assert.assertNull((Object)operation.insertTime());
            Assert.assertNull((Object)operation.startTime());
            Assert.assertNull((Object)operation.endTime());
            Assert.assertNull((Object)operation.warnings());
            Assert.assertNull((Object)operation.httpErrorMessage());
        }
    }

    @Test
    public void testListZoneOperationsWithFilter() {
        Page operationPage = compute.listZoneOperations(ZONE, new Compute.OperationListOption[]{Compute.OperationListOption.filter((Compute.OperationFilter)Compute.OperationFilter.equals((Compute.OperationField)Compute.OperationField.STATUS, (String)"DONE"))});
        Iterator operationIterator = operationPage.iterateAll();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            Assert.assertNotNull((Object)operation.generatedId());
            Assert.assertNotNull((Object)operation.operationId());
            Assert.assertEquals((Object)ZONE, (Object)((ZoneOperationId)operation.operationId()).zone());
            Assert.assertNotNull((Object)operation.operationType());
            Assert.assertEquals((Object)Operation.Status.DONE, (Object)operation.status());
            Assert.assertNotNull((Object)operation.user());
        }
    }

    @Test
    public void testCreateGetAndDeleteRegionAddress() throws InterruptedException, TimeoutException {
        String name = BASE_RESOURCE_NAME + "create-and-get-region-address";
        RegionAddressId addressId = RegionAddressId.of((String)REGION, (String)name);
        AddressInfo addressInfo = AddressInfo.of((AddressId)addressId);
        Operation operation = compute.create(addressInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Address remoteAddress = compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]);
        Assert.assertNotNull((Object)remoteAddress);
        Assert.assertTrue((boolean)(remoteAddress.addressId() instanceof RegionAddressId));
        Assert.assertEquals((Object)REGION, (Object)((RegionAddressId)remoteAddress.addressId()).region());
        Assert.assertEquals((Object)addressId.address(), (Object)remoteAddress.addressId().address());
        Assert.assertNotNull((Object)remoteAddress.address());
        Assert.assertNotNull((Object)remoteAddress.creationTimestamp());
        Assert.assertNotNull((Object)remoteAddress.generatedId());
        Assert.assertNotNull((Object)remoteAddress.status());
        remoteAddress = compute.getAddress((AddressId)addressId, new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])});
        Assert.assertNotNull((Object)remoteAddress);
        Assert.assertTrue((boolean)(remoteAddress.addressId() instanceof RegionAddressId));
        Assert.assertEquals((Object)REGION, (Object)((RegionAddressId)remoteAddress.addressId()).region());
        Assert.assertEquals((Object)addressId.address(), (Object)remoteAddress.addressId().address());
        Assert.assertNull((Object)remoteAddress.address());
        Assert.assertNull((Object)remoteAddress.creationTimestamp());
        Assert.assertNull((Object)remoteAddress.generatedId());
        operation = remoteAddress.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]));
    }

    @Test
    public void testListRegionAddresses() throws InterruptedException, TimeoutException {
        Address address;
        String prefix = BASE_RESOURCE_NAME + "list-region-address";
        Object[] addressNames = new String[]{prefix + "1", prefix + "2"};
        RegionAddressId firstAddressId = RegionAddressId.of((String)REGION, (String)addressNames[0]);
        RegionAddressId secondAddressId = RegionAddressId.of((String)REGION, (String)addressNames[1]);
        Operation firstOperation = compute.create(AddressInfo.of((AddressId)firstAddressId), new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(AddressInfo.of((AddressId)secondAddressId), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet addressSet = ImmutableSet.copyOf((Object[])addressNames);
        Compute.AddressFilter filter = Compute.AddressFilter.equals((Compute.AddressField)Compute.AddressField.NAME, (String)(prefix + "\\d"));
        Page addressPage = compute.listRegionAddresses(REGION, new Compute.AddressListOption[]{Compute.AddressListOption.filter((Compute.AddressFilter)filter)});
        Iterator addressIterator = addressPage.iterateAll();
        int count = 0;
        while (addressIterator.hasNext()) {
            address = (Address)addressIterator.next();
            Assert.assertNotNull((Object)address.addressId());
            Assert.assertTrue((boolean)(address.addressId() instanceof RegionAddressId));
            Assert.assertEquals((Object)REGION, (Object)((RegionAddressId)address.addressId()).region());
            Assert.assertTrue((boolean)addressSet.contains(address.addressId().address()));
            Assert.assertNotNull((Object)address.address());
            Assert.assertNotNull((Object)address.creationTimestamp());
            Assert.assertNotNull((Object)address.generatedId());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        addressPage = compute.listRegionAddresses(REGION, new Compute.AddressListOption[]{Compute.AddressListOption.filter((Compute.AddressFilter)filter), Compute.AddressListOption.fields((Compute.AddressField[])new Compute.AddressField[]{Compute.AddressField.ADDRESS})});
        addressIterator = addressPage.iterateAll();
        while (addressIterator.hasNext()) {
            address = (Address)addressIterator.next();
            Assert.assertTrue((boolean)(address.addressId() instanceof RegionAddressId));
            Assert.assertEquals((Object)REGION, (Object)((RegionAddressId)address.addressId()).region());
            Assert.assertTrue((boolean)addressSet.contains(address.addressId().address()));
            Assert.assertNotNull((Object)address.address());
            Assert.assertNull((Object)address.creationTimestamp());
            Assert.assertNull((Object)address.generatedId());
            Assert.assertNull((Object)address.status());
            Assert.assertNull((Object)address.usage());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        compute.deleteAddress((AddressId)firstAddressId, new Compute.OperationOption[0]);
        compute.deleteAddress((AddressId)secondAddressId, new Compute.OperationOption[0]);
    }

    @Test
    public void testAggregatedListAddresses() throws InterruptedException, TimeoutException {
        String prefix = BASE_RESOURCE_NAME + "aggregated-list-address";
        Object[] addressNames = new String[]{prefix + "1", prefix + "2"};
        RegionAddressId firstAddressId = RegionAddressId.of((String)REGION, (String)addressNames[0]);
        GlobalAddressId secondAddressId = GlobalAddressId.of((String)REGION, (String)addressNames[1]);
        Operation firstOperation = compute.create(AddressInfo.of((AddressId)firstAddressId), new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(AddressInfo.of((AddressId)secondAddressId), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet addressSet = ImmutableSet.copyOf((Object[])addressNames);
        Compute.AddressFilter filter = Compute.AddressFilter.equals((Compute.AddressField)Compute.AddressField.NAME, (String)(prefix + "\\d"));
        Page addressPage = compute.listAddresses(new Compute.AddressAggregatedListOption[]{Compute.AddressAggregatedListOption.filter((Compute.AddressFilter)filter)});
        Iterator addressIterator = addressPage.iterateAll();
        int count = 0;
        while (addressIterator.hasNext()) {
            Address address = (Address)addressIterator.next();
            Assert.assertNotNull((Object)address.addressId());
            Assert.assertTrue((boolean)addressSet.contains(address.addressId().address()));
            Assert.assertNotNull((Object)address.address());
            Assert.assertNotNull((Object)address.creationTimestamp());
            Assert.assertNotNull((Object)address.generatedId());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        compute.deleteAddress((AddressId)firstAddressId, new Compute.OperationOption[0]);
        compute.deleteAddress((AddressId)secondAddressId, new Compute.OperationOption[0]);
    }

    @Test
    public void testCreateGetAndDeleteGlobalAddress() throws InterruptedException, TimeoutException {
        String name = BASE_RESOURCE_NAME + "create-and-get-global-address";
        GlobalAddressId addressId = GlobalAddressId.of((String)name);
        AddressInfo addressInfo = AddressInfo.of((AddressId)addressId);
        Operation operation = compute.create(addressInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Address remoteAddress = compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]);
        Assert.assertNotNull((Object)remoteAddress);
        Assert.assertTrue((boolean)(remoteAddress.addressId() instanceof GlobalAddressId));
        Assert.assertEquals((Object)addressId.address(), (Object)remoteAddress.addressId().address());
        Assert.assertNotNull((Object)remoteAddress.address());
        Assert.assertNotNull((Object)remoteAddress.creationTimestamp());
        Assert.assertNotNull((Object)remoteAddress.generatedId());
        Assert.assertNotNull((Object)remoteAddress.status());
        remoteAddress = compute.getAddress((AddressId)addressId, new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])});
        Assert.assertNotNull((Object)remoteAddress);
        Assert.assertTrue((boolean)(remoteAddress.addressId() instanceof GlobalAddressId));
        Assert.assertEquals((Object)addressId.address(), (Object)remoteAddress.addressId().address());
        Assert.assertNull((Object)remoteAddress.address());
        Assert.assertNull((Object)remoteAddress.creationTimestamp());
        Assert.assertNull((Object)remoteAddress.generatedId());
        operation = remoteAddress.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]));
    }

    @Test
    public void testListGlobalAddresses() throws InterruptedException, TimeoutException {
        Address address;
        String prefix = BASE_RESOURCE_NAME + "list-global-address";
        Object[] addressNames = new String[]{prefix + "1", prefix + "2"};
        GlobalAddressId firstAddressId = GlobalAddressId.of((String)addressNames[0]);
        GlobalAddressId secondAddressId = GlobalAddressId.of((String)addressNames[1]);
        Operation firstOperation = compute.create(AddressInfo.of((AddressId)firstAddressId), new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(AddressInfo.of((AddressId)secondAddressId), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet addressSet = ImmutableSet.copyOf((Object[])addressNames);
        Compute.AddressFilter filter = Compute.AddressFilter.equals((Compute.AddressField)Compute.AddressField.NAME, (String)(prefix + "\\d"));
        Page addressPage = compute.listGlobalAddresses(new Compute.AddressListOption[]{Compute.AddressListOption.filter((Compute.AddressFilter)filter)});
        Iterator addressIterator = addressPage.iterateAll();
        int count = 0;
        while (addressIterator.hasNext()) {
            address = (Address)addressIterator.next();
            Assert.assertNotNull((Object)address.addressId());
            Assert.assertTrue((boolean)(address.addressId() instanceof GlobalAddressId));
            Assert.assertTrue((boolean)addressSet.contains(address.addressId().address()));
            Assert.assertNotNull((Object)address.address());
            Assert.assertNotNull((Object)address.creationTimestamp());
            Assert.assertNotNull((Object)address.generatedId());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        addressPage = compute.listGlobalAddresses(new Compute.AddressListOption[]{Compute.AddressListOption.filter((Compute.AddressFilter)filter), Compute.AddressListOption.fields((Compute.AddressField[])new Compute.AddressField[]{Compute.AddressField.ADDRESS})});
        addressIterator = addressPage.iterateAll();
        while (addressIterator.hasNext()) {
            address = (Address)addressIterator.next();
            Assert.assertTrue((boolean)(address.addressId() instanceof GlobalAddressId));
            Assert.assertTrue((boolean)addressSet.contains(address.addressId().address()));
            Assert.assertNotNull((Object)address.address());
            Assert.assertNull((Object)address.creationTimestamp());
            Assert.assertNull((Object)address.generatedId());
            Assert.assertNull((Object)address.status());
            Assert.assertNull((Object)address.usage());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        compute.deleteAddress((AddressId)firstAddressId, new Compute.OperationOption[0]);
        compute.deleteAddress((AddressId)secondAddressId, new Compute.OperationOption[0]);
    }

    @Test
    public void testCreateGetResizeAndDeleteStandardDisk() throws InterruptedException, TimeoutException {
        String name = BASE_RESOURCE_NAME + "create-and-get-standard-disk";
        DiskId diskId = DiskId.of((String)ZONE, (String)name);
        DiskInfo diskInfo = DiskInfo.of((DiskId)diskId, (DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"), (long)100L));
        Operation operation = compute.create(diskInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Disk remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[0]);
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)diskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertNotNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNotNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof StandardDiskConfiguration));
        StandardDiskConfiguration remoteConfiguration = (StandardDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((long)100L, (long)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-ssd", (Object)remoteConfiguration.diskType().type());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)remoteConfiguration.type());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        operation = remoteDisk.resize(200L, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[]{Compute.DiskField.SIZE_GB})});
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)diskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof StandardDiskConfiguration));
        remoteConfiguration = (StandardDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((long)200L, (long)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-ssd", (Object)remoteConfiguration.diskType().type());
        Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)remoteConfiguration.type());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        operation = remoteDisk.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getDisk(diskId, new Compute.DiskOption[0]));
    }

    @Test
    public void testCreateGetAndDeleteImageDisk() throws InterruptedException, TimeoutException {
        String name = BASE_RESOURCE_NAME + "create-and-get-image-disk";
        DiskId diskId = DiskId.of((String)ZONE, (String)name);
        DiskInfo diskInfo = DiskInfo.of((DiskId)diskId, (DiskConfiguration)ImageDiskConfiguration.of((ImageId)IMAGE_ID));
        Operation operation = compute.create(diskInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Disk remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[0]);
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)diskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertEquals((Object)DiskInfo.CreationStatus.READY, (Object)remoteDisk.creationStatus());
        Assert.assertNotNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNotNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof ImageDiskConfiguration));
        ImageDiskConfiguration remoteConfiguration = (ImageDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((Object)IMAGE_ID, (Object)remoteConfiguration.sourceImage());
        Assert.assertNotNull((Object)remoteConfiguration.sourceImageId());
        Assert.assertEquals((Object)DiskConfiguration.Type.IMAGE, (Object)remoteConfiguration.type());
        Assert.assertNotNull((Object)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-standard", (Object)remoteConfiguration.diskType().type());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])});
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)diskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof ImageDiskConfiguration));
        remoteConfiguration = (ImageDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((Object)IMAGE_ID, (Object)remoteConfiguration.sourceImage());
        Assert.assertNull((Object)remoteConfiguration.sourceImageId());
        Assert.assertEquals((Object)DiskConfiguration.Type.IMAGE, (Object)remoteConfiguration.type());
        Assert.assertNull((Object)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-standard", (Object)remoteConfiguration.diskType().type());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        operation = remoteDisk.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getDisk(diskId, new Compute.DiskOption[0]));
    }

    @Test
    public void testCreateGetAndDeleteSnapshotAndSnapshotDisk() throws InterruptedException, TimeoutException {
        String diskName = BASE_RESOURCE_NAME + "create-and-get-snapshot-disk1";
        String snapshotDiskName = BASE_RESOURCE_NAME + "create-and-get-snapshot-disk2";
        DiskId diskId = DiskId.of((String)ZONE, (String)diskName);
        DiskId snapshotDiskId = DiskId.of((String)ZONE, (String)snapshotDiskName);
        String snapshotName = BASE_RESOURCE_NAME + "create-and-get-snapshot";
        DiskInfo diskInfo = DiskInfo.of((DiskId)diskId, (DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"), (long)100L));
        Operation operation = compute.create(diskInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Disk remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[0]);
        operation = remoteDisk.createSnapshot(snapshotName, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Snapshot snapshot = compute.getSnapshot(snapshotName, new Compute.SnapshotOption[]{Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[]{Compute.SnapshotField.CREATION_TIMESTAMP})});
        Assert.assertNull((Object)snapshot.generatedId());
        Assert.assertNotNull((Object)snapshot.snapshotId());
        Assert.assertNotNull((Object)snapshot.creationTimestamp());
        Assert.assertNull((Object)snapshot.description());
        Assert.assertNull((Object)snapshot.status());
        Assert.assertNull((Object)snapshot.diskSizeGb());
        Assert.assertNull((Object)snapshot.licenses());
        Assert.assertNull((Object)snapshot.sourceDisk());
        Assert.assertNull((Object)snapshot.sourceDiskId());
        Assert.assertNull((Object)snapshot.storageBytes());
        Assert.assertNull((Object)snapshot.storageBytesStatus());
        snapshot = compute.getSnapshot(snapshotName, new Compute.SnapshotOption[0]);
        Assert.assertNotNull((Object)snapshot.generatedId());
        Assert.assertNotNull((Object)snapshot.snapshotId());
        Assert.assertNotNull((Object)snapshot.creationTimestamp());
        Assert.assertNotNull((Object)snapshot.status());
        Assert.assertEquals((long)100L, (long)snapshot.diskSizeGb());
        Assert.assertEquals((Object)diskName, (Object)snapshot.sourceDisk().disk());
        Assert.assertNotNull((Object)snapshot.sourceDiskId());
        Assert.assertNotNull((Object)snapshot.storageBytes());
        Assert.assertNotNull((Object)snapshot.storageBytesStatus());
        remoteDisk.delete(new Compute.OperationOption[0]);
        diskInfo = DiskInfo.of((DiskId)snapshotDiskId, (DiskConfiguration)SnapshotDiskConfiguration.of((SnapshotId)SnapshotId.of((String)snapshotName)));
        operation = compute.create(diskInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteDisk = compute.getDisk(snapshotDiskId, new Compute.DiskOption[0]);
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)snapshotDiskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertEquals((Object)DiskInfo.CreationStatus.READY, (Object)remoteDisk.creationStatus());
        Assert.assertNotNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNotNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof SnapshotDiskConfiguration));
        SnapshotDiskConfiguration remoteConfiguration = (SnapshotDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((Object)DiskConfiguration.Type.SNAPSHOT, (Object)remoteConfiguration.type());
        Assert.assertEquals((Object)snapshotName, (Object)remoteConfiguration.sourceSnapshot().snapshot());
        Assert.assertEquals((long)100L, (long)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-standard", (Object)remoteConfiguration.diskType().type());
        Assert.assertNotNull((Object)remoteConfiguration.sourceSnapshotId());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        remoteDisk = compute.getDisk(snapshotDiskId, new Compute.DiskOption[]{Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[0])});
        Assert.assertNotNull((Object)remoteDisk);
        Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
        Assert.assertEquals((Object)snapshotDiskId.disk(), (Object)remoteDisk.diskId().disk());
        Assert.assertNull((Object)remoteDisk.creationStatus());
        Assert.assertNull((Object)remoteDisk.creationTimestamp());
        Assert.assertNull((Object)remoteDisk.generatedId());
        Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof SnapshotDiskConfiguration));
        remoteConfiguration = (SnapshotDiskConfiguration)remoteDisk.configuration();
        Assert.assertEquals((Object)DiskConfiguration.Type.SNAPSHOT, (Object)remoteConfiguration.type());
        Assert.assertEquals((Object)snapshotName, (Object)remoteConfiguration.sourceSnapshot().snapshot());
        Assert.assertNull((Object)remoteConfiguration.sizeGb());
        Assert.assertEquals((Object)"pd-standard", (Object)remoteConfiguration.diskType().type());
        Assert.assertNull((Object)((SnapshotDiskConfiguration)remoteDisk.configuration()).sourceSnapshotId());
        Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
        Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
        operation = remoteDisk.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getDisk(snapshotDiskId, new Compute.DiskOption[0]));
        operation = snapshot.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getSnapshot(snapshotName, new Compute.SnapshotOption[0]));
    }

    @Test
    public void testListDisksAndSnapshots() throws InterruptedException, TimeoutException {
        Snapshot remoteSnapshot;
        StandardDiskConfiguration remoteConfiguration;
        Disk remoteDisk;
        String prefix = BASE_RESOURCE_NAME + "list-disks-and-snapshots-disk";
        Object[] diskNames = new String[]{prefix + "1", prefix + "2"};
        DiskId firstDiskId = DiskId.of((String)ZONE, (String)diskNames[0]);
        DiskId secondDiskId = DiskId.of((String)ZONE, (String)diskNames[1]);
        StandardDiskConfiguration configuration = StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"), (long)100L);
        Operation firstOperation = compute.create(DiskInfo.of((DiskId)firstDiskId, (DiskConfiguration)configuration), new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(DiskInfo.of((DiskId)secondDiskId, (DiskConfiguration)configuration), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet diskSet = ImmutableSet.copyOf((Object[])diskNames);
        Compute.DiskFilter diskFilter = Compute.DiskFilter.equals((Compute.DiskField)Compute.DiskField.NAME, (String)(prefix + "\\d"));
        Page diskPage = compute.listDisks(ZONE, new Compute.DiskListOption[]{Compute.DiskListOption.filter((Compute.DiskFilter)diskFilter)});
        Iterator diskIterator = diskPage.iterateAll();
        int count = 0;
        while (diskIterator.hasNext()) {
            remoteDisk = (Disk)diskIterator.next();
            Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
            Assert.assertTrue((boolean)diskSet.contains(remoteDisk.diskId().disk()));
            Assert.assertEquals((Object)DiskInfo.CreationStatus.READY, (Object)remoteDisk.creationStatus());
            Assert.assertNotNull((Object)remoteDisk.creationTimestamp());
            Assert.assertNotNull((Object)remoteDisk.generatedId());
            Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof StandardDiskConfiguration));
            remoteConfiguration = (StandardDiskConfiguration)remoteDisk.configuration();
            Assert.assertEquals((long)100L, (long)remoteConfiguration.sizeGb());
            Assert.assertEquals((Object)"pd-ssd", (Object)remoteConfiguration.diskType().type());
            Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)remoteConfiguration.type());
            Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
            Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        diskPage = compute.listDisks(ZONE, new Compute.DiskListOption[]{Compute.DiskListOption.filter((Compute.DiskFilter)diskFilter), Compute.DiskListOption.fields((Compute.DiskField[])new Compute.DiskField[]{Compute.DiskField.STATUS})});
        diskIterator = diskPage.iterateAll();
        while (diskIterator.hasNext()) {
            remoteDisk = (Disk)diskIterator.next();
            Assert.assertEquals((Object)ZONE, (Object)remoteDisk.diskId().zone());
            Assert.assertTrue((boolean)diskSet.contains(remoteDisk.diskId().disk()));
            Assert.assertEquals((Object)DiskInfo.CreationStatus.READY, (Object)remoteDisk.creationStatus());
            Assert.assertNull((Object)remoteDisk.creationTimestamp());
            Assert.assertNull((Object)remoteDisk.generatedId());
            Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof StandardDiskConfiguration));
            remoteConfiguration = (StandardDiskConfiguration)remoteDisk.configuration();
            Assert.assertNull((Object)remoteConfiguration.sizeGb());
            Assert.assertEquals((Object)"pd-ssd", (Object)remoteConfiguration.diskType().type());
            Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)remoteConfiguration.type());
            Assert.assertNull((Object)remoteDisk.lastAttachTimestamp());
            Assert.assertNull((Object)remoteDisk.lastDetachTimestamp());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        SnapshotId firstSnapshotId = SnapshotId.of((String)diskNames[0]);
        SnapshotId secondSnapshotId = SnapshotId.of((String)diskNames[1]);
        firstOperation = compute.create(SnapshotInfo.of((SnapshotId)firstSnapshotId, (DiskId)firstDiskId), new Compute.OperationOption[0]);
        secondOperation = compute.create(SnapshotInfo.of((SnapshotId)secondSnapshotId, (DiskId)secondDiskId), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        Compute.SnapshotFilter snapshotFilter = Compute.SnapshotFilter.equals((Compute.SnapshotField)Compute.SnapshotField.NAME, (String)(prefix + "\\d"));
        Page snapshotPage = compute.listSnapshots(new Compute.SnapshotListOption[]{Compute.SnapshotListOption.filter((Compute.SnapshotFilter)snapshotFilter)});
        Iterator snapshotIterator = snapshotPage.iterateAll();
        count = 0;
        while (snapshotIterator.hasNext()) {
            remoteSnapshot = (Snapshot)snapshotIterator.next();
            Assert.assertNotNull((Object)remoteSnapshot.generatedId());
            Assert.assertTrue((boolean)diskSet.contains(remoteSnapshot.snapshotId().snapshot()));
            Assert.assertNotNull((Object)remoteSnapshot.creationTimestamp());
            Assert.assertNotNull((Object)remoteSnapshot.status());
            Assert.assertEquals((long)100L, (long)remoteSnapshot.diskSizeGb());
            Assert.assertTrue((boolean)diskSet.contains(remoteSnapshot.sourceDisk().disk()));
            Assert.assertNotNull((Object)remoteSnapshot.sourceDiskId());
            Assert.assertNotNull((Object)remoteSnapshot.storageBytes());
            Assert.assertNotNull((Object)remoteSnapshot.storageBytesStatus());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        snapshotPage = compute.listSnapshots(new Compute.SnapshotListOption[]{Compute.SnapshotListOption.filter((Compute.SnapshotFilter)snapshotFilter), Compute.SnapshotListOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[]{Compute.SnapshotField.CREATION_TIMESTAMP})});
        snapshotIterator = snapshotPage.iterateAll();
        count = 0;
        while (snapshotIterator.hasNext()) {
            remoteSnapshot = (Snapshot)snapshotIterator.next();
            Assert.assertNull((Object)remoteSnapshot.generatedId());
            Assert.assertTrue((boolean)diskSet.contains(remoteSnapshot.snapshotId().snapshot()));
            Assert.assertNotNull((Object)remoteSnapshot.creationTimestamp());
            Assert.assertNull((Object)remoteSnapshot.status());
            Assert.assertNull((Object)remoteSnapshot.diskSizeGb());
            Assert.assertNull((Object)remoteSnapshot.sourceDisk());
            Assert.assertNull((Object)remoteSnapshot.sourceDiskId());
            Assert.assertNull((Object)remoteSnapshot.storageBytes());
            Assert.assertNull((Object)remoteSnapshot.storageBytesStatus());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        compute.deleteDisk(firstDiskId, new Compute.OperationOption[0]);
        compute.deleteDisk(secondDiskId, new Compute.OperationOption[0]);
        compute.deleteSnapshot(firstSnapshotId, new Compute.OperationOption[0]);
        compute.deleteSnapshot(secondSnapshotId, new Compute.OperationOption[0]);
    }

    @Test
    public void testAggregatedListDisks() throws InterruptedException, TimeoutException {
        String prefix = BASE_RESOURCE_NAME + "list-aggregated-disk";
        Object[] diskZones = new String[]{ZONE, "us-east1-c"};
        Object[] diskNames = new String[]{prefix + "1", prefix + "2"};
        DiskId firstDiskId = DiskId.of((String)diskZones[0], (String)diskNames[0]);
        DiskId secondDiskId = DiskId.of((String)diskZones[1], (String)diskNames[1]);
        StandardDiskConfiguration configuration = StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"), (long)100L);
        Operation firstOperation = compute.create(DiskInfo.of((DiskId)firstDiskId, (DiskConfiguration)configuration), new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(DiskInfo.of((DiskId)secondDiskId, (DiskConfiguration)configuration), new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet zoneSet = ImmutableSet.copyOf((Object[])diskZones);
        ImmutableSet diskSet = ImmutableSet.copyOf((Object[])diskNames);
        Compute.DiskFilter diskFilter = Compute.DiskFilter.equals((Compute.DiskField)Compute.DiskField.NAME, (String)(prefix + "\\d"));
        Page diskPage = compute.listDisks(new Compute.DiskAggregatedListOption[]{Compute.DiskAggregatedListOption.filter((Compute.DiskFilter)diskFilter)});
        Iterator diskIterator = diskPage.iterateAll();
        int count = 0;
        while (diskIterator.hasNext()) {
            Disk remoteDisk = (Disk)diskIterator.next();
            Assert.assertTrue((boolean)zoneSet.contains(remoteDisk.diskId().zone()));
            Assert.assertTrue((boolean)diskSet.contains(remoteDisk.diskId().disk()));
            Assert.assertEquals((Object)DiskInfo.CreationStatus.READY, (Object)remoteDisk.creationStatus());
            Assert.assertNotNull((Object)remoteDisk.creationTimestamp());
            Assert.assertNotNull((Object)remoteDisk.generatedId());
            Assert.assertTrue((boolean)(remoteDisk.configuration() instanceof StandardDiskConfiguration));
            StandardDiskConfiguration remoteConfiguration = (StandardDiskConfiguration)remoteDisk.configuration();
            Assert.assertEquals((long)100L, (long)remoteConfiguration.sizeGb());
            Assert.assertEquals((Object)"pd-ssd", (Object)remoteConfiguration.diskType().type());
            Assert.assertEquals((Object)DiskConfiguration.Type.STANDARD, (Object)remoteConfiguration.type());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        compute.deleteDisk(firstDiskId, new Compute.OperationOption[0]);
        compute.deleteDisk(secondDiskId, new Compute.OperationOption[0]);
    }

    @Test
    public void testCreateGetAndDeprecateImage() throws InterruptedException, TimeoutException {
        String diskName = BASE_RESOURCE_NAME + "create-and-get-image-disk";
        String imageName = BASE_RESOURCE_NAME + "create-and-get-image";
        DiskId diskId = DiskId.of((String)ZONE, (String)diskName);
        ImageId imageId = ImageId.of((String)imageName);
        DiskInfo diskInfo = DiskInfo.of((DiskId)diskId, (DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"), (long)100L));
        Operation operation = compute.create(diskInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Disk remoteDisk = compute.getDisk(diskId, new Compute.DiskOption[0]);
        ImageInfo imageInfo = ImageInfo.of((ImageId)imageId, (ImageConfiguration)DiskImageConfiguration.of((DiskId)diskId));
        operation = compute.create(imageInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Image image = compute.getImage(imageId, new Compute.ImageOption[]{Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[]{Compute.ImageField.CREATION_TIMESTAMP})});
        Assert.assertNull((Object)image.generatedId());
        Assert.assertNotNull((Object)image.imageId());
        Assert.assertNotNull((Object)image.creationTimestamp());
        Assert.assertNull((Object)image.description());
        Assert.assertNotNull((Object)image.configuration());
        Assert.assertTrue((boolean)(image.configuration() instanceof DiskImageConfiguration));
        DiskImageConfiguration remoteConfiguration = (DiskImageConfiguration)image.configuration();
        Assert.assertEquals((Object)ImageConfiguration.Type.DISK, (Object)remoteConfiguration.type());
        Assert.assertEquals((Object)diskName, (Object)remoteConfiguration.sourceDisk().disk());
        Assert.assertNull((Object)image.status());
        Assert.assertNull((Object)image.diskSizeGb());
        Assert.assertNull((Object)image.licenses());
        Assert.assertNull((Object)image.deprecationStatus());
        image = compute.getImage(imageId, new Compute.ImageOption[0]);
        Assert.assertNotNull((Object)image.generatedId());
        Assert.assertNotNull((Object)image.imageId());
        Assert.assertNotNull((Object)image.creationTimestamp());
        Assert.assertNotNull((Object)image.configuration());
        Assert.assertTrue((boolean)(image.configuration() instanceof DiskImageConfiguration));
        remoteConfiguration = (DiskImageConfiguration)image.configuration();
        Assert.assertEquals((Object)ImageConfiguration.Type.DISK, (Object)remoteConfiguration.type());
        Assert.assertEquals((Object)diskName, (Object)remoteConfiguration.sourceDisk().disk());
        Assert.assertEquals((long)100L, (long)image.diskSizeGb());
        Assert.assertNotNull((Object)image.status());
        Assert.assertNull((Object)image.deprecationStatus());
        DeprecationStatus deprecationStatus = DeprecationStatus.builder((DeprecationStatus.Status)DeprecationStatus.Status.DEPRECATED, (ResourceId)imageId).deprecated(System.currentTimeMillis()).build();
        operation = image.deprecate(deprecationStatus, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        image = compute.getImage(imageId, new Compute.ImageOption[0]);
        Assert.assertEquals((Object)deprecationStatus, (Object)image.deprecationStatus());
        remoteDisk.delete(new Compute.OperationOption[0]);
        operation = image.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getImage(imageId, new Compute.ImageOption[0]));
    }

    @Test
    public void testListImages() {
        Page imagePage = compute.listImages(IMAGE_PROJECT, new Compute.ImageListOption[0]);
        Iterator imageIterator = imagePage.iterateAll();
        int count = 0;
        while (imageIterator.hasNext()) {
            ++count;
            Image image = (Image)imageIterator.next();
            Assert.assertNotNull((Object)image.generatedId());
            Assert.assertNotNull((Object)image.imageId());
            Assert.assertNotNull((Object)image.creationTimestamp());
            Assert.assertNotNull((Object)image.configuration());
            Assert.assertNotNull((Object)image.status());
            Assert.assertNotNull((Object)image.diskSizeGb());
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListImagesWithSelectedFields() {
        Page imagePage = compute.listImages(IMAGE_PROJECT, new Compute.ImageListOption[]{Compute.ImageListOption.fields((Compute.ImageField[])new Compute.ImageField[]{Compute.ImageField.ID})});
        Iterator imageIterator = imagePage.iterateAll();
        int count = 0;
        while (imageIterator.hasNext()) {
            ++count;
            Image image = (Image)imageIterator.next();
            Assert.assertNotNull((Object)image.generatedId());
            Assert.assertNotNull((Object)image.imageId());
            Assert.assertNull((Object)image.creationTimestamp());
            Assert.assertNotNull((Object)image.configuration());
            Assert.assertNull((Object)image.status());
            Assert.assertNull((Object)image.diskSizeGb());
            Assert.assertNull((Object)image.licenses());
            Assert.assertNull((Object)image.deprecationStatus());
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListImagesWithFilter() {
        Page imagePage = compute.listImages(IMAGE_PROJECT, new Compute.ImageListOption[]{Compute.ImageListOption.filter((Compute.ImageFilter)Compute.ImageFilter.equals((Compute.ImageField)Compute.ImageField.ARCHIVE_SIZE_BYTES, (long)365056004L))});
        Iterator imageIterator = imagePage.iterateAll();
        int count = 0;
        while (imageIterator.hasNext()) {
            ++count;
            Image image = (Image)imageIterator.next();
            Assert.assertNotNull((Object)image.generatedId());
            Assert.assertNotNull((Object)image.imageId());
            Assert.assertNotNull((Object)image.creationTimestamp());
            Assert.assertNotNull((Object)image.configuration());
            Assert.assertNotNull((Object)image.status());
            Assert.assertNotNull((Object)image.diskSizeGb());
            Assert.assertEquals((long)365056004L, (long)((StorageImageConfiguration)image.configuration()).archiveSizeBytes());
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAndGetNetwork() throws InterruptedException, TimeoutException {
        String name = BASE_RESOURCE_NAME + "create-and-get-network";
        NetworkId networkId = NetworkId.of((String)name);
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)networkId, (NetworkConfiguration)StandardNetworkConfiguration.of((String)"192.168.0.0/16"));
        Operation operation = compute.create(networkInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Network network = compute.getNetwork(networkId.network(), new Compute.NetworkOption[]{Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[]{Compute.NetworkField.CREATION_TIMESTAMP})});
        Assert.assertEquals((Object)networkId.network(), (Object)network.networkId().network());
        Assert.assertNull((Object)network.generatedId());
        Assert.assertNotNull((Object)network.creationTimestamp());
        Assert.assertNull((Object)network.description());
        Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)network.configuration().type());
        StandardNetworkConfiguration remoteConfiguration = (StandardNetworkConfiguration)network.configuration();
        Assert.assertEquals((Object)"192.168.0.0/16", (Object)remoteConfiguration.ipRange());
        network = compute.getNetwork(networkId.network(), new Compute.NetworkOption[0]);
        Assert.assertEquals((Object)networkId.network(), (Object)network.networkId().network());
        Assert.assertNotNull((Object)network.generatedId());
        Assert.assertNotNull((Object)network.creationTimestamp());
        Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)network.configuration().type());
        remoteConfiguration = (StandardNetworkConfiguration)network.configuration();
        Assert.assertEquals((Object)"192.168.0.0/16", (Object)remoteConfiguration.ipRange());
        operation = network.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getNetwork(name, new Compute.NetworkOption[0]));
    }

    @Test
    public void testListNetworks() throws InterruptedException, TimeoutException {
        StandardNetworkConfiguration remoteConfiguration;
        Network network;
        String name = BASE_RESOURCE_NAME + "list-network";
        NetworkId networkId = NetworkId.of((String)name);
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)networkId, (NetworkConfiguration)StandardNetworkConfiguration.of((String)"192.168.0.0/16"));
        Operation operation = compute.create(networkInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Compute.NetworkFilter filter = Compute.NetworkFilter.equals((Compute.NetworkField)Compute.NetworkField.NAME, (String)name);
        Page networkPage = compute.listNetworks(new Compute.NetworkListOption[]{Compute.NetworkListOption.filter((Compute.NetworkFilter)filter)});
        Iterator networkIterator = networkPage.iterateAll();
        int count = 0;
        while (networkIterator.hasNext()) {
            network = (Network)networkIterator.next();
            Assert.assertEquals((Object)networkId.network(), (Object)network.networkId().network());
            Assert.assertNotNull((Object)network.generatedId());
            Assert.assertNotNull((Object)network.creationTimestamp());
            Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)network.configuration().type());
            remoteConfiguration = (StandardNetworkConfiguration)network.configuration();
            Assert.assertEquals((Object)"192.168.0.0/16", (Object)remoteConfiguration.ipRange());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        count = 0;
        networkPage = compute.listNetworks(new Compute.NetworkListOption[]{Compute.NetworkListOption.filter((Compute.NetworkFilter)filter), Compute.NetworkListOption.fields((Compute.NetworkField[])new Compute.NetworkField[]{Compute.NetworkField.CREATION_TIMESTAMP})});
        networkIterator = networkPage.iterateAll();
        while (networkIterator.hasNext()) {
            network = (Network)networkIterator.next();
            Assert.assertEquals((Object)networkId.network(), (Object)network.networkId().network());
            Assert.assertNull((Object)network.generatedId());
            Assert.assertNotNull((Object)network.creationTimestamp());
            Assert.assertNull((Object)network.description());
            Assert.assertEquals((Object)NetworkConfiguration.Type.STANDARD, (Object)network.configuration().type());
            remoteConfiguration = (StandardNetworkConfiguration)network.configuration();
            Assert.assertEquals((Object)"192.168.0.0/16", (Object)remoteConfiguration.ipRange());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        operation = compute.deleteNetwork(networkId, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getNetwork(name, new Compute.NetworkOption[0]));
    }

    @Test
    public void testCreateNetworkAndSubnetwork() throws InterruptedException, TimeoutException {
        Subnetwork remoteSubnetwork;
        String networkName = BASE_RESOURCE_NAME + "create-subnetwork-network";
        NetworkId networkId = NetworkId.of((String)networkName);
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)networkId, (NetworkConfiguration)SubnetNetworkConfiguration.of((boolean)false));
        Operation operation = compute.create(networkInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Network network = compute.getNetwork(networkId.network(), new Compute.NetworkOption[0]);
        Assert.assertEquals((Object)networkId.network(), (Object)network.networkId().network());
        Assert.assertNotNull((Object)network.generatedId());
        Assert.assertNotNull((Object)network.creationTimestamp());
        Assert.assertEquals((Object)NetworkConfiguration.Type.SUBNET, (Object)network.configuration().type());
        Assert.assertTrue((boolean)(network.configuration() instanceof SubnetNetworkConfiguration));
        Assert.assertFalse((boolean)((SubnetNetworkConfiguration)network.configuration()).autoCreateSubnetworks());
        String subnetworkName = BASE_RESOURCE_NAME + "create-subnetwork-subnetwork";
        SubnetworkId subnetworkId = SubnetworkId.of((String)REGION, (String)subnetworkName);
        SubnetworkInfo subnetworkInfo = SubnetworkInfo.of((SubnetworkId)subnetworkId, (NetworkId)networkId, (String)"192.168.0.0/16");
        operation = compute.create(subnetworkInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Subnetwork subnetwork = compute.getSubnetwork(subnetworkId, new Compute.SubnetworkOption[]{Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[]{Compute.SubnetworkField.CREATION_TIMESTAMP})});
        Assert.assertNull((Object)subnetwork.generatedId());
        Assert.assertEquals((Object)subnetworkId.subnetwork(), (Object)subnetwork.subnetworkId().subnetwork());
        Assert.assertNotNull((Object)subnetwork.creationTimestamp());
        Assert.assertNull((Object)subnetwork.description());
        Assert.assertNull((Object)subnetwork.gatewayAddress());
        Assert.assertNull((Object)subnetwork.network());
        Assert.assertNull((Object)subnetwork.ipRange());
        subnetwork = compute.getSubnetwork(subnetworkId, new Compute.SubnetworkOption[0]);
        Assert.assertNotNull((Object)subnetwork.generatedId());
        Assert.assertEquals((Object)subnetworkId.subnetwork(), (Object)subnetwork.subnetworkId().subnetwork());
        Assert.assertNotNull((Object)subnetwork.creationTimestamp());
        Assert.assertNotNull((Object)subnetwork.gatewayAddress());
        Assert.assertEquals((Object)networkId.network(), (Object)subnetwork.network().network());
        Assert.assertEquals((Object)"192.168.0.0/16", (Object)subnetwork.ipRange());
        Compute.SubnetworkFilter filter = Compute.SubnetworkFilter.equals((Compute.SubnetworkField)Compute.SubnetworkField.NAME, (String)subnetworkName);
        Page subnetworkPage = compute.listSubnetworks(REGION, new Compute.SubnetworkListOption[]{Compute.SubnetworkListOption.filter((Compute.SubnetworkFilter)filter)});
        Iterator subnetworkIterator = subnetworkPage.iterateAll();
        int count = 0;
        while (subnetworkIterator.hasNext()) {
            remoteSubnetwork = (Subnetwork)subnetworkIterator.next();
            Assert.assertNotNull((Object)remoteSubnetwork.generatedId());
            Assert.assertEquals((Object)subnetworkId.subnetwork(), (Object)remoteSubnetwork.subnetworkId().subnetwork());
            Assert.assertNotNull((Object)remoteSubnetwork.creationTimestamp());
            Assert.assertNotNull((Object)remoteSubnetwork.gatewayAddress());
            Assert.assertEquals((Object)networkId.network(), (Object)remoteSubnetwork.network().network());
            Assert.assertEquals((Object)"192.168.0.0/16", (Object)remoteSubnetwork.ipRange());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        subnetworkPage = compute.listSubnetworks(REGION, new Compute.SubnetworkListOption[]{Compute.SubnetworkListOption.filter((Compute.SubnetworkFilter)filter), Compute.SubnetworkListOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[]{Compute.SubnetworkField.CREATION_TIMESTAMP})});
        subnetworkIterator = subnetworkPage.iterateAll();
        count = 0;
        while (subnetworkIterator.hasNext()) {
            remoteSubnetwork = (Subnetwork)subnetworkIterator.next();
            Assert.assertNull((Object)remoteSubnetwork.generatedId());
            Assert.assertEquals((Object)subnetworkId.subnetwork(), (Object)remoteSubnetwork.subnetworkId().subnetwork());
            Assert.assertNotNull((Object)remoteSubnetwork.creationTimestamp());
            Assert.assertNull((Object)remoteSubnetwork.description());
            Assert.assertNull((Object)remoteSubnetwork.gatewayAddress());
            Assert.assertNull((Object)remoteSubnetwork.network());
            Assert.assertNull((Object)remoteSubnetwork.ipRange());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        operation = subnetwork.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        operation = compute.deleteNetwork(networkId, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getSubnetwork(subnetworkId, new Compute.SubnetworkOption[0]));
        Assert.assertNull((Object)compute.getNetwork(networkName, new Compute.NetworkOption[0]));
    }

    @Test
    public void testAggregatedListSubnetworks() throws InterruptedException, TimeoutException {
        String networkName = BASE_RESOURCE_NAME + "list-subnetwork-network";
        NetworkId networkId = NetworkId.of((String)networkName);
        NetworkInfo networkInfo = NetworkInfo.of((NetworkId)networkId, (NetworkConfiguration)SubnetNetworkConfiguration.of((boolean)false));
        Operation operation = compute.create(networkInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        String prefix = BASE_RESOURCE_NAME + "list-subnetwork";
        Object[] regionNames = new String[]{REGION, "us-east1"};
        Object[] subnetworkNames = new String[]{prefix + "1", prefix + "2"};
        Object[] ipRanges = new String[]{"10.128.0.0/20", "10.132.0.0/20"};
        SubnetworkId firstSubnetworkId = SubnetworkId.of((String)regionNames[0], (String)subnetworkNames[0]);
        SubnetworkId secondSubnetworkId = SubnetworkId.of((String)regionNames[1], (String)subnetworkNames[1]);
        SubnetworkInfo firstSubnetworkInfo = SubnetworkInfo.of((SubnetworkId)firstSubnetworkId, (NetworkId)networkId, (String)ipRanges[0]);
        SubnetworkInfo secondSubnetworkInfo = SubnetworkInfo.of((SubnetworkId)secondSubnetworkId, (NetworkId)networkId, (String)ipRanges[1]);
        Operation firstOperation = compute.create(firstSubnetworkInfo, new Compute.OperationOption[0]);
        Operation secondOperation = compute.create(secondSubnetworkInfo, new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        ImmutableSet regionSet = ImmutableSet.copyOf((Object[])regionNames);
        ImmutableSet subnetworkSet = ImmutableSet.copyOf((Object[])subnetworkNames);
        ImmutableSet rangeSet = ImmutableSet.copyOf((Object[])ipRanges);
        Compute.SubnetworkFilter subnetworkFilter = Compute.SubnetworkFilter.equals((Compute.SubnetworkField)Compute.SubnetworkField.NAME, (String)(prefix + "\\d"));
        Page subnetworkPage = compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[]{Compute.SubnetworkAggregatedListOption.filter((Compute.SubnetworkFilter)subnetworkFilter)});
        Iterator subnetworkIterator = subnetworkPage.iterateAll();
        int count = 0;
        while (subnetworkIterator.hasNext()) {
            Subnetwork remoteSubnetwork = (Subnetwork)subnetworkIterator.next();
            Assert.assertNotNull((Object)remoteSubnetwork.generatedId());
            Assert.assertTrue((boolean)regionSet.contains(remoteSubnetwork.subnetworkId().region()));
            Assert.assertTrue((boolean)subnetworkSet.contains(remoteSubnetwork.subnetworkId().subnetwork()));
            Assert.assertNotNull((Object)remoteSubnetwork.creationTimestamp());
            Assert.assertNotNull((Object)remoteSubnetwork.gatewayAddress());
            Assert.assertEquals((Object)networkId.network(), (Object)remoteSubnetwork.network().network());
            Assert.assertTrue((boolean)rangeSet.contains(remoteSubnetwork.ipRange()));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        firstOperation = compute.deleteSubnetwork(firstSubnetworkId, new Compute.OperationOption[0]);
        secondOperation = compute.deleteSubnetwork(secondSubnetworkId, new Compute.OperationOption[0]);
        firstOperation.waitFor(new WaitForOption[0]);
        secondOperation.waitFor(new WaitForOption[0]);
        operation = compute.deleteNetwork(networkId, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getNetwork(networkName, new Compute.NetworkOption[0]));
    }

    @Test
    public void testCreateGetAndDeleteInstance() throws InterruptedException, TimeoutException {
        String instanceName = BASE_RESOURCE_NAME + "create-and-get-instance";
        String addressName = BASE_RESOURCE_NAME + "create-and-get-instance-address";
        RegionAddressId addressId = RegionAddressId.of((String)REGION, (String)addressName);
        AddressInfo addressInfo = AddressInfo.of((AddressId)addressId);
        Operation operation = compute.create(addressInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Address address = compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]);
        InstanceId instanceId = InstanceId.of((String)ZONE, (String)instanceName);
        NetworkId networkId = NetworkId.of((String)"default");
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).accessConfigurations(new NetworkInterface.AccessConfig[]{NetworkInterface.AccessConfig.builder().name("NAT").natIp(address.address()).build()}).build();
        AttachedDisk disk1 = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(Boolean.valueOf(true)).build());
        AttachedDisk disk2 = AttachedDisk.of((String)"dev1", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)DISK_TYPE)));
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)instanceId, (MachineTypeId)MachineTypeId.of((String)ZONE, (String)"n1-standard-1")).attachedDisks(new AttachedDisk[]{disk1, disk2}).networkInterfaces(new NetworkInterface[]{networkInterface}).build();
        operation = compute.create(instanceInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Instance remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)instanceName, (Object)remoteInstance.instanceId().instance());
        Assert.assertEquals((Object)ZONE, (Object)remoteInstance.instanceId().zone());
        Assert.assertEquals((Object)InstanceInfo.Status.RUNNING, (Object)remoteInstance.status());
        Assert.assertEquals((Object)"n1-standard-1", (Object)remoteInstance.machineType().type());
        Assert.assertEquals((Object)ZONE, (Object)remoteInstance.machineType().zone());
        Assert.assertNotNull((Object)remoteInstance.creationTimestamp());
        ImmutableSet deviceSet = ImmutableSet.of((Object)"dev0", (Object)"dev1");
        Assert.assertEquals((long)2L, (long)remoteInstance.attachedDisks().size());
        for (AttachedDisk remoteAttachedDisk : remoteInstance.attachedDisks()) {
            Assert.assertTrue((boolean)deviceSet.contains(remoteAttachedDisk.deviceName()));
        }
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.PERSISTENT, (Object)((AttachedDisk)remoteInstance.attachedDisks().get(0)).configuration().type());
        AttachedDisk.PersistentDiskConfiguration remoteConfiguration = (AttachedDisk.PersistentDiskConfiguration)((AttachedDisk)remoteInstance.attachedDisks().get(0)).configuration();
        Assert.assertEquals((Object)instanceName, (Object)remoteConfiguration.sourceDisk().disk());
        Assert.assertEquals((Object)ZONE, (Object)remoteConfiguration.sourceDisk().zone());
        Assert.assertTrue((boolean)remoteConfiguration.boot());
        Assert.assertTrue((boolean)remoteConfiguration.autoDelete());
        Assert.assertEquals((long)1L, (long)remoteInstance.networkInterfaces().size());
        NetworkInterface remoteNetworkInterface = (NetworkInterface)remoteInstance.networkInterfaces().get(0);
        Assert.assertNotNull((Object)remoteNetworkInterface.name());
        Assert.assertEquals((Object)"default", (Object)remoteNetworkInterface.network().network());
        List remoteAccessConfigurations = remoteNetworkInterface.accessConfigurations();
        Assert.assertNotNull((Object)remoteAccessConfigurations);
        Assert.assertEquals((long)1L, (long)remoteAccessConfigurations.size());
        NetworkInterface.AccessConfig remoteAccessConfig = (NetworkInterface.AccessConfig)remoteAccessConfigurations.get(0);
        Assert.assertEquals((Object)address.address(), (Object)remoteAccessConfig.natIp());
        Assert.assertEquals((Object)"NAT", (Object)remoteAccessConfig.name());
        Assert.assertNotNull((Object)remoteInstance.metadata());
        Assert.assertNotNull((Object)remoteInstance.tags());
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.CREATION_TIMESTAMP})});
        Assert.assertEquals((Object)instanceName, (Object)remoteInstance.instanceId().instance());
        Assert.assertEquals((Object)ZONE, (Object)remoteInstance.instanceId().zone());
        Assert.assertNull((Object)remoteInstance.machineType());
        Assert.assertNotNull((Object)remoteInstance.creationTimestamp());
        Assert.assertNull((Object)remoteInstance.attachedDisks());
        Assert.assertNull((Object)remoteInstance.networkInterfaces());
        Assert.assertNull((Object)remoteInstance.metadata());
        Assert.assertNull((Object)remoteInstance.tags());
        String serialPortOutput = remoteInstance.getSerialPortOutput();
        Assert.assertNotNull((Object)serialPortOutput);
        String newSerialPortOutput = remoteInstance.getSerialPortOutput(1);
        Assert.assertTrue((boolean)newSerialPortOutput.contains(serialPortOutput));
        operation = remoteInstance.delete(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Assert.assertNull((Object)compute.getInstance(instanceId, new Compute.InstanceOption[0]));
        address.delete(new Compute.OperationOption[0]);
    }

    @Test
    public void testStartStopAndResetInstance() throws InterruptedException, TimeoutException {
        String instanceName = BASE_RESOURCE_NAME + "start-stop-reset-instance";
        InstanceId instanceId = InstanceId.of((String)ZONE, (String)instanceName);
        NetworkId networkId = NetworkId.of((String)"default");
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).build();
        AttachedDisk disk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(Boolean.valueOf(true)).build());
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)instanceId, (MachineTypeId)MachineTypeId.of((String)ZONE, (String)MACHINE_TYPE)).attachedDisks(new AttachedDisk[]{disk}).networkInterfaces(new NetworkInterface[]{networkInterface}).build();
        Operation operation = compute.create(instanceInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Instance remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.STATUS})});
        Assert.assertEquals((Object)InstanceInfo.Status.RUNNING, (Object)remoteInstance.status());
        operation = remoteInstance.stop(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.STATUS})});
        Assert.assertEquals((Object)InstanceInfo.Status.TERMINATED, (Object)remoteInstance.status());
        operation = remoteInstance.start(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.STATUS})});
        Assert.assertEquals((Object)InstanceInfo.Status.RUNNING, (Object)remoteInstance.status());
        operation = remoteInstance.reset(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[]{Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.STATUS})});
        Assert.assertEquals((Object)InstanceInfo.Status.RUNNING, (Object)remoteInstance.status());
        remoteInstance.delete(new Compute.OperationOption[0]);
    }

    @Test
    public void testSetInstanceProperties() throws InterruptedException, TimeoutException {
        String instanceName = BASE_RESOURCE_NAME + "set-properties-instance";
        InstanceId instanceId = InstanceId.of((String)ZONE, (String)instanceName);
        NetworkId networkId = NetworkId.of((String)"default");
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).build();
        AttachedDisk disk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(Boolean.valueOf(true)).build());
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)instanceId, (MachineTypeId)MachineTypeId.of((String)ZONE, (String)MACHINE_TYPE)).attachedDisks(new AttachedDisk[]{disk}).networkInterfaces(new NetworkInterface[]{networkInterface}).build();
        Operation operation = compute.create(instanceInfo, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        Instance remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        ImmutableList tags = ImmutableList.of((Object)"tag1", (Object)"tag2");
        operation = remoteInstance.setTags((Iterable)tags, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)tags, (Object)remoteInstance.tags().values());
        ImmutableMap metadata = ImmutableMap.of((Object)"key", (Object)"value");
        operation = remoteInstance.setMetadata((Map)metadata, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)metadata, (Object)remoteInstance.metadata().values());
        operation = remoteInstance.stop(new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        operation = remoteInstance.setMachineType(MachineTypeId.of((String)ZONE, (String)"n1-standard-1"), new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)"n1-standard-1", (Object)remoteInstance.machineType().type());
        Assert.assertEquals((Object)ZONE, (Object)remoteInstance.machineType().zone());
        SchedulingOptions options = SchedulingOptions.standard((boolean)false, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.TERMINATE);
        operation = remoteInstance.setSchedulingOptions(options, new Compute.OperationOption[0]);
        operation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)options, (Object)remoteInstance.schedulingOptions());
        remoteInstance.delete(new Compute.OperationOption[0]);
    }

    @Test
    public void testAttachAndDetachDisk() throws InterruptedException, TimeoutException {
        String instanceName = BASE_RESOURCE_NAME + "attach-and-detach-disk-instance";
        String diskName = BASE_RESOURCE_NAME + "attach-and-detach-disk";
        InstanceId instanceId = InstanceId.of((String)ZONE, (String)instanceName);
        NetworkId networkId = NetworkId.of((String)"default");
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).build();
        AttachedDisk disk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(Boolean.valueOf(true)).build());
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)instanceId, (MachineTypeId)MachineTypeId.of((String)ZONE, (String)MACHINE_TYPE)).attachedDisks(new AttachedDisk[]{disk}).networkInterfaces(new NetworkInterface[]{networkInterface}).build();
        Operation instanceOperation = compute.create(instanceInfo, new Compute.OperationOption[0]);
        DiskId diskId = DiskId.of((String)ZONE, (String)diskName);
        Operation diskOperation = compute.create(DiskInfo.of((DiskId)diskId, (DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)ZONE, (String)"pd-ssd"))), new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        diskOperation.waitFor(new WaitForOption[0]);
        Instance remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        instanceOperation = remoteInstance.attachDisk("dev1", AttachedDisk.PersistentDiskConfiguration.builder((DiskId)diskId).build(), new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        ImmutableSet deviceSet = ImmutableSet.of((Object)"dev0", (Object)"dev1");
        Assert.assertEquals((long)2L, (long)remoteInstance.attachedDisks().size());
        for (AttachedDisk remoteAttachedDisk : remoteInstance.attachedDisks()) {
            Assert.assertTrue((boolean)deviceSet.contains(remoteAttachedDisk.deviceName()));
        }
        instanceOperation = remoteInstance.setDiskAutoDelete("dev1", true, new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((long)2L, (long)remoteInstance.attachedDisks().size());
        for (AttachedDisk remoteAttachedDisk : remoteInstance.attachedDisks()) {
            Assert.assertTrue((boolean)deviceSet.contains(remoteAttachedDisk.deviceName()));
            Assert.assertTrue((boolean)remoteAttachedDisk.configuration().autoDelete());
        }
        instanceOperation = remoteInstance.detachDisk("dev1", new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertEquals((long)1L, (long)remoteInstance.attachedDisks().size());
        Assert.assertEquals((Object)"dev0", (Object)((AttachedDisk)remoteInstance.attachedDisks().get(0)).deviceName());
        remoteInstance.delete(new Compute.OperationOption[0]);
        compute.deleteDisk(diskId, new Compute.OperationOption[0]);
    }

    @Test
    public void testAddAndRemoveAccessConfig() throws InterruptedException, TimeoutException {
        String instanceName = BASE_RESOURCE_NAME + "add-and-remove-access-instance";
        String addressName = BASE_RESOURCE_NAME + "add-and-remove-access-address";
        InstanceId instanceId = InstanceId.of((String)ZONE, (String)instanceName);
        NetworkId networkId = NetworkId.of((String)"default");
        NetworkInterface networkInterface = NetworkInterface.builder((NetworkId)networkId).build();
        AttachedDisk disk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(Boolean.valueOf(true)).build());
        InstanceInfo instanceInfo = InstanceInfo.builder((InstanceId)instanceId, (MachineTypeId)MachineTypeId.of((String)ZONE, (String)MACHINE_TYPE)).attachedDisks(new AttachedDisk[]{disk}).networkInterfaces(new NetworkInterface[]{networkInterface}).build();
        Operation instanceOperation = compute.create(instanceInfo, new Compute.OperationOption[0]);
        RegionAddressId addressId = RegionAddressId.of((String)REGION, (String)addressName);
        AddressInfo addressInfo = AddressInfo.of((AddressId)addressId);
        Operation addressOperation = compute.create(addressInfo, new Compute.OperationOption[0]);
        addressOperation.waitFor(new WaitForOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        Address remoteAddress = compute.getAddress((AddressId)addressId, new Compute.AddressOption[0]);
        Instance remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        String networkInterfaceName = ((NetworkInterface)remoteInstance.networkInterfaces().get(0)).name();
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.builder().natIp(remoteAddress.address()).name("NAT").build();
        instanceOperation = remoteInstance.addAccessConfig(networkInterfaceName, accessConfig, new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        List accessConfigurations = ((NetworkInterface)remoteInstance.networkInterfaces().get(0)).accessConfigurations();
        Assert.assertEquals((long)1L, (long)accessConfigurations.size());
        Assert.assertEquals((Object)"NAT", (Object)((NetworkInterface.AccessConfig)accessConfigurations.get(0)).name());
        instanceOperation = remoteInstance.deleteAccessConfig(networkInterfaceName, "NAT", new Compute.OperationOption[0]);
        instanceOperation.waitFor(new WaitForOption[0]);
        remoteInstance = compute.getInstance(instanceId, new Compute.InstanceOption[0]);
        Assert.assertTrue((boolean)((NetworkInterface)remoteInstance.networkInterfaces().get(0)).accessConfigurations().isEmpty());
        remoteInstance.delete(new Compute.OperationOption[0]);
        remoteAddress.delete(new Compute.OperationOption[0]);
    }
}

