/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseId
extends ResourceId {
    static final Function<String, LicenseId> FROM_URL_FUNCTION = new Function<String, LicenseId>(){

        public LicenseId apply(String pb) {
            return LicenseId.fromUrl(pb);
        }
    };
    static final Function<LicenseId, String> TO_URL_FUNCTION = new Function<LicenseId, String>(){

        public String apply(LicenseId licenseId) {
            return licenseId.selfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/global/licenses/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/global/licenses/([^/]+)");
    private static final long serialVersionUID = -2239484554024469651L;
    private final String license;

    private LicenseId(String project, String license) {
        super(project);
        this.license = (String)Preconditions.checkNotNull((Object)license);
    }

    public String license() {
        return this.license;
    }

    @Override
    public String selfLink() {
        return super.selfLink() + "/global/licenses/" + this.license;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("license", (Object)this.license);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.license);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LicenseId)) {
            return false;
        }
        LicenseId other = (LicenseId)obj;
        return this.baseEquals(other) && Objects.equals(this.license, other.license);
    }

    @Override
    LicenseId setProjectId(String projectId) {
        if (this.project() != null) {
            return this;
        }
        return LicenseId.of(projectId, this.license);
    }

    public static LicenseId of(String license) {
        return new LicenseId(null, license);
    }

    public static LicenseId of(String project, String license) {
        return new LicenseId(project, license);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static LicenseId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid license URL");
        }
        return LicenseId.of(matcher.group(1), matcher.group(2));
    }
}

