/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseDatastoreBatchWriter;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1beta3.Mutation;
import java.util.LinkedList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseDatastoreBatchWriterTest {
    private static final Key KEY1 = Key.builder((String)"dataset1", (String)"kind1", (String)"name1").build();
    private static final Key KEY2 = Key.builder((IncompleteKey)KEY1, (long)1L).build();
    private static final Key KEY3 = Key.builder((IncompleteKey)KEY1, (long)2L).build();
    private static final IncompleteKey INCOMPLETE_KEY = IncompleteKey.builder((IncompleteKey)KEY1).build();
    private static final Entity ENTITY1 = Entity.builder((Key)KEY1).build();
    private static final Entity ENTITY2 = ((Entity.Builder)Entity.builder((Key)KEY2).set("bak", true)).build();
    private static final Entity ENTITY3 = ((Entity.Builder)Entity.builder((Key)KEY3).set("bak", true)).build();
    private static final FullEntity<IncompleteKey> INCOMPLETE_ENTITY_1 = Entity.builder((IncompleteKey)INCOMPLETE_KEY).build();
    private static final FullEntity<IncompleteKey> INCOMPLETE_ENTITY_2 = ((FullEntity.Builder)Entity.builder((IncompleteKey)INCOMPLETE_KEY).set("name", "dan")).build();
    private DatastoreBatchWriter batchWriter;

    @Before
    public void setUp() {
        this.batchWriter = new DatastoreBatchWriter();
    }

    @After
    public void tearDown() {
        this.batchWriter.finish();
    }

    @Test
    public void testAdd() throws Exception {
        Entity entity2 = Entity.builder((Entity)ENTITY2).key(Key.builder((Key)KEY1).name("name2").build()).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setInsert(ENTITY1.toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(Entity.builder((Key)KEY2, INCOMPLETE_ENTITY_1).build().toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(Entity.builder((Key)KEY3, INCOMPLETE_ENTITY_2).build().toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(entity2.toPb()).build());
        List entities = this.batchWriter.add(new FullEntity[]{ENTITY1, INCOMPLETE_ENTITY_1, INCOMPLETE_ENTITY_2, entity2});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
        Assert.assertEquals((Object)ENTITY1, entities.get(0));
        Assert.assertEquals((Object)Entity.builder((Key)KEY2, INCOMPLETE_ENTITY_1).build(), entities.get(1));
        Assert.assertEquals((Object)Entity.builder((Key)KEY3, INCOMPLETE_ENTITY_2).build(), entities.get(2));
        Assert.assertEquals((Object)entity2, entities.get(3));
    }

    @Test
    public void testAddAfterDelete() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY1.toPb()).build());
        this.batchWriter.delete(new Key[]{KEY1});
        this.batchWriter.add((FullEntity)ENTITY1);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test(expected=DatastoreException.class)
    public void testAddDuplicate() throws Exception {
        this.batchWriter.add((FullEntity)ENTITY1);
        this.batchWriter.add((FullEntity)ENTITY1);
    }

    @Test(expected=DatastoreException.class)
    public void testAddAfterPut() throws Exception {
        this.batchWriter.put((FullEntity)ENTITY1);
        this.batchWriter.add((FullEntity)ENTITY1);
    }

    @Test(expected=DatastoreException.class)
    public void testAddAfterUpdate() throws Exception {
        this.batchWriter.update(new Entity[]{ENTITY1});
        this.batchWriter.add((FullEntity)ENTITY1);
    }

    @Test(expected=DatastoreException.class)
    public void testAddWhenNotActive() throws Exception {
        this.batchWriter.deactivate();
        this.batchWriter.add((FullEntity)ENTITY1);
    }

    @Test
    public void testAddWithDeferredAllocation() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setInsert(INCOMPLETE_ENTITY_1.toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(INCOMPLETE_ENTITY_2.toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(ENTITY1.toPb()).build());
        this.batchWriter.addWithDeferredIdAllocation(new FullEntity[]{ENTITY1, INCOMPLETE_ENTITY_1});
        this.batchWriter.addWithDeferredIdAllocation(new FullEntity[]{INCOMPLETE_ENTITY_2});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test(expected=DatastoreException.class)
    public void testAddWithDeferredAllocationWhenNotActive() throws Exception {
        this.batchWriter.deactivate();
        this.batchWriter.addWithDeferredIdAllocation(new FullEntity[]{INCOMPLETE_ENTITY_1});
    }

    @Test
    public void testUpdate() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpdate(ENTITY1.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpdate(ENTITY2.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpdate(ENTITY3.toPb()).build());
        this.batchWriter.update(new Entity[]{ENTITY1, ENTITY2});
        this.batchWriter.update(new Entity[]{ENTITY3});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testUpdateAfterUpdate() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpdate(entity.toPb()).build());
        this.batchWriter.update(new Entity[]{ENTITY1});
        this.batchWriter.update(new Entity[]{entity});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testUpdateAfterAdd() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        this.batchWriter.add((FullEntity)ENTITY1);
        this.batchWriter.update(new Entity[]{entity});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testUpdateAfterPut() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        this.batchWriter.put((FullEntity)ENTITY1);
        this.batchWriter.update(new Entity[]{entity});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test(expected=DatastoreException.class)
    public void testUpdateAfterDelete() throws Exception {
        this.batchWriter.delete(new Key[]{KEY1});
        this.batchWriter.update(new Entity[]{ENTITY1, ENTITY2});
    }

    @Test(expected=DatastoreException.class)
    public void testUpdateWhenNotActive() throws Exception {
        this.batchWriter.deactivate();
        this.batchWriter.update(new Entity[]{ENTITY1});
    }

    @Test
    public void testPut() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY1.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY2.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY3.toPb()).build());
        List putEntities = this.batchWriter.put(new FullEntity[]{ENTITY1, ENTITY2});
        Entity putEntity = this.batchWriter.put((FullEntity)ENTITY3);
        Assert.assertEquals((Object)ENTITY1, putEntities.get(0));
        Assert.assertEquals((Object)ENTITY2, putEntities.get(1));
        Assert.assertEquals((Object)ENTITY3, (Object)putEntity);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutIncompleteKey() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY1.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpsert(Entity.builder((Key)KEY2, INCOMPLETE_ENTITY_1).build().toPb()).build());
        pbs.add(Mutation.newBuilder().setUpsert(Entity.builder((Key)KEY3, INCOMPLETE_ENTITY_2).build().toPb()).build());
        Entity putEntity = this.batchWriter.put((FullEntity)ENTITY1);
        List putEntities = this.batchWriter.put(new FullEntity[]{INCOMPLETE_ENTITY_1, INCOMPLETE_ENTITY_2});
        Assert.assertEquals((Object)ENTITY1, (Object)putEntity);
        Assert.assertEquals((Object)Entity.builder((Key)KEY2, INCOMPLETE_ENTITY_1).build(), putEntities.get(0));
        Assert.assertEquals((Object)Entity.builder((Key)KEY3, INCOMPLETE_ENTITY_2).build(), putEntities.get(1));
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutWithDeferredAllocation() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setInsert(INCOMPLETE_ENTITY_1.toPb()).build());
        pbs.add(Mutation.newBuilder().setInsert(INCOMPLETE_ENTITY_2.toPb()).build());
        pbs.add(Mutation.newBuilder().setUpsert(ENTITY1.toPb()).build());
        this.batchWriter.put((FullEntity)ENTITY1);
        this.batchWriter.putWithDeferredIdAllocation(new FullEntity[]{INCOMPLETE_ENTITY_1, INCOMPLETE_ENTITY_2});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutAfterPut() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        Entity putEntity1 = this.batchWriter.put((FullEntity)ENTITY1);
        Entity putEntity2 = this.batchWriter.put((FullEntity)entity);
        Assert.assertEquals((Object)ENTITY1, (Object)putEntity1);
        Assert.assertEquals((Object)entity, (Object)putEntity2);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutAfterAdd() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        this.batchWriter.add((FullEntity)ENTITY1);
        this.batchWriter.put((FullEntity)entity);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutAfterUpdate() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        this.batchWriter.update(new Entity[]{ENTITY1});
        Entity putEntity = this.batchWriter.put((FullEntity)entity);
        Assert.assertEquals((Object)entity, (Object)putEntity);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testPutAfterDelete() throws Exception {
        Entity entity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("foo", "bar")).build();
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setUpsert(entity.toPb()).build());
        this.batchWriter.delete(new Key[]{KEY1});
        Entity putEntity = this.batchWriter.put((FullEntity)entity);
        Assert.assertEquals((Object)entity, (Object)putEntity);
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test(expected=DatastoreException.class)
    public void testPutWhenNotActive() throws Exception {
        this.batchWriter.deactivate();
        this.batchWriter.put((FullEntity)ENTITY1);
    }

    @Test
    public void testDelete() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setDelete(KEY1.toPb()).build());
        pbs.add(Mutation.newBuilder().setDelete(KEY2.toPb()).build());
        pbs.add(Mutation.newBuilder().setDelete(KEY3.toPb()).build());
        this.batchWriter.delete(new Key[]{KEY1, KEY2});
        this.batchWriter.delete(new Key[]{KEY3});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testDeleteAfterAdd() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setInsert(INCOMPLETE_ENTITY_1.toPb()).build());
        pbs.add(Mutation.newBuilder().setDelete(KEY1.toPb()).build());
        this.batchWriter.add((FullEntity)ENTITY1);
        this.batchWriter.addWithDeferredIdAllocation(new FullEntity[]{INCOMPLETE_ENTITY_1});
        this.batchWriter.delete(new Key[]{KEY1});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testDeleteAfterUpdate() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setDelete(KEY1.toPb()).build());
        this.batchWriter.update(new Entity[]{ENTITY1});
        this.batchWriter.delete(new Key[]{KEY1});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test
    public void testDeleteAfterPut() throws Exception {
        LinkedList<Mutation> pbs = new LinkedList<Mutation>();
        pbs.add(Mutation.newBuilder().setDelete(KEY1.toPb()).build());
        this.batchWriter.put((FullEntity)ENTITY1);
        this.batchWriter.delete(new Key[]{KEY1});
        Assert.assertEquals(pbs, (Object)this.batchWriter.toMutationPbList());
    }

    @Test(expected=DatastoreException.class)
    public void testDeleteWhenNotActive() throws Exception {
        this.batchWriter.deactivate();
        this.batchWriter.delete(new Key[]{KEY1});
    }

    private class DatastoreBatchWriter
    extends BaseDatastoreBatchWriter {
        private final Datastore datastore;

        protected DatastoreBatchWriter() {
            super("test");
            this.datastore = (Datastore)EasyMock.createMock(Datastore.class);
            IncompleteKey[] expected = new IncompleteKey[]{INCOMPLETE_KEY, INCOMPLETE_KEY};
            ImmutableList result = ImmutableList.of((Object)KEY2, (Object)KEY3);
            EasyMock.expect((Object)this.datastore.allocateId(expected)).andReturn((Object)result).times(0, 1);
            EasyMock.replay((Object[])new Object[]{this.datastore});
        }

        protected Datastore datastore() {
            return this.datastore;
        }

        void finish() {
            EasyMock.verify((Object[])new Object[]{this.datastore});
        }
    }
}

