/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.PathElement;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class BaseKeyTest {
    @Test
    public void testDataset() throws Exception {
        Builder builder = new Builder("ds1", "k");
        BaseKey key = builder.build();
        Assert.assertEquals((Object)"ds1", (Object)key.projectId());
        key = ((Builder)builder.projectId("ds2")).build();
        Assert.assertEquals((Object)"ds2", (Object)key.projectId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadDatasetInConstructor() throws Exception {
        new Builder(" ", "k");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadDatasetInSetter() throws Exception {
        Builder builder = new Builder("d", "k");
        builder.projectId(" ");
    }

    @Test
    public void testNamespace() throws Exception {
        Builder builder = new Builder("ds", "k");
        BaseKey key = builder.build();
        Assert.assertTrue((key.namespace() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)key.namespace().isEmpty());
        key = ((Builder)builder.namespace("ns")).build();
        Assert.assertEquals((Object)"ns", (Object)key.namespace());
    }

    @Test
    public void testKind() throws Exception {
        Builder builder = new Builder("ds", "k1");
        BaseKey key = builder.build();
        Assert.assertEquals((Object)"k1", (Object)key.kind());
        key = ((Builder)builder.kind("k2")).build();
        Assert.assertEquals((Object)"k2", (Object)key.kind());
    }

    @Test(expected=NullPointerException.class)
    public void testNoKind() throws Exception {
        Builder builder = new Builder("ds");
        builder.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadKindInConstructor() throws Exception {
        new Builder("ds", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadKindInSetter() throws Exception {
        Builder builder = new Builder("ds", "k1");
        builder.kind("");
    }

    @Test
    public void testAncestors() throws Exception {
        Builder builder = new Builder("ds", "k");
        BaseKey key = builder.build();
        Assert.assertTrue((boolean)key.ancestors().isEmpty());
        ArrayList<PathElement> path = new ArrayList<PathElement>();
        path.add(PathElement.of((String)"p1", (String)"v1"));
        key = ((Builder)builder.ancestors((PathElement)path.get(0))).build();
        Assert.assertEquals(path, (Object)key.ancestors());
        path.add(PathElement.of((String)"p2", (String)"v2"));
        key = ((Builder)builder.ancestors((PathElement)path.get(1))).build();
        Assert.assertEquals(path, (Object)key.ancestors());
    }

    private class Builder
    extends BaseKey.Builder<Builder> {
        Builder(String projectId) {
            super(projectId);
        }

        Builder(String projectId, String kind) {
            super(projectId, kind);
        }

        protected BaseKey build() {
            ImmutableList.Builder path = ImmutableList.builder();
            path.addAll((Iterable)this.ancestors);
            path.add((Object)PathElement.of((String)this.kind));
            return new BaseKey(this.projectId, this.namespace, path.build()){

                protected Object fromPb(byte[] bytesPb) throws InvalidProtocolBufferException {
                    return null;
                }

                protected BaseKey parent() {
                    return null;
                }
            };
        }
    }
}

