/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.spi.DatastoreRpc;
import com.google.cloud.datastore.spi.DatastoreRpcFactory;
import com.google.cloud.spi.ServiceRpcFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatastoreOptionsTest {
    private static final String PROJECT_ID = "project-id";
    private static final int PORT = 8080;
    private DatastoreRpcFactory datastoreRpcFactory;
    private DatastoreRpc datastoreRpc;
    private DatastoreOptions.Builder options;

    @Before
    public void setUp() {
        this.datastoreRpcFactory = (DatastoreRpcFactory)EasyMock.createMock(DatastoreRpcFactory.class);
        this.datastoreRpc = (DatastoreRpc)EasyMock.createMock(DatastoreRpc.class);
        this.options = (DatastoreOptions.Builder)((DatastoreOptions.Builder)((DatastoreOptions.Builder)DatastoreOptions.builder().serviceRpcFactory((ServiceRpcFactory)this.datastoreRpcFactory)).projectId(PROJECT_ID)).host("http://localhost:8080");
        EasyMock.expect((Object)this.datastoreRpcFactory.create((ServiceOptions)EasyMock.anyObject(DatastoreOptions.class))).andReturn((Object)this.datastoreRpc).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.datastoreRpcFactory, this.datastoreRpc});
    }

    @Test
    public void testProjectId() throws Exception {
        Assert.assertEquals((Object)PROJECT_ID, (Object)this.options.build().projectId());
    }

    @Test
    public void testHost() throws Exception {
        Assert.assertEquals((Object)"http://localhost:8080", (Object)this.options.build().host());
    }

    @Test
    public void testNamespace() throws Exception {
        Assert.assertTrue((boolean)this.options.build().namespace().isEmpty());
        Assert.assertEquals((Object)"ns1", (Object)this.options.namespace("ns1").build().namespace());
    }

    @Test
    public void testDatastore() throws Exception {
        Assert.assertSame((Object)this.datastoreRpc, (Object)this.options.build().rpc());
    }

    @Test
    public void testToBuilder() throws Exception {
        DatastoreOptions original = this.options.namespace("ns1").build();
        DatastoreOptions copy = original.toBuilder().build();
        Assert.assertEquals((Object)original.projectId(), (Object)copy.projectId());
        Assert.assertEquals((Object)original.namespace(), (Object)copy.namespace());
        Assert.assertEquals((Object)original.host(), (Object)copy.host());
        Assert.assertEquals((Object)original.retryParams(), (Object)copy.retryParams());
        Assert.assertEquals((Object)original.authCredentials(), (Object)copy.authCredentials());
    }
}

