/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.datastore.Batch;
import com.google.cloud.datastore.BooleanValue;
import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreImpl;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreWriter;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.EntityQuery;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.KeyQuery;
import com.google.cloud.datastore.KeyValue;
import com.google.cloud.datastore.LatLng;
import com.google.cloud.datastore.LatLngValue;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.NullValue;
import com.google.cloud.datastore.PathElement;
import com.google.cloud.datastore.ProjectionEntity;
import com.google.cloud.datastore.ProjectionEntityQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.QueryResults;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.Transaction;
import com.google.cloud.datastore.Value;
import com.google.cloud.datastore.ValueType;
import com.google.cloud.datastore.spi.DatastoreRpc;
import com.google.cloud.datastore.spi.DatastoreRpcFactory;
import com.google.cloud.datastore.testing.LocalDatastoreHelper;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.datastore.v1beta3.EntityResult;
import com.google.datastore.v1beta3.Key;
import com.google.datastore.v1beta3.LookupRequest;
import com.google.datastore.v1beta3.LookupResponse;
import com.google.datastore.v1beta3.PartitionId;
import com.google.datastore.v1beta3.QueryResultBatch;
import com.google.datastore.v1beta3.ReadOptions;
import com.google.datastore.v1beta3.RunQueryRequest;
import com.google.datastore.v1beta3.RunQueryResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DatastoreTest {
    private static LocalDatastoreHelper helper = LocalDatastoreHelper.create((double)1.0);
    private static final DatastoreOptions options = helper.options();
    private static final Datastore datastore = (Datastore)options.service();
    private static final String PROJECT_ID = options.projectId();
    private static final String KIND1 = "kind1";
    private static final String KIND2 = "kind2";
    private static final String KIND3 = "kind3";
    private static final NullValue NULL_VALUE = NullValue.of();
    private static final StringValue STR_VALUE = StringValue.of((String)"str");
    private static final BooleanValue BOOL_VALUE = ((BooleanValue.Builder)BooleanValue.builder((boolean)false).excludeFromIndexes(true)).build();
    private static final IncompleteKey INCOMPLETE_KEY1 = IncompleteKey.builder((String)PROJECT_ID, (String)"kind1").build();
    private static final IncompleteKey INCOMPLETE_KEY2 = IncompleteKey.builder((String)PROJECT_ID, (String)"kind2").build();
    private static final Key KEY1 = Key.builder((IncompleteKey)INCOMPLETE_KEY1, (String)"name").build();
    private static final Key KEY2 = Key.builder((Key)KEY1, (String)"kind2", (long)1L).build();
    private static final Key KEY3 = Key.builder((Key)KEY2).name("bla").build();
    private static final Key KEY4 = Key.builder((Key)KEY2).name("newName1").build();
    private static final Key KEY5 = Key.builder((Key)KEY2).name("newName2").build();
    private static final KeyValue KEY_VALUE = KeyValue.of((Key)KEY1);
    private static final ListValue LIST_VALUE1 = ListValue.builder().addValue((Value)NULL_VALUE, new Value[0]).addValue((Value)STR_VALUE, new Value[]{BOOL_VALUE}).build();
    private static final ListValue LIST_VALUE2 = ListValue.of(Collections.singletonList(KEY_VALUE));
    private static final ListValue EMPTY_LIST_VALUE = ListValue.of(Collections.emptyList());
    private static final DateTimeValue DATE_TIME_VALUE = new DateTimeValue(DateTime.now());
    private static final LatLngValue LAT_LNG_VALUE = new LatLngValue(new LatLng(37.422035, -122.084124));
    private static final FullEntity<IncompleteKey> PARTIAL_ENTITY1 = ((FullEntity.Builder)((FullEntity.Builder)((FullEntity.Builder)FullEntity.builder((IncompleteKey)INCOMPLETE_KEY2).set("str", (Value)STR_VALUE)).set("bool", (Value)BOOL_VALUE)).set("list", (Value)LIST_VALUE1)).build();
    private static final FullEntity<IncompleteKey> PARTIAL_ENTITY2 = ((FullEntity.Builder)((FullEntity.Builder)((FullEntity.Builder)FullEntity.builder(PARTIAL_ENTITY1).remove("str")).set("bool", true)).set("list", (List)LIST_VALUE1.get())).build();
    private static final FullEntity<IncompleteKey> PARTIAL_ENTITY3 = ((FullEntity.Builder)FullEntity.builder(PARTIAL_ENTITY1).key(IncompleteKey.builder((String)PROJECT_ID, (String)"kind3").build())).build();
    private static final Entity ENTITY1 = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Key)KEY1).set("str", (Value)STR_VALUE)).set("date", (Value)DATE_TIME_VALUE)).set("latLng", (Value)LAT_LNG_VALUE)).set("bool", (Value)BOOL_VALUE)).set("partial1", (Value)EntityValue.of(PARTIAL_ENTITY1))).set("list", (Value)LIST_VALUE2)).set("emptyList", (Value)EMPTY_LIST_VALUE)).build();
    private static final Entity ENTITY2 = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY1).key(KEY2).remove("str")).set("name", "Dan")).setNull("null")).set("age", 20L)).build();
    private static final Entity ENTITY3 = ((Entity.Builder)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY1).key(KEY3).remove("str")).set("null", (Value)NULL_VALUE)).set("partial1", PARTIAL_ENTITY2)).set("partial2", (FullEntity)ENTITY2)).build();
    private DatastoreOptions rpcMockOptions;
    private DatastoreRpcFactory rpcFactoryMock;
    private DatastoreRpc rpcMock;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws IOException, InterruptedException {
        helper.start();
    }

    @Before
    public void setUp() {
        this.rpcFactoryMock = (DatastoreRpcFactory)EasyMock.createStrictMock(DatastoreRpcFactory.class);
        this.rpcMock = (DatastoreRpc)EasyMock.createStrictMock(DatastoreRpc.class);
        this.rpcMockOptions = ((DatastoreOptions.Builder)((DatastoreOptions.Builder)options.toBuilder().retryParams(RetryParams.defaultInstance())).serviceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).build();
        EasyMock.expect((Object)this.rpcFactoryMock.create((ServiceOptions)this.rpcMockOptions)).andReturn((Object)this.rpcMock);
        KeyQuery query = Query.keyQueryBuilder().build();
        QueryResults result = datastore.run((Query)query);
        datastore.delete((Key[])Iterators.toArray((Iterator)result, Key.class));
        datastore.add(new FullEntity[]{ENTITY1, ENTITY2});
    }

    @AfterClass
    public static void afterClass() throws IOException, InterruptedException {
        helper.stop();
    }

    @Test
    public void testGetOptions() {
        Assert.assertSame((Object)options, (Object)datastore.options());
    }

    @Test
    public void testNewTransactionCommit() {
        Transaction transaction = datastore.newTransaction();
        transaction.add((FullEntity)ENTITY3);
        Entity entity2 = ((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY2).clear()).setNull("bla")).build();
        transaction.update(new Entity[]{entity2});
        transaction.delete(new Key[]{KEY1});
        transaction.commit();
        List list = datastore.fetch(new Key[]{KEY1, KEY2, KEY3});
        Assert.assertNull(list.get(0));
        Assert.assertEquals((Object)entity2, list.get(1));
        Assert.assertEquals((Object)ENTITY3, list.get(2));
        Assert.assertEquals((long)3L, (long)list.size());
        try {
            transaction.commit();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        try {
            transaction.rollback();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        this.verifyNotUsable((DatastoreWriter)transaction);
    }

    @Test
    public void testTransactionWithRead() {
        Transaction transaction = datastore.newTransaction();
        Assert.assertNull((Object)transaction.get(KEY3));
        transaction.add((FullEntity)ENTITY3);
        transaction.commit();
        Assert.assertEquals((Object)ENTITY3, (Object)datastore.get(KEY3));
        transaction = datastore.newTransaction();
        Assert.assertEquals((Object)ENTITY3, (Object)transaction.get(KEY3));
        datastore.put((FullEntity)((Entity.Builder)Entity.builder((Entity)ENTITY3).clear()).build());
        transaction.update(new Entity[]{ENTITY2});
        try {
            transaction.commit();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException expected) {
            Assert.assertEquals((Object)"ABORTED", (Object)expected.reason());
        }
    }

    @Test
    public void testTransactionWithQuery() {
        EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().kind(KIND2)).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.hasAncestor((Key)KEY2))).build();
        Transaction transaction = datastore.newTransaction();
        QueryResults results = transaction.run((Query)query);
        Assert.assertEquals((Object)ENTITY2, (Object)results.next());
        Assert.assertFalse((boolean)results.hasNext());
        transaction.add((FullEntity)ENTITY3);
        transaction.commit();
        Assert.assertEquals((Object)ENTITY3, (Object)datastore.get(KEY3));
        transaction = datastore.newTransaction();
        results = transaction.run((Query)query);
        Assert.assertEquals((Object)ENTITY2, (Object)results.next());
        transaction.delete(new Key[]{(Key)ENTITY3.key()});
        datastore.put((FullEntity)((Entity.Builder)Entity.builder((Entity)ENTITY2).clear()).build());
        try {
            transaction.commit();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException expected) {
            Assert.assertEquals((Object)"ABORTED", (Object)expected.reason());
        }
    }

    @Test
    public void testNewTransactionRollback() {
        Transaction transaction = datastore.newTransaction();
        transaction.add((FullEntity)ENTITY3);
        Entity entity2 = ((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY2).clear()).setNull("bla")).set("list3", (Value)StringValue.of((String)"bla"), (Value)StringValue.builder((String)"bla").build(), new Value[0])).build();
        transaction.update(new Entity[]{entity2});
        transaction.delete(new Key[]{KEY1});
        transaction.rollback();
        transaction.rollback();
        try {
            transaction.commit();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        this.verifyNotUsable((DatastoreWriter)transaction);
        List list = datastore.fetch(new Key[]{KEY1, KEY2, KEY3});
        Assert.assertEquals((Object)ENTITY1, list.get(0));
        Assert.assertEquals((Object)ENTITY2, list.get(1));
        Assert.assertNull(list.get(2));
        Assert.assertEquals((long)3L, (long)list.size());
    }

    private void verifyNotUsable(DatastoreWriter writer) {
        try {
            writer.add((FullEntity)ENTITY3);
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        try {
            writer.put((FullEntity)ENTITY3);
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        try {
            writer.update(new Entity[]{ENTITY3});
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        try {
            writer.delete(new Key[]{(Key)ENTITY3.key()});
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException datastoreException) {
            // empty catch block
        }
    }

    @Test
    public void testNewBatch() {
        Batch batch = datastore.newBatch();
        Entity entity1 = ((Entity.Builder)Entity.builder((Entity)ENTITY1).clear()).build();
        Entity entity2 = ((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY2).clear()).setNull("bla")).build();
        Entity entity4 = ((Entity.Builder)Entity.builder((Key)KEY4).set("value", (Value)StringValue.of((String)"value"))).build();
        Entity entity5 = ((Entity.Builder)Entity.builder((Key)KEY5).set("value", "value")).build();
        List entities = batch.add(new FullEntity[]{entity4, PARTIAL_ENTITY2, entity5});
        Entity entity6 = (Entity)entities.get(1);
        Assert.assertSame((Object)entity4, entities.get(0));
        Assert.assertEquals((Object)PARTIAL_ENTITY2.properties(), (Object)entity6.properties());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key().projectId(), (Object)((Key)entity6.key()).projectId());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key().namespace(), (Object)((Key)entity6.key()).namespace());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key().ancestors(), (Object)((Key)entity6.key()).ancestors());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key().kind(), (Object)((Key)entity6.key()).kind());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key(), (Object)IncompleteKey.builder((IncompleteKey)entity6.key()).build());
        Assert.assertNotEquals((Object)PARTIAL_ENTITY2.key().path(), (Object)((Key)entity6.key()).path());
        Assert.assertNotEquals((Object)PARTIAL_ENTITY2.key(), (Object)entity6.key());
        Assert.assertSame((Object)entity5, entities.get(2));
        batch.addWithDeferredIdAllocation(new FullEntity[]{PARTIAL_ENTITY3});
        batch.put(new FullEntity[]{ENTITY3, entity1, entity2});
        Batch.Response response = batch.submit();
        entities = datastore.fetch(new Key[]{KEY1, KEY2, KEY3, (Key)entity4.key(), (Key)entity5.key(), (Key)entity6.key()});
        Assert.assertEquals((Object)entity1, entities.get(0));
        Assert.assertEquals((Object)entity2, entities.get(1));
        Assert.assertEquals((Object)ENTITY3, entities.get(2));
        Assert.assertEquals((Object)entity4, entities.get(3));
        Assert.assertEquals((Object)entity5, entities.get(4));
        Assert.assertEquals((Object)entity6, entities.get(5));
        Assert.assertEquals((long)6L, (long)entities.size());
        List generatedKeys = response.generatedKeys();
        Assert.assertEquals((long)1L, (long)generatedKeys.size());
        Assert.assertEquals((Object)PARTIAL_ENTITY3.properties(), (Object)datastore.get((Key)generatedKeys.get(0)).properties());
        Assert.assertEquals((Object)PARTIAL_ENTITY3.key(), (Object)IncompleteKey.builder((IncompleteKey)((IncompleteKey)generatedKeys.get(0))).build());
        try {
            batch.submit();
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException ex) {
            // empty catch block
        }
        this.verifyNotUsable((DatastoreWriter)batch);
        batch = datastore.newBatch();
        batch.delete(new Key[]{(Key)entity4.key(), (Key)entity5.key()});
        batch.update(new Entity[]{ENTITY1, ENTITY2, ENTITY3});
        batch.submit();
        entities = datastore.fetch(new Key[]{KEY1, KEY2, KEY3, (Key)entity4.key(), (Key)entity5.key()});
        Assert.assertEquals((Object)ENTITY1, entities.get(0));
        Assert.assertEquals((Object)ENTITY2, entities.get(1));
        Assert.assertEquals((Object)ENTITY3, entities.get(2));
        Assert.assertNull(entities.get(3));
        Assert.assertNull(entities.get(4));
        Assert.assertEquals((long)5L, (long)entities.size());
    }

    @Test
    public void testRunGqlQueryNoCasting() {
        GqlQuery query1 = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.ENTITY, (String)"select * from kind1").build();
        QueryResults results1 = datastore.run((Query)query1);
        Assert.assertTrue((boolean)results1.hasNext());
        Assert.assertEquals((Object)ENTITY1, (Object)results1.next());
        Assert.assertFalse((boolean)results1.hasNext());
        datastore.put((FullEntity)ENTITY3);
        GqlQuery query2 = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.ENTITY, (String)"select * from kind2 order by __key__").build();
        QueryResults results2 = datastore.run((Query)query2);
        Assert.assertTrue((boolean)results2.hasNext());
        Assert.assertEquals((Object)ENTITY2, (Object)results2.next());
        Assert.assertTrue((boolean)results2.hasNext());
        Assert.assertEquals((Object)ENTITY3, (Object)results2.next());
        Assert.assertFalse((boolean)results2.hasNext());
        query1 = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.ENTITY, (String)"select * from bla").build();
        results1 = datastore.run((Query)query1);
        Assert.assertFalse((boolean)results1.hasNext());
        GqlQuery keyOnlyQuery = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.KEY, (String)"select __key__ from kind1").build();
        QueryResults keyOnlyResults = datastore.run((Query)keyOnlyQuery);
        Assert.assertTrue((boolean)keyOnlyResults.hasNext());
        Assert.assertEquals((Object)KEY1, (Object)keyOnlyResults.next());
        Assert.assertFalse((boolean)keyOnlyResults.hasNext());
        GqlQuery keyProjectionQuery = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.PROJECTION_ENTITY, (String)"select __key__ from kind1").build();
        QueryResults keyProjectionResult = datastore.run((Query)keyProjectionQuery);
        Assert.assertTrue((boolean)keyProjectionResult.hasNext());
        ProjectionEntity projectionEntity = (ProjectionEntity)keyProjectionResult.next();
        Assert.assertEquals((Object)KEY1, (Object)projectionEntity.key());
        Assert.assertTrue((boolean)projectionEntity.properties().isEmpty());
        Assert.assertFalse((boolean)keyProjectionResult.hasNext());
        GqlQuery projectionQuery = Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.PROJECTION_ENTITY, (String)"select str, date from kind1").build();
        QueryResults projectionResult = datastore.run((Query)projectionQuery);
        Assert.assertTrue((boolean)projectionResult.hasNext());
        projectionEntity = (ProjectionEntity)projectionResult.next();
        Assert.assertEquals((Object)"str", (Object)projectionEntity.getString("str"));
        Assert.assertEquals((Object)DATE_TIME_VALUE.get(), (Object)projectionEntity.getDateTime("date"));
        Assert.assertEquals((long)((DateTime)DATE_TIME_VALUE.get()).timestampMicroseconds(), (long)projectionEntity.getLong("date"));
        Assert.assertEquals((long)2L, (long)projectionEntity.names().size());
        Assert.assertFalse((boolean)projectionResult.hasNext());
    }

    @Test
    public void testRunGqlQueryWithCasting() {
        GqlQuery query1 = Query.gqlQueryBuilder((String)"select * from kind1").build();
        QueryResults results1 = datastore.run((Query)query1);
        Assert.assertTrue((boolean)results1.hasNext());
        Assert.assertEquals((Object)ENTITY1, (Object)results1.next());
        Assert.assertFalse((boolean)results1.hasNext());
        GqlQuery query2 = Query.gqlQueryBuilder((String)"select * from kind1").build();
        QueryResults results2 = datastore.run((Query)query2);
        Assert.assertSame(Entity.class, (Object)results2.resultClass());
        QueryResults results3 = results2;
        Assert.assertTrue((boolean)results3.hasNext());
        Assert.assertEquals((Object)ENTITY1, (Object)results3.next());
        Assert.assertFalse((boolean)results3.hasNext());
    }

    @Test
    public void testGqlQueryPagination() throws DatastoreException {
        List<RunQueryResponse> responses = this.buildResponsesForQueryPagination();
        for (int i = 0; i < responses.size(); ++i) {
            EasyMock.expect((Object)this.rpcMock.runQuery((RunQueryRequest)EasyMock.anyObject(RunQueryRequest.class))).andReturn((Object)responses.get(i));
        }
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore mockDatastore = (Datastore)this.rpcMockOptions.service();
        QueryResults results = mockDatastore.run((Query)Query.gqlQueryBuilder((Query.ResultType)Query.ResultType.KEY, (String)"select __key__ from *").build());
        int count = 0;
        while (results.hasNext()) {
            ++count;
            results.next();
        }
        Assert.assertEquals((long)count, (long)5L);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    @Test
    public void testRunStructuredQuery() {
        EntityQuery query = ((EntityQuery.Builder)((EntityQuery.Builder)Query.entityQueryBuilder().kind(KIND1)).orderBy(StructuredQuery.OrderBy.asc((String)"__key__"), new StructuredQuery.OrderBy[0])).build();
        QueryResults results1 = datastore.run((Query)query);
        Assert.assertTrue((boolean)results1.hasNext());
        Assert.assertEquals((Object)ENTITY1, (Object)results1.next());
        Assert.assertFalse((boolean)results1.hasNext());
        KeyQuery keyOnlyQuery = ((KeyQuery.Builder)Query.keyQueryBuilder().kind(KIND1)).build();
        QueryResults results2 = datastore.run((Query)keyOnlyQuery);
        Assert.assertTrue((boolean)results2.hasNext());
        Assert.assertEquals((Object)ENTITY1.key(), (Object)results2.next());
        Assert.assertFalse((boolean)results2.hasNext());
        ProjectionEntityQuery keyOnlyProjectionQuery = ((ProjectionEntityQuery.Builder)Query.projectionEntityQueryBuilder().kind(KIND1)).projection("__key__", new String[0]).build();
        QueryResults results3 = datastore.run((Query)keyOnlyProjectionQuery);
        Assert.assertTrue((boolean)results3.hasNext());
        ProjectionEntity projectionEntity = (ProjectionEntity)results3.next();
        Assert.assertEquals((Object)ENTITY1.key(), (Object)projectionEntity.key());
        Assert.assertTrue((boolean)projectionEntity.names().isEmpty());
        Assert.assertFalse((boolean)results2.hasNext());
        ProjectionEntityQuery projectionQuery = ((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)((ProjectionEntityQuery.Builder)Query.projectionEntityQueryBuilder().kind(KIND2)).projection("age", new String[0]).filter((StructuredQuery.Filter)StructuredQuery.PropertyFilter.gt((String)"age", (long)18L))).distinctOn("age", new String[0]).orderBy(StructuredQuery.OrderBy.asc((String)"age"), new StructuredQuery.OrderBy[0])).limit(Integer.valueOf(10))).build();
        QueryResults results4 = datastore.run((Query)projectionQuery);
        Assert.assertTrue((boolean)results4.hasNext());
        ProjectionEntity entity = (ProjectionEntity)results4.next();
        Assert.assertEquals((Object)ENTITY2.key(), (Object)entity.key());
        Assert.assertEquals((long)20L, (long)entity.getLong("age"));
        Assert.assertEquals((long)1L, (long)entity.properties().size());
        Assert.assertFalse((boolean)results4.hasNext());
    }

    @Test
    public void testStructuredQueryPagination() throws DatastoreException {
        List<RunQueryResponse> responses = this.buildResponsesForQueryPagination();
        for (int i = 0; i < responses.size(); ++i) {
            EasyMock.expect((Object)this.rpcMock.runQuery((RunQueryRequest)EasyMock.anyObject(RunQueryRequest.class))).andReturn((Object)responses.get(i));
        }
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        QueryResults results = datastore.run((Query)Query.keyQueryBuilder().build());
        int count = 0;
        while (results.hasNext()) {
            ++count;
            results.next();
        }
        Assert.assertEquals((long)count, (long)5L);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    private List<RunQueryResponse> buildResponsesForQueryPagination() {
        Entity entity4 = ((Entity.Builder)Entity.builder((Key)KEY4).set("value", (Value)StringValue.of((String)"value"))).build();
        Entity entity5 = ((Entity.Builder)Entity.builder((Key)KEY5).set("value", "value")).build();
        datastore.add(new FullEntity[]{ENTITY3, entity4, entity5});
        ArrayList<RunQueryResponse> responses = new ArrayList<RunQueryResponse>();
        KeyQuery query = Query.keyQueryBuilder().build();
        RunQueryRequest.Builder requestPb = RunQueryRequest.newBuilder();
        query.populatePb(requestPb);
        QueryResultBatch queryResultBatchPb = RunQueryResponse.newBuilder().mergeFrom(((DatastoreImpl)datastore).runQuery(requestPb.build())).getBatch();
        QueryResultBatch queryResultBatchPb1 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(0, 1)).setEndCursor(((EntityResult)queryResultBatchPb.getEntityResultsList().get(0)).getCursor()).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb1).build());
        QueryResultBatch queryResultBatchPb2 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(1, 3)).setEndCursor(((EntityResult)queryResultBatchPb.getEntityResultsList().get(2)).getCursor()).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb2).build());
        QueryResultBatch queryResultBatchPb3 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(3, 5)).setEndCursor(((EntityResult)queryResultBatchPb.getEntityResultsList().get(4)).getCursor()).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb3).build());
        return responses;
    }

    public void testQueryPaginationWithLimit() throws DatastoreException {
        List<RunQueryResponse> responses = this.buildResponsesForQueryPaginationWithLimit();
        ArrayList endCursors = Lists.newArrayListWithCapacity((int)responses.size());
        for (RunQueryResponse response : responses) {
            EasyMock.expect((Object)this.rpcMock.runQuery((RunQueryRequest)EasyMock.anyObject(RunQueryRequest.class))).andReturn((Object)response);
            if (response.getBatch().getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED) continue;
            endCursors.add(response.getBatch().getEndCursor());
        }
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        int limit = 2;
        int totalCount = 0;
        Iterator cursorIter = endCursors.iterator();
        EntityQuery query = ((EntityQuery.Builder)Query.entityQueryBuilder().limit(Integer.valueOf(limit))).build();
        while (true) {
            QueryResults results = datastore.run((Query)query);
            int resultCount = 0;
            while (results.hasNext()) {
                results.next();
                ++resultCount;
                ++totalCount;
            }
            Assert.assertTrue((boolean)cursorIter.hasNext());
            Cursor expectedEndCursor = Cursor.copyFrom((byte[])((ByteString)cursorIter.next()).toByteArray());
            Assert.assertEquals((Object)expectedEndCursor, (Object)results.cursorAfter());
            if (resultCount < limit) break;
            query = query.toBuilder().startCursor(results.cursorAfter()).build();
        }
        Assert.assertEquals((long)5L, (long)totalCount);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    private List<RunQueryResponse> buildResponsesForQueryPaginationWithLimit() {
        Entity entity4 = ((Entity.Builder)Entity.builder((Key)KEY4).set("value", (Value)StringValue.of((String)"value"))).build();
        Entity entity5 = ((Entity.Builder)Entity.builder((Key)KEY5).set("value", "value")).build();
        datastore.add(new FullEntity[]{ENTITY3, entity4, entity5});
        DatastoreRpc datastoreRpc = (DatastoreRpc)((DatastoreOptions)datastore.options()).rpc();
        ArrayList<RunQueryResponse> responses = new ArrayList<RunQueryResponse>();
        EntityQuery query = Query.entityQueryBuilder().build();
        RunQueryRequest.Builder requestPb = RunQueryRequest.newBuilder();
        query.populatePb(requestPb);
        QueryResultBatch queryResultBatchPb = RunQueryResponse.newBuilder().mergeFrom(datastoreRpc.runQuery(requestPb.build())).getBatch();
        QueryResultBatch queryResultBatchPb1 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(0, 1)).setEndCursor(ByteString.copyFromUtf8((String)"a")).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb1).build());
        QueryResultBatch queryResultBatchPb2 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(1, 2)).setEndCursor(ByteString.copyFrom((byte[])new byte[]{-128})).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb2).build());
        QueryResultBatch queryResultBatchPb3 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(2, 4)).setEndCursor(ByteString.copyFromUtf8((String)"b")).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb3).build());
        QueryResultBatch queryResultBatchPb4 = QueryResultBatch.newBuilder().mergeFrom(queryResultBatchPb).setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS).clearEntityResults().addAllEntityResults(queryResultBatchPb.getEntityResultsList().subList(4, 5)).setEndCursor(ByteString.copyFromUtf8((String)"c")).build();
        responses.add(RunQueryResponse.newBuilder().setBatch(queryResultBatchPb4).build());
        return responses;
    }

    @Test
    public void testEventualConsistencyQuery() {
        ReadOptions readOption = ReadOptions.newBuilder().setReadConsistencyValue(2).build();
        com.google.datastore.v1beta3.GqlQuery query = com.google.datastore.v1beta3.GqlQuery.newBuilder().setQueryString("FROM * SELECT *").build();
        RunQueryRequest.Builder expectedRequest = RunQueryRequest.newBuilder().setReadOptions(readOption).setGqlQuery(query).setPartitionId(PartitionId.newBuilder().setProjectId(PROJECT_ID).build());
        EasyMock.expect((Object)this.rpcMock.runQuery(expectedRequest.build())).andReturn((Object)RunQueryResponse.newBuilder().build());
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        datastore.run((Query)Query.gqlQueryBuilder((String)"FROM * SELECT *").build(), new ReadOption[]{ReadOption.eventualConsistency()});
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    @Test
    public void testToUrlSafe() {
        byte[][] invalidUtf8;
        for (byte[] bytes : invalidUtf8 = new byte[][]{{-2}, {-63, -65}, {-64}, {-128}}) {
            Assert.assertFalse((boolean)ByteString.copyFrom((byte[])bytes).isValidUtf8());
            Cursor cursor = new Cursor(ByteString.copyFrom((byte[])bytes));
            Assert.assertEquals((Object)cursor, (Object)Cursor.fromUrlSafe((String)cursor.toUrlSafe()));
        }
    }

    @Test
    public void testAllocateId() {
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind(KIND1);
        IncompleteKey pk1 = keyFactory.newKey();
        Key key1 = datastore.allocateId(pk1);
        Assert.assertEquals((Object)key1.projectId(), (Object)pk1.projectId());
        Assert.assertEquals((Object)key1.namespace(), (Object)pk1.namespace());
        Assert.assertEquals((Object)key1.ancestors(), (Object)pk1.ancestors());
        Assert.assertEquals((Object)key1.kind(), (Object)pk1.kind());
        Assert.assertTrue((boolean)key1.hasId());
        Assert.assertFalse((boolean)key1.hasName());
        Assert.assertEquals((Object)Key.builder((IncompleteKey)pk1, (long)key1.id()).build(), (Object)key1);
        Key key2 = datastore.allocateId(pk1);
        Assert.assertNotEquals((Object)key1, (Object)key2);
        Assert.assertEquals((Object)Key.builder((IncompleteKey)pk1, (long)key2.id()).build(), (Object)key2);
        Key key3 = datastore.allocateId((IncompleteKey)key1);
        Assert.assertNotEquals((Object)key1, (Object)key3);
        Assert.assertEquals((Object)Key.builder((IncompleteKey)pk1, (long)key3.id()).build(), (Object)key3);
    }

    @Test
    public void testAllocateIdArray() {
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind(KIND1);
        IncompleteKey incompleteKey1 = keyFactory.newKey();
        IncompleteKey incompleteKey2 = ((KeyFactory)((KeyFactory)keyFactory.kind(KIND2)).ancestors(PathElement.of((String)KIND1, (long)10L))).newKey();
        Key key3 = keyFactory.newKey("name");
        Key key4 = keyFactory.newKey(1L);
        List result = datastore.allocateId(new IncompleteKey[]{incompleteKey1, incompleteKey2, key3, key4, incompleteKey1, key3});
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((Object)Key.builder((IncompleteKey)incompleteKey1, (long)((Key)result.get(0)).id()).build(), result.get(0));
        Assert.assertEquals((Object)Key.builder((IncompleteKey)incompleteKey1, (long)((Key)result.get(4)).id()).build(), result.get(4));
        Assert.assertEquals((Object)Key.builder((IncompleteKey)incompleteKey2, (long)((Key)result.get(1)).id()).build(), result.get(1));
        Assert.assertEquals((Object)Key.builder((Key)key3).id(((Key)result.get(2)).id().longValue()).build(), result.get(2));
        Assert.assertEquals((Object)Key.builder((Key)key3).id(((Key)result.get(5)).id().longValue()).build(), result.get(5));
        Assert.assertEquals((Object)Key.builder((Key)key4).id(((Key)result.get(3)).id().longValue()).build(), result.get(3));
    }

    @Test
    public void testGet() {
        Entity entity = datastore.get(KEY3);
        Assert.assertNull((Object)entity);
        entity = datastore.get(KEY1);
        Assert.assertEquals((Object)ENTITY1, (Object)entity);
        StringValue value1 = (StringValue)entity.getValue("str");
        Assert.assertEquals((Object)STR_VALUE, (Object)value1);
        BooleanValue value2 = (BooleanValue)entity.getValue("bool");
        Assert.assertEquals((Object)BOOL_VALUE, (Object)value2);
        ListValue value3 = (ListValue)entity.getValue("list");
        Assert.assertEquals((Object)LIST_VALUE2, (Object)value3);
        DateTimeValue value4 = (DateTimeValue)entity.getValue("date");
        Assert.assertEquals((Object)DATE_TIME_VALUE, (Object)value4);
        LatLngValue value5 = (LatLngValue)entity.getValue("latLng");
        Assert.assertEquals((Object)LAT_LNG_VALUE, (Object)value5);
        FullEntity value6 = entity.getEntity("partial1");
        Assert.assertEquals(PARTIAL_ENTITY1, (Object)value6);
        ListValue value7 = (ListValue)entity.getValue("emptyList");
        Assert.assertEquals((Object)EMPTY_LIST_VALUE, (Object)value7);
        Assert.assertEquals((long)7L, (long)entity.names().size());
        Assert.assertFalse((boolean)entity.contains("bla"));
    }

    @Test
    public void testLookupEventualConsistency() {
        ReadOptions readOption = ReadOptions.newBuilder().setReadConsistencyValue(2).build();
        com.google.datastore.v1beta3.Key key = com.google.datastore.v1beta3.Key.newBuilder().setPartitionId(PartitionId.newBuilder().setProjectId(PROJECT_ID).build()).addPath(Key.PathElement.newBuilder().setKind(KIND1).setName("name").build()).build();
        LookupRequest lookupRequest = LookupRequest.newBuilder().setReadOptions(readOption).addKeys(key).build();
        EasyMock.expect((Object)this.rpcMock.lookup(lookupRequest)).andReturn((Object)LookupResponse.newBuilder().build()).times(3);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        datastore.get(KEY1, new ReadOption[]{ReadOption.eventualConsistency()});
        datastore.get((Iterable)ImmutableList.of((Object)KEY1), new ReadOption[]{ReadOption.eventualConsistency()});
        datastore.fetch((Iterable)ImmutableList.of((Object)KEY1), new ReadOption[]{ReadOption.eventualConsistency()});
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    @Test
    public void testGetArrayNoDeferredResults() {
        datastore.put((FullEntity)ENTITY3);
        Iterator result = datastore.fetch(new Key[]{KEY1, Key.builder((Key)KEY1).name("bla").build(), KEY2, KEY3}).iterator();
        Assert.assertEquals((Object)ENTITY1, result.next());
        Assert.assertNull(result.next());
        Assert.assertEquals((Object)ENTITY2, result.next());
        Entity entity3 = (Entity)result.next();
        Assert.assertEquals((Object)ENTITY3, (Object)entity3);
        Assert.assertTrue((boolean)entity3.isNull("null"));
        Assert.assertFalse((boolean)entity3.getBoolean("bool"));
        Assert.assertEquals((Object)LIST_VALUE2.get(), (Object)entity3.getList("list"));
        FullEntity partial1 = entity3.getEntity("partial1");
        FullEntity partial2 = entity3.getEntity("partial2");
        Assert.assertEquals(PARTIAL_ENTITY2, (Object)partial1);
        Assert.assertEquals((Object)ENTITY2, (Object)partial2);
        Assert.assertEquals((Object)ValueType.BOOLEAN, (Object)entity3.getValue("bool").type());
        Assert.assertEquals((Object)LAT_LNG_VALUE, (Object)entity3.getValue("latLng"));
        Assert.assertEquals((Object)EMPTY_LIST_VALUE, (Object)entity3.getValue("emptyList"));
        Assert.assertEquals((long)8L, (long)entity3.names().size());
        Assert.assertFalse((boolean)entity3.contains("bla"));
        try {
            entity3.getString("str");
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException expected) {
            // empty catch block
        }
        Assert.assertFalse((boolean)result.hasNext());
    }

    public void testGetArrayDeferredResults() throws DatastoreException {
        HashSet<Key> requestedKeys = new HashSet<Key>();
        requestedKeys.add(KEY1);
        requestedKeys.add(KEY2);
        requestedKeys.add(KEY3);
        requestedKeys.add(KEY4);
        requestedKeys.add(KEY5);
        Iterator iter = this.createDatastoreForDeferredLookup().get(new Key[]{KEY1, KEY2, KEY3, KEY4, KEY5});
        HashSet<IncompleteKey> keysOfFoundEntities = new HashSet<IncompleteKey>();
        while (iter.hasNext()) {
            keysOfFoundEntities.add(((Entity)iter.next()).key());
        }
        Assert.assertEquals(requestedKeys, keysOfFoundEntities);
    }

    public void testFetchArrayDeferredResults() throws DatastoreException {
        List foundEntities = this.createDatastoreForDeferredLookup().fetch(new Key[]{KEY1, KEY2, KEY3, KEY4, KEY5});
        Assert.assertEquals((Object)((Entity)foundEntities.get(0)).key(), (Object)KEY1);
        Assert.assertEquals((Object)((Entity)foundEntities.get(1)).key(), (Object)KEY2);
        Assert.assertEquals((Object)((Entity)foundEntities.get(2)).key(), (Object)KEY3);
        Assert.assertEquals((Object)((Entity)foundEntities.get(3)).key(), (Object)KEY4);
        Assert.assertEquals((Object)((Entity)foundEntities.get(4)).key(), (Object)KEY5);
        Assert.assertEquals((long)foundEntities.size(), (long)5L);
    }

    private Datastore createDatastoreForDeferredLookup() throws DatastoreException {
        ArrayList<com.google.datastore.v1beta3.Key> keysPb = new ArrayList<com.google.datastore.v1beta3.Key>();
        keysPb.add(KEY1.toPb());
        keysPb.add(KEY2.toPb());
        keysPb.add(KEY3.toPb());
        keysPb.add(KEY4.toPb());
        keysPb.add(KEY5.toPb());
        ArrayList<LookupRequest> lookupRequests = new ArrayList<LookupRequest>();
        lookupRequests.add(LookupRequest.newBuilder().addAllKeys(keysPb).build());
        lookupRequests.add(LookupRequest.newBuilder().addKeys((com.google.datastore.v1beta3.Key)keysPb.get(2)).addKeys((com.google.datastore.v1beta3.Key)keysPb.get(3)).addKeys((com.google.datastore.v1beta3.Key)keysPb.get(5)).build());
        lookupRequests.add(LookupRequest.newBuilder().addKeys((com.google.datastore.v1beta3.Key)keysPb.get(5)).build());
        Entity entity4 = ((Entity.Builder)Entity.builder((Key)KEY4).set("value", (Value)StringValue.of((String)"value"))).build();
        Entity entity5 = ((Entity.Builder)Entity.builder((Key)KEY5).set("value", "value")).build();
        ArrayList<LookupResponse> lookupResponses = new ArrayList<LookupResponse>();
        lookupResponses.add(LookupResponse.newBuilder().addFound(EntityResult.newBuilder().setEntity(ENTITY1.toPb())).addFound(EntityResult.newBuilder().setEntity(entity4.toPb())).addDeferred((com.google.datastore.v1beta3.Key)keysPb.get(2)).addDeferred((com.google.datastore.v1beta3.Key)keysPb.get(3)).addDeferred((com.google.datastore.v1beta3.Key)keysPb.get(5)).build());
        lookupResponses.add(LookupResponse.newBuilder().addFound(EntityResult.newBuilder().setEntity(ENTITY3.toPb())).addFound(EntityResult.newBuilder().setEntity(entity4.toPb())).addDeferred((com.google.datastore.v1beta3.Key)keysPb.get(5)).build());
        lookupResponses.add(LookupResponse.newBuilder().addFound(EntityResult.newBuilder().setEntity(entity5.toPb())).build());
        for (int i = 0; i < lookupRequests.size(); ++i) {
            EasyMock.expect((Object)this.rpcMock.lookup((LookupRequest)lookupRequests.get(i))).andReturn(lookupResponses.get(i));
        }
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        return (Datastore)this.rpcMockOptions.service();
    }

    @Test
    public void testAddEntity() {
        List keys = datastore.fetch(new Key[]{(Key)ENTITY1.key(), (Key)ENTITY3.key()});
        Assert.assertEquals((Object)ENTITY1, keys.get(0));
        Assert.assertNull(keys.get(1));
        Assert.assertEquals((long)2L, (long)keys.size());
        try {
            datastore.add((FullEntity)ENTITY1);
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException expected) {
            // empty catch block
        }
        List entities = datastore.add(new FullEntity[]{ENTITY3, PARTIAL_ENTITY1, PARTIAL_ENTITY2});
        Assert.assertEquals((Object)ENTITY3, (Object)datastore.get((Key)ENTITY3.key()));
        Assert.assertEquals((Object)ENTITY3, entities.get(0));
        Assert.assertEquals((Object)PARTIAL_ENTITY1.properties(), (Object)((Entity)entities.get(1)).properties());
        Assert.assertEquals((Object)PARTIAL_ENTITY1.key().ancestors(), (Object)((Key)((Entity)entities.get(1)).key()).ancestors());
        Assert.assertNotNull((Object)datastore.get((Key)((Entity)entities.get(1)).key()));
        Assert.assertEquals((Object)PARTIAL_ENTITY2.properties(), (Object)((Entity)entities.get(2)).properties());
        Assert.assertEquals((Object)PARTIAL_ENTITY2.key().ancestors(), (Object)((Key)((Entity)entities.get(2)).key()).ancestors());
        Assert.assertNotNull((Object)datastore.get((Key)((Entity)entities.get(2)).key()));
    }

    @Test
    public void testUpdate() {
        List keys = datastore.fetch(new Key[]{(Key)ENTITY1.key(), (Key)ENTITY3.key()});
        Assert.assertEquals((Object)ENTITY1, keys.get(0));
        Assert.assertNull(keys.get(1));
        Assert.assertEquals((long)2L, (long)keys.size());
        try {
            datastore.update(new Entity[]{ENTITY3});
            Assert.fail((String)"Expecting a failure");
        }
        catch (DatastoreException expected) {
            // empty catch block
        }
        datastore.add((FullEntity)ENTITY3);
        Assert.assertEquals((Object)ENTITY3, (Object)datastore.get((Key)ENTITY3.key()));
        Entity entity3 = ((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY3).clear()).set("bla", (Value)new NullValue())).build();
        Assert.assertNotEquals((Object)ENTITY3, (Object)entity3);
        datastore.update(new Entity[]{entity3});
        Assert.assertEquals((Object)entity3, (Object)datastore.get((Key)ENTITY3.key()));
    }

    @Test
    public void testPut() {
        Entity updatedEntity = ((Entity.Builder)Entity.builder((Entity)ENTITY1).set("new_property", 42L)).build();
        Assert.assertEquals((Object)updatedEntity, (Object)datastore.put((FullEntity)updatedEntity));
        Assert.assertEquals((Object)updatedEntity, (Object)datastore.get((Key)updatedEntity.key()));
        Entity entity2 = ((Entity.Builder)((Entity.Builder)Entity.builder((Entity)ENTITY2).clear()).set("bla", (Value)new NullValue())).build();
        Assert.assertNotEquals((Object)ENTITY2, (Object)entity2);
        List entities = datastore.put(new FullEntity[]{ENTITY1, entity2, ENTITY3, PARTIAL_ENTITY1});
        Assert.assertEquals((Object)ENTITY1, entities.get(0));
        Assert.assertEquals((Object)entity2, entities.get(1));
        Assert.assertEquals((Object)ENTITY3, entities.get(2));
        Assert.assertEquals((Object)PARTIAL_ENTITY1.properties(), (Object)((Entity)entities.get(3)).properties());
        Assert.assertEquals((Object)PARTIAL_ENTITY1.key().ancestors(), (Object)((Key)((Entity)entities.get(3)).key()).ancestors());
        Assert.assertEquals((Object)ENTITY1, (Object)datastore.get((Key)ENTITY1.key()));
        Assert.assertEquals((Object)entity2, (Object)datastore.get((Key)entity2.key()));
        Assert.assertEquals((Object)ENTITY3, (Object)datastore.get((Key)ENTITY3.key()));
        Entity entity = datastore.get((Key)((Entity)entities.get(3)).key());
        Assert.assertEquals(entities.get(3), (Object)entity);
    }

    @Test
    public void testDelete() {
        Iterator keys = datastore.fetch(new Key[]{(Key)ENTITY1.key(), (Key)ENTITY2.key(), (Key)ENTITY3.key()}).iterator();
        Assert.assertEquals((Object)ENTITY1, keys.next());
        Assert.assertEquals((Object)ENTITY2, keys.next());
        Assert.assertNull(keys.next());
        Assert.assertFalse((boolean)keys.hasNext());
        datastore.delete(new Key[]{(Key)ENTITY1.key(), (Key)ENTITY2.key(), (Key)ENTITY3.key()});
        keys = datastore.fetch(new Key[]{(Key)ENTITY1.key(), (Key)ENTITY2.key(), (Key)ENTITY3.key()}).iterator();
        Assert.assertNull(keys.next());
        Assert.assertNull(keys.next());
        Assert.assertNull(keys.next());
        Assert.assertFalse((boolean)keys.hasNext());
    }

    @Test
    public void testKeyFactory() {
        KeyFactory keyFactory = (KeyFactory)datastore.newKeyFactory().kind(KIND1);
        Assert.assertEquals((Object)INCOMPLETE_KEY1, (Object)keyFactory.newKey());
        Assert.assertEquals((Object)((IncompleteKey.Builder)IncompleteKey.builder((IncompleteKey)INCOMPLETE_KEY1).kind(KIND2)).build(), (Object)((KeyFactory)datastore.newKeyFactory().kind(KIND2)).newKey());
        Assert.assertEquals((Object)KEY1, (Object)keyFactory.newKey("name"));
        Assert.assertEquals((Object)Key.builder((Key)KEY1).id(2L).build(), (Object)keyFactory.newKey(2L));
    }

    @Test
    public void testRetryableException() throws Exception {
        LookupRequest requestPb = LookupRequest.newBuilder().addKeys(KEY1.toPb()).build();
        LookupResponse responsePb = LookupResponse.newBuilder().addFound(EntityResult.newBuilder().setEntity(ENTITY1.toPb())).build();
        EasyMock.expect((Object)this.rpcMock.lookup(requestPb)).andThrow((Throwable)new DatastoreException(14, "UNAVAILABLE", "UNAVAILABLE", null)).andReturn((Object)responsePb);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        Entity entity = datastore.get(KEY1);
        Assert.assertEquals((Object)ENTITY1, (Object)entity);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    @Test
    public void testNonRetryableException() throws Exception {
        LookupRequest requestPb = LookupRequest.newBuilder().addKeys(KEY1.toPb()).build();
        EasyMock.expect((Object)this.rpcMock.lookup(requestPb)).andThrow((Throwable)new DatastoreException(0, "denied", "PERMISSION_DENIED")).times(1);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        this.thrown.expect(DatastoreException.class);
        this.thrown.expectMessage("denied");
        datastore.get(KEY1);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }

    @Test
    public void testRuntimeException() throws Exception {
        LookupRequest requestPb = LookupRequest.newBuilder().addKeys(KEY1.toPb()).build();
        String exceptionMessage = "Artificial runtime exception";
        EasyMock.expect((Object)this.rpcMock.lookup(requestPb)).andThrow((Throwable)new RuntimeException(exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
        Datastore datastore = (Datastore)this.rpcMockOptions.service();
        this.thrown.expect(DatastoreException.class);
        this.thrown.expectMessage(exceptionMessage);
        datastore.get(KEY1);
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.rpcMock});
    }
}

