/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import org.junit.Assert;
import org.junit.Test;

public class EntityTest {
    private static final Key KEY1 = Key.builder((String)"ds1", (String)"k1", (String)"n1").build();
    private static final Key KEY2 = Key.builder((String)"ds1", (String)"k2", (long)1L).build();
    private static final IncompleteKey INCOMPLETE_KEY = IncompleteKey.builder((String)"ds1", (String)"k2").build();
    private static final Entity ENTITY = ((Entity.Builder)Entity.builder((Key)KEY1).set("foo", "bar")).build();
    private static final FullEntity<IncompleteKey> INCOMPLETE_ENTITY = ((FullEntity.Builder)Entity.builder((IncompleteKey)INCOMPLETE_KEY).set("a", "b")).build();

    @Test
    public void testEntity() throws Exception {
        Assert.assertTrue((boolean)ENTITY.hasKey());
        Assert.assertEquals((Object)KEY1, (Object)ENTITY.key());
        Assert.assertEquals((Object)"bar", (Object)ENTITY.getString("foo"));
    }

    @Test
    public void testCopyFrom() throws Exception {
        Entity.Builder builder = Entity.builder((Entity)ENTITY);
        Assert.assertEquals((Object)ENTITY, (Object)builder.build());
        Entity entity = builder.key(KEY2).build();
        Assert.assertNotEquals((Object)ENTITY, (Object)entity);
        Assert.assertEquals((Object)KEY2, (Object)entity.key());
        Assert.assertEquals((Object)ENTITY.properties(), (Object)entity.properties());
    }

    @Test
    public void testCopyFromIncompleteEntity() throws Exception {
        Entity.Builder builder = Entity.builder((Key)KEY2, INCOMPLETE_ENTITY);
        Entity entity = builder.build();
        Assert.assertNotEquals(INCOMPLETE_ENTITY, (Object)entity);
        Assert.assertEquals((Object)INCOMPLETE_ENTITY.properties(), (Object)entity.properties());
    }
}

