/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Key;
import org.junit.Assert;
import org.junit.Test;

public class KeyTest {
    @Test
    public void testHasId() throws Exception {
        Key.Builder builder = Key.builder((String)"d", (String)"k", (long)10L);
        Key key = builder.build();
        Assert.assertTrue((boolean)key.hasId());
        key = builder.name("bla").build();
        Assert.assertFalse((boolean)key.hasId());
    }

    @Test
    public void testId() throws Exception {
        Key.Builder builder = Key.builder((String)"d", (String)"k", (long)10L);
        Key key = builder.build();
        Assert.assertEquals((Object)10L, (Object)key.id());
        key = builder.id(100L).build();
        Assert.assertEquals((Object)100L, (Object)key.id());
    }

    @Test
    public void testHasName() throws Exception {
        Key.Builder builder = Key.builder((String)"d", (String)"k", (String)"n");
        Key key = builder.build();
        Assert.assertTrue((boolean)key.hasName());
        key = builder.id(1L).build();
        Assert.assertFalse((boolean)key.hasName());
    }

    @Test
    public void testName() throws Exception {
        Key.Builder builder = Key.builder((String)"d", (String)"k", (String)"n");
        Key key = builder.build();
        Assert.assertEquals((Object)"n", (Object)key.name());
        key = builder.name("o").build();
        Assert.assertEquals((Object)"o", (Object)key.name());
    }

    @Test
    public void testNameOrId() throws Exception {
        Key.Builder builder = Key.builder((String)"d", (String)"k", (String)"n");
        Key key = builder.build();
        Assert.assertEquals((Object)"n", (Object)key.nameOrId());
        key = builder.id(1L).build();
        Assert.assertEquals((Object)1L, (Object)key.nameOrId());
    }

    @Test
    public void testToAndFromUrlSafe() throws Exception {
        Key key = Key.builder((String)"d", (String)"k", (String)"n").build();
        String urlSafe = key.toUrlSafe();
        Key copy = Key.fromUrlSafe((String)urlSafe);
        Assert.assertEquals((Object)key, (Object)copy);
    }
}

