/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import com.google.cloud.datastore.BlobValue;
import com.google.cloud.datastore.DateTime;
import com.google.cloud.datastore.DateTimeValue;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.LongValue;
import com.google.cloud.datastore.ProjectionEntity;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import org.junit.Assert;
import org.junit.Test;

public class ProjectionEntityTest {
    private static final Key KEY = Key.builder((String)"ds1", (String)"k1", (String)"n1").build();
    private static final StringValue STRING_INDEX_VALUE = ((StringValue.Builder)StringValue.builder((String)"foo").meaning(18)).build();
    private static final BlobValue BLOB_VALUE = BlobValue.of((Blob)Blob.copyFrom((byte[])new byte[]{1}));
    private static final DateTimeValue DATE_TIME_VALUE = DateTimeValue.of((DateTime)DateTime.now());
    private static final LongValue LONG_INDEX_VALUE = ((LongValue.Builder)LongValue.builder((long)((DateTime)DATE_TIME_VALUE.get()).timestampMicroseconds()).meaning(18)).build();
    private static final ProjectionEntity ENTITY1 = ((ProjectionEntity.Builder)((ProjectionEntity.Builder)new ProjectionEntity.Builder().key((IncompleteKey)KEY)).set("a", "b")).build();
    private static final ProjectionEntity ENTITY2 = ((ProjectionEntity.Builder)((ProjectionEntity.Builder)((ProjectionEntity.Builder)((ProjectionEntity.Builder)new ProjectionEntity.Builder().set("a", (Value)STRING_INDEX_VALUE)).set("b", (Value)BLOB_VALUE)).set("c", (Value)DATE_TIME_VALUE)).set("d", (Value)LONG_INDEX_VALUE)).build();

    @Test
    public void testHasKey() throws Exception {
        Assert.assertTrue((boolean)ENTITY1.hasKey());
        Assert.assertFalse((boolean)ENTITY2.hasKey());
    }

    @Test
    public void testKey() throws Exception {
        Assert.assertEquals((Object)KEY, (Object)ENTITY1.key());
        Assert.assertNull((Object)ENTITY2.key());
    }

    @Test
    public void testGetBlob() throws Exception {
        Assert.assertArrayEquals((byte[])((String)STRING_INDEX_VALUE.get()).getBytes(), (byte[])ENTITY2.getBlob("a").toByteArray());
        Assert.assertEquals((Object)BLOB_VALUE.get(), (Object)ENTITY2.getBlob("b"));
    }

    @Test
    public void testGetDateTime() throws Exception {
        Assert.assertEquals((Object)DATE_TIME_VALUE.get(), (Object)ENTITY2.getDateTime("c"));
        Assert.assertEquals((Object)DATE_TIME_VALUE.get(), (Object)ENTITY2.getDateTime("d"));
    }
}

